/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.system.BGStore;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class CGUserCareer {
    public static final int eMaxLevels = 45;
    public static final int eNumTimedLevels = 3;
    public static final int eNumSurvivalLevels = 3;
    public static final int eNumBoost = 5;
    public static final int eNumSpecialJewels = 5;
    public static boolean isStoryTutorialOn = true;
    public static boolean isSurvivalTutorialOn = true;
    public static boolean isStoryPopupInfoOn = true;
    public static boolean isSurviPopupInfoOn = true;
    public static boolean isSequencePopupInfoOn = true;
    protected static String m_szNick = new String("");
    protected static String m_szDevicePlatform;
    protected static int m_nAdventureLevel;
    public static int[] m_arrLevelScore;
    public static int[] m_arrLevelBestScore;
    public static int m_nMoney;
    public static int[] m_nBestSurvivalScore;
    public static int[] m_nBestSequenceScore;
    public static boolean[] m_arrBoostAvailable;
    public static boolean[] m_arrSpecjalJewelInfoNeeded;
    public static boolean[] m_arrWorldUnlockInfoNeeded;
    public static boolean m_bReadyToSave;

    public static void Reset() {
        int i;
        m_nAdventureLevel = 0;
        isStoryTutorialOn = true;
        isSurvivalTutorialOn = true;
        isStoryPopupInfoOn = true;
        isSurviPopupInfoOn = true;
        isSequencePopupInfoOn = true;
        m_szNick = "";
        m_szDevicePlatform = "";
        m_arrLevelScore = new int[45];
        m_arrLevelBestScore = new int[45];
        for (i = 0; i < 45; ++i) {
            CGUserCareer.m_arrLevelScore[i] = 0;
            CGUserCareer.m_arrLevelBestScore[i] = 0;
        }
        m_arrSpecjalJewelInfoNeeded = new boolean[5];
        for (i = 0; i < 5; ++i) {
            CGUserCareer.m_arrSpecjalJewelInfoNeeded[i] = true;
        }
        m_arrWorldUnlockInfoNeeded = new boolean[2];
        for (i = 0; i < 2; ++i) {
            CGUserCareer.m_arrWorldUnlockInfoNeeded[i] = true;
        }
        m_nMoney = 0;
        m_nBestSequenceScore = new int[3];
        for (i = 0; i < 3; ++i) {
            CGUserCareer.m_nBestSequenceScore[i] = 0;
        }
        m_nBestSurvivalScore = new int[3];
        for (i = 0; i < 3; ++i) {
            CGUserCareer.m_nBestSurvivalScore[i] = 0;
        }
        m_arrBoostAvailable = new boolean[5];
        CGUserCareer.m_arrBoostAvailable[0] = true;
        for (i = 1; i < 5; ++i) {
            CGUserCareer.m_arrBoostAvailable[i] = false;
        }
    }

    public static boolean IsGoodScore(int score) {
        return score > m_arrLevelScore[9];
    }

    public static void Load() {
        CGUserCareer.Reset();
        m_bReadyToSave = true;
        BGStore store = BGStore.openStoreToRead("UserCareer");
        if (store == null) {
            return;
        }
        try {
            DataInputStream inputStream = store.getInStream();
            if (inputStream != null && inputStream.available() > 0) {
                int i;
                m_nAdventureLevel = inputStream.readInt();
                m_arrLevelScore = new int[45];
                for (i = 0; i < 45; ++i) {
                    CGUserCareer.m_arrLevelScore[i] = inputStream.readInt();
                }
                m_arrLevelBestScore = new int[45];
                for (i = 0; i < 45; ++i) {
                    CGUserCareer.m_arrLevelBestScore[i] = inputStream.readInt();
                }
                m_arrSpecjalJewelInfoNeeded = new boolean[5];
                for (i = 0; i < 5; ++i) {
                    CGUserCareer.m_arrSpecjalJewelInfoNeeded[i] = inputStream.readBoolean();
                }
                m_arrWorldUnlockInfoNeeded = new boolean[2];
                for (i = 0; i < 2; ++i) {
                    CGUserCareer.m_arrWorldUnlockInfoNeeded[i] = inputStream.readBoolean();
                }
                m_nMoney = inputStream.readInt();
                for (i = 0; i < 3; ++i) {
                    CGUserCareer.m_nBestSurvivalScore[i] = inputStream.readInt();
                }
                for (i = 0; i < 3; ++i) {
                    CGUserCareer.m_nBestSequenceScore[i] = inputStream.readInt();
                }
                for (i = 0; i < m_arrBoostAvailable.length; ++i) {
                    CGUserCareer.m_arrBoostAvailable[i] = inputStream.readBoolean();
                }
                isStoryTutorialOn = inputStream.readBoolean();
                isSurvivalTutorialOn = inputStream.readBoolean();
                isStoryPopupInfoOn = inputStream.readBoolean();
                isSurviPopupInfoOn = inputStream.readBoolean();
                isSequencePopupInfoOn = inputStream.readBoolean();
            }
            store.close();
        }
        catch (Exception e) {
            CGUserCareer.Reset();
            return;
        }
    }

    public static void Save() {
        if (!m_bReadyToSave) {
            return;
        }
        if (m_arrLevelScore == null) {
            return;
        }
        if (m_arrLevelBestScore == null) {
            return;
        }
        BGStore store = BGStore.openStoreToWrite("UserCareer");
        if (store == null) {
            return;
        }
        try {
            int i;
            DataOutputStream outputStream = store.getOutStream();
            outputStream.writeInt(m_nAdventureLevel);
            for (i = 0; i < 45; ++i) {
                outputStream.writeInt(m_arrLevelScore[i]);
            }
            for (i = 0; i < 45; ++i) {
                outputStream.writeInt(m_arrLevelBestScore[i]);
            }
            for (i = 0; i < 5; ++i) {
                outputStream.writeBoolean(m_arrSpecjalJewelInfoNeeded[i]);
            }
            for (i = 0; i < 2; ++i) {
                outputStream.writeBoolean(m_arrWorldUnlockInfoNeeded[i]);
            }
            outputStream.writeInt(m_nMoney);
            for (i = 0; i < 3; ++i) {
                outputStream.writeInt(m_nBestSurvivalScore[i]);
            }
            for (i = 0; i < 3; ++i) {
                outputStream.writeInt(m_nBestSequenceScore[i]);
            }
            for (i = 0; i < m_arrBoostAvailable.length; ++i) {
                outputStream.writeBoolean(m_arrBoostAvailable[i]);
            }
            outputStream.writeBoolean(isStoryTutorialOn);
            outputStream.writeBoolean(isSurvivalTutorialOn);
            outputStream.writeBoolean(isStoryPopupInfoOn);
            outputStream.writeBoolean(isSurviPopupInfoOn);
            outputStream.writeBoolean(isSequencePopupInfoOn);
            store.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void SetAdventureLevel(int i) {
        m_nAdventureLevel = i;
    }

    public static int GetAdventureLevel() {
        return m_nAdventureLevel;
    }

    public static void SetNick(String s) {
        m_szNick = s;
    }

    public static String GetNick() {
        return m_szNick;
    }

    public static void SetDevicePlatform(String s) {
        m_szDevicePlatform = s;
    }

    public static String GetDevicePlatform() {
        return m_szDevicePlatform;
    }

    public static void UnlockAllLevels() {
        m_nAdventureLevel = 45;
        for (int i = 0; i < 45; ++i) {
            CGUserCareer.m_arrLevelScore[i] = 3;
        }
    }

    public static void UnlockAllBoosts() {
        for (int i = 0; i < m_arrBoostAvailable.length; ++i) {
            CGUserCareer.m_arrBoostAvailable[i] = true;
        }
    }

    static {
        m_nAdventureLevel = 0;
        m_arrLevelScore = new int[45];
        m_arrLevelBestScore = new int[45];
        m_nMoney = 0;
        m_bReadyToSave = false;
    }
}

