/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.project_gameplay.AchievementPopup;
import baltorogames.system.BGStore;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class CGAchievements {
    public static final int eAchi_firstMapUnlocked = 0;
    public static final int eAchi_firstMapFailed = 1;
    public static final int eAchi_firstCombo = 2;
    public static final int eAchi_firstCombox5 = 3;
    public static final int eAchi_firstCombox10 = 4;
    public static final int eAchi_fullStarsGathered = 5;
    public static final int eAchi_allMapsUnlocked = 6;
    public static final int eAchi_firstTimeInSurvival = 7;
    public static final int eAchi_60secSurvived = 8;
    public static final int eAchi_120secSurvived = 9;
    public static final int eAchi_300secSurvived = 10;
    public static final int eAchi_600secSurvived = 11;
    public static final int eAchi_1200secSurvived = 12;
    public static final int eAchi_5jewelsMatched = 13;
    public static final int eAchi_x5ComboChain = 14;
    public static final int eMaxAchievements = 15;
    protected static boolean[] arrAchievementsCompleted = new boolean[15];
    public static int m_nCurrentImmuneThiefs;
    protected static boolean m_bLoaded;

    public static void Reset() {
        for (int i = 0; i < 15; ++i) {
            CGAchievements.arrAchievementsCompleted[i] = false;
        }
        m_nCurrentImmuneThiefs = 0;
    }

    public static void completeAchievement(int nIndex) {
        if (!arrAchievementsCompleted[nIndex]) {
            CGAchievements.arrAchievementsCompleted[nIndex] = true;
            AchievementPopup.NewAchievement(nIndex);
            CGAchievements.checkAllAchievementsCompleted();
        }
    }

    public static boolean isAchievementCompleted(int nIndex) {
        return arrAchievementsCompleted[nIndex];
    }

    protected static void checkAllAchievementsCompleted() {
        for (int i = 0; i < 15; ++i) {
            if (arrAchievementsCompleted[i]) continue;
            return;
        }
    }

    public static void Load() {
        BGStore store = BGStore.openStoreToRead("Achievements");
        if (store == null) {
            System.out.println("No Achievements store!!!!!!!!!!!!!!!!!!!!!!!");
            m_bLoaded = true;
            return;
        }
        try {
            DataInputStream inputStream = store.getInStream();
            if (inputStream != null && inputStream.available() > 0) {
                for (int i = 0; i < 15; ++i) {
                    CGAchievements.arrAchievementsCompleted[i] = inputStream.readBoolean();
                }
                m_nCurrentImmuneThiefs = inputStream.readInt();
            }
            store.close();
            m_bLoaded = true;
        }
        catch (Exception e) {
            CGAchievements.Reset();
            m_bLoaded = true;
            return;
        }
    }

    public static void Save() {
        if (!m_bLoaded) {
            System.out.println("No Achievements loaded!!!!!!!!!!!!!!!!!!!!!!!");
            return;
        }
        BGStore store = BGStore.openStoreToWrite("Achievements");
        if (store == null) {
            return;
        }
        try {
            DataOutputStream outputStream = store.getOutStream();
            for (int i = 0; i < 15; ++i) {
                outputStream.writeBoolean(arrAchievementsCompleted[i]);
            }
            outputStream.writeInt(m_nCurrentImmuneThiefs);
            store.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        m_bLoaded = false;
    }
}

