/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gui.MainScreen;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;
import java.util.Vector;

public class LoadingLevelScreen
extends MainScreen {
    private int emptyBarColor = -16777216;
    private int emptyBarHeight = 30;
    private int fullBarColor = -1;
    private int fullBarHeight = 22;
    private static final int MAX_NUM_LOADING_HINTS = 4;
    private static final int NUM_PLAYED_GAMES_WE_NEED_MORE_INFO = 10;
    private static final int LEFT_RIGHT_MARGIN = 5;
    private static int numPlayedGames = 0;
    private static Random rnd = new Random();
    private int counterDraw = 0;
    private int fontID = 0;
    private Vector textLines = new Vector();
    private String levelToLoad = null;

    public LoadingLevelScreen() {
        this.drawTop = false;
        this.drawTitle = false;
        ApplicationData.soundEngine.stopMID();
        int nNr = Math.abs(ApplicationData.rnd.nextInt()) % 4;
        this.setText(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_COSMO_INFO_" + nNr));
        this.setupDrawingArea();
        ApplicationData.generalGameMode = 3;
        this.levelToLoad = "level_" + CGEngine.m_nCurrentWorld + ".lrs";
    }

    public void updateSize() {
    }

    public void drawWindowBackground() {
        super.drawWindowBackground();
    }

    public void drawWindowForeground() {
    }

    public static void deSerialize(DataInputStream dis) throws IOException {
        numPlayedGames = dis.readInt();
    }

    public static void serialize(DataOutputStream dos) throws IOException {
        dos.writeInt(numPlayedGames);
    }

    private void setupDrawingArea() {
    }

    public void setText(String newText, String separator) {
        int nLeft = 0;
        int nRight = ApplicationData.screenWidth;
        this.textLines = Utils.splitText(newText, separator, nRight - nLeft, this.fontID);
    }

    public void setText(String newText) {
        this.setText(newText, "+");
    }

    public void draw() {
        int fontHeight = ApplicationData.getFontByID(this.fontID).getFontHeight();
        int nLeft = ApplicationData.screenWidth / 20;
        int nTop = ApplicationData.screenHeight - ObjectsCache.menuSbOK.GetHeight() / 2 - this.emptyBarHeight;
        Graphic2D.SetColor(this.emptyBarColor);
        Graphic2D.FillRect(0, nTop, ApplicationData.screenWidth, this.emptyBarHeight);
        Graphic2D.SetColor(this.fullBarColor);
        Graphic2D.FillRect(0, nTop += (this.emptyBarHeight - this.fullBarHeight) / 2, this.counterDraw * ApplicationData.screenWidth / 50, this.fullBarHeight);
        int nL = this.textLines.size();
        int y = ApplicationData.screenHeight / 2;
        y -= nL * fontHeight / 2;
        if (this.counterDraw == 21) {
            // empty if block
        }
        if (this.counterDraw < 50) {
            ++this.counterDraw;
        }
    }

    public void onUpdate(float deltaTime) {
        if (this.counterDraw >= 50) {
            ApplicationData.getGame().startLoading(this.levelToLoad);
            ApplicationData.getGame().stepLoading(this.levelToLoad);
            ApplicationData.getGame().stepLoading(this.levelToLoad);
            ApplicationData.getGame().stepLoading(this.levelToLoad);
            ApplicationData.getGame().stepLoading(this.levelToLoad);
            ApplicationData.getGame().endLoading(this.levelToLoad);
            ApplicationData.generalGameMode = 4;
            CGEngine.m_bGameActive = true;
        }
    }
}

