/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.core;

import baltorogames.core.ApplicationData;
import baltorogames.core.CustomFont;
import java.util.Vector;

public class Utils {
    private static float[] cos_Table = new float[360];
    private static float[] sin_Table = new float[360];

    public static int CLAMP_INT(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static float Lerp(float f1, float f2, float d) {
        return f1 * (1.0f - d) + f2 * d;
    }

    public static boolean isPointInRect(int x, int y, int x0, int y0, int xk, int yk) {
        return x > x0 && x < xk && y > y0 && y < yk;
    }

    public static boolean isPointInRect2(int x, int y, int x0, int y0, int w, int h) {
        return Utils.isPointInRect(x, y, x0, y0, x0 + w, y0 + h);
    }

    public static boolean parseNetResults(Vector outNicks, Vector outTimes, String textToParse) {
        int indexOfDolar = 0;
        int currentIndex;
        while ((currentIndex = textToParse.indexOf(36, indexOfDolar)) != -1) {
            outNicks.addElement(textToParse.substring(indexOfDolar, currentIndex));
            indexOfDolar = currentIndex + 1;
            currentIndex = textToParse.indexOf(36, indexOfDolar);
            if (currentIndex == -1) {
                return false;
            }
            outTimes.addElement(textToParse.substring(indexOfDolar, currentIndex));
            indexOfDolar = currentIndex + 1;
        }
        return true;
    }

    public static String urlEncoder(String s) {
        if (s == null) {
            return s;
        }
        StringBuffer sb = new StringBuffer(s.length() * 3);
        try {
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == '&') {
                    sb.append("&");
                    continue;
                }
                if (c == ' ') {
                    sb.append('+');
                    continue;
                }
                if (c >= ',' && c <= ';' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || c == '?') {
                    sb.append(c);
                    continue;
                }
                sb.append('%');
                if (c > '\u000f') {
                    sb.append(Integer.toHexString(c));
                    continue;
                }
                sb.append("0" + Integer.toHexString(c));
            }
        }
        catch (Exception ex) {
            return null;
        }
        return sb.toString();
    }

    public static boolean intersection(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        float d = (y4 - y3) * (x2 - x1) - (x4 - x3) * (y2 - y1);
        if (d == 0.0f) {
            return false;
        }
        float xi = ((x4 - x3) * (y1 - y3) - (y4 - y3) * (x1 - x3)) / d;
        float yi = ((x2 - x1) * (y1 - y3) - (y2 - y1) * (x1 - x3)) / d;
        return xi > 0.0f && xi < 1.0f && yi > 0.0f && yi < 1.0f;
    }

    public static float sqrDist(float x0, float y0, float x1, float y1, float x2, float y2) {
        return Math.abs((x2 - x1) * (y1 - y0) - (x1 - x0) * (y2 - y1)) / (float)Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
    }

    public static void initTRIGONOMETRY() {
        for (int i = 0; i < 360; ++i) {
            Utils.cos_Table[i] = (float)Math.cos(Math.toRadians(i));
            Utils.sin_Table[i] = (float)Math.sin(Math.toRadians(i));
        }
    }

    public static float COS(float _angle) {
        int angle = (int)_angle % 360;
        if (angle < 0) {
            angle += 360;
        }
        return cos_Table[angle];
    }

    public static float SIN(float _angle) {
        int angle = (int)_angle % 360;
        if (angle < 0) {
            angle += 360;
        }
        return sin_Table[angle];
    }

    public static Vector splitText(String newText, String separator) {
        return Utils.splitText(newText, separator, ApplicationData.screenWidth, 0);
    }

    public static Vector splitText(String newText, String separator, int screenWidth) {
        return Utils.splitText(newText, separator, screenWidth, 0);
    }

    public static Vector splitText(String newText, String separator, int screenWidth, int fondID) {
        int currentIndex = 0;
        Vector<String> textLines = new Vector<String>();
        separator = ApplicationData.defaultFont.encodeDynamicString(separator);
        int sep = 255;
        while (true) {
            int end;
            if ((end = newText.indexOf(sep, currentIndex)) == -1) {
                if (currentIndex >= newText.length()) break;
                textLines.addElement(newText.substring(currentIndex, newText.length()));
                break;
            }
            textLines.addElement(newText.substring(currentIndex, end));
            currentIndex = end + 1;
        }
        if (textLines.size() == 0) {
            textLines.addElement(newText);
        }
        return Utils.fitWidth(textLines, screenWidth, fondID);
    }

    public static Vector fitWidth(Vector inputLines, int screenWidth, int fondID) {
        int currentIndex = 0;
        Vector<String> textLines = new Vector<String>();
        String separator = ApplicationData.defaultFont.encodeDynamicString(" ");
        String newLine = new String();
        block0: for (int i = 0; i < inputLines.size(); ++i) {
            String newText = (String)inputLines.elementAt(i);
            currentIndex = 0;
            newLine = new String();
            while (true) {
                int end;
                if ((end = newText.indexOf(separator, currentIndex)) == -1) {
                    String spare = newLine + newText.substring(currentIndex);
                    if (Utils.stringWidth(spare, fondID) >= screenWidth) {
                        textLines.addElement(newLine);
                        textLines.addElement(newText.substring(currentIndex));
                        continue block0;
                    }
                    textLines.addElement(spare);
                    continue block0;
                }
                String newLine2 = newLine + newText.substring(currentIndex, end + 1);
                if (Utils.stringWidth(newLine2, fondID) >= screenWidth) {
                    textLines.addElement(newLine);
                    newLine = newText.substring(currentIndex, end + 1);
                } else {
                    newLine = newLine + newText.substring(currentIndex, end + 1);
                }
                currentIndex = end + 1;
            }
        }
        return textLines;
    }

    public static int stringWidth(String s, int color) {
        return (int)ApplicationData.getFontByID(color).stringWidth(s);
    }

    public static void drawTimeString(long _currentTime, int x, int y, int center, int color) {
        ApplicationData.getFontByID(color).drawTimeString(_currentTime, x, y, center);
    }

    public static void drawString(String s, int x, int y, int center, int color) {
        ApplicationData.getFontByID(color).drawString(s, x, y, center);
    }

    public static void drawString(Vector text, int x, int y, int center, int color) {
        CustomFont font = ApplicationData.getFontByID(color);
        int fontHeight = font.getFontHeight();
        if ((center & 0x20) != 0) {
            int i = text.size() - 1;
            int j = 0;
            while (i >= 0) {
                font.drawString((String)text.elementAt(i), x, y - j * fontHeight, center);
                --i;
                ++j;
            }
        } else if ((center & 2) != 0) {
            int vCenter = fontHeight * text.size() / 2;
            for (int i = 0; i < text.size(); ++i) {
                font.drawString((String)text.elementAt(i), x, y + i * fontHeight - vCenter, center);
            }
        } else {
            for (int i = 0; i < text.size(); ++i) {
                font.drawString((String)text.elementAt(i), x, y + i * fontHeight, center);
            }
        }
    }

    public static String formatTimeAsc(long time) {
        StringBuffer sb = new StringBuffer();
        long seconds = time / 1000L;
        long m = seconds / 60L;
        long s = seconds % 60L;
        long mm = time % 1000L / 10L;
        if (m < 10L) {
            sb.append(0);
        }
        sb.append(m);
        sb.append(":");
        if (s < 10L) {
            sb.append(0);
        }
        sb.append(s);
        sb.append(":");
        if (mm < 10L) {
            sb.append(0);
        }
        sb.append(mm);
        return sb.toString();
    }
}

