/*
 * Decompiled with CFR 0.152.
 */
package com.c2m.screens.games;

import com.c2m.screens.Help;
import com.c2m.screens.Menu;
import com.c2m.screens.Screen;
import com.c2m.screens.games.questions.Question;
import com.c2m.screens.games.questions.QuestionListener;
import com.c2m.screens.games.timers.Timer;
import com.c2m.screens.games.timers.TimerListener;
import com.c2m.screens.popups.Ingame;
import com.c2m.screens.popups.Popup;
import com.c2m.screens.popups.PopupListener;
import com.c2m.screens.popups.Quit;
import com.c2m.utils.C;
import com.c2m.utils.F;
import com.c2m.utils.R;
import com.c2m.utils.T;
import com.c2m.utils.U;
import javax.microedition.lcdui.Graphics;

public abstract class Game
extends Screen
implements Runnable,
TimerListener,
QuestionListener,
PopupListener {
    protected int totalCorrectAnswers = 0;
    protected int totalWrongAnswers = 0;
    protected int selected = this.hasPointerEvents() ? -1 : 0;
    protected int nextQuestionCountDown = -1;
    protected int lastQuestionType = U.rand(4);
    protected Question question;
    protected final Timer timer;
    protected boolean gameOver = false;
    protected final int lastGlobalScore = this.getGlobalScore();
    public static final R[] activeResources = new R[]{R.BG_BLUE, R.RED_BUTTON, R.QUESTION_FRAME, R.SOFT_KEY_ELEMENTS, R.BLUE_FONT, R.ANIMATED_TEXT, R.BG_BLUE_ELEMENTS0, R.CABLE, R.SHAPES, R.FLAGS, R.VISUAL_MATH, R.CORRECT_ANSWER_SOUND, R.WRONG_ANSWER_SOUND, R.NEW_QUESTION_SOUND};
    private static final byte[] COMPLETE = new byte[]{0};

    protected abstract void drawBackground(Graphics var1);

    protected abstract Timer createTimer();

    protected abstract void nextQuestion();

    protected abstract void onGameOver(boolean var1);

    public Game() {
        this.timer = this.createTimer();
        this.nextQuestion();
    }

    protected void onSet() {
        this.schedule(this, 0L);
    }

    protected void onPaint(Graphics g) {
        g.drawImage(R.BG_BLUE.i, 0, 0, 20);
        if (F.SEQUEL_NO < 2) {
            g.drawImage(R.BG_BLUE_ELEMENTS0.i, C.WIDTH / 2, C.GAME_BG_ELEMENTS_Y, 3);
        }
        g.drawImage(R.QUESTION_FRAME.i, C.QUESTION_FRAME_POS[0], C.QUESTION_FRAME_POS[1], 3);
        this.drawBackground(g);
        this.question.onPaint(g);
        this.drawSoftKey(g, C.SOFT_KEYS[1][0] + C.SOFT_KEYS[1][2] / 2, C.SOFT_KEYS[1][1] + C.SOFT_KEYS[1][3] / 2, 0, 0, this.noSoftState != 0);
        this.timer.onPaint(g, this.popup);
    }

    protected void drawPip(Graphics g, int x, int y, int type) {
        g.drawRegion(R.PIPS.i, C.PIPS_FRAMES[type][0], C.PIPS_FRAMES[type][1], C.PIPS_FRAMES[type][2], C.PIPS_FRAMES[type][3], 0, x, y, 3);
    }

    public final void run() {
        if (this.popup == null) {
            if (this.gameOver) {
                this.onGameOver(false);
            } else {
                if (this.nextQuestionCountDown-- == 0) {
                    this.nextQuestion();
                }
                this.doPaint();
                this.schedule(this, 25L);
            }
        }
    }

    protected void onTouch(int x, int y) {
        if (U.pointIn(x, y, C.SOFT_KEYS[1])) {
            this.onAction(1);
        } else {
            this.question.onTouch(x, y);
        }
    }

    protected void onAction(int i) {
        this.drawSoftKey(this.getGraphics(), C.SOFT_KEYS[1][0] + C.SOFT_KEYS[1][2] / 2, C.SOFT_KEYS[1][1] + C.SOFT_KEYS[1][3] / 2, 0, 0, true);
        this.click(true);
        this.timer.pause();
        this.popup = new Ingame(this);
        this.doPaint();
    }

    public void onPopupAction(Popup popup, int i) {
        if (popup instanceof Quit) {
            if (i == 0) {
                Game.setScreen(new Menu());
            } else {
                this.popup = null;
                this.timer.resume();
                this.doPaint();
                this.schedule(this, 0L);
            }
        } else if (popup instanceof Ingame) {
            switch (i) {
                case 0: {
                    this.popup = null;
                    this.timer.resume();
                    this.doPaint();
                    this.schedule(this, 0L);
                    break;
                }
                case 1: {
                    Screen.setScreen(new Help(this, T.HELP_TEXTS));
                    break;
                }
                default: {
                    this.popup = new Quit(this);
                    this.doPaint();
                }
            }
        }
    }

    protected void onKey(int k) {
        block28: {
            block25: {
                block26: {
                    block27: {
                        if (this.hasPointerEvents()) break block25;
                        if (this.selected < 0) break block26;
                        if (this.noSoftState != 0) break block27;
                        switch (this.getGameAction(k)) {
                            case 1: 
                            case 6: 
                            case 8: {
                                this.question.onKey(k);
                                this.doPaint();
                                break;
                            }
                            case 5: {
                                if (noSoft) {
                                    this.noSoftState = 2;
                                    Question.setNoSoft(true);
                                    this.doPaint();
                                    break;
                                }
                                break block26;
                            }
                            default: {
                                if (C.DEBUG == 1) {
                                    boolean b = true;
                                    switch (k) {
                                        case 49: {
                                            Question.debugType = (Question.debugType + 3) % 4;
                                            break;
                                        }
                                        case 50: {
                                            Question.debugType = (Question.debugType + 1) % 4;
                                            break;
                                        }
                                        case 51: {
                                            Question.debugLevel = (Question.debugLevel + 9) % 10;
                                            break;
                                        }
                                        case 52: {
                                            Question.debugLevel = (Question.debugLevel + 1) % 10;
                                            break;
                                        }
                                        case 53: {
                                            Question.debugRandom = (Question.debugRandom + 5) % 6;
                                            break;
                                        }
                                        case 54: {
                                            Question.debugRandom = (Question.debugRandom + 1) % 6;
                                            break;
                                        }
                                        case 55: 
                                        case 56: {
                                            break;
                                        }
                                        case 57: {
                                            Question.debugIsOn = !Question.debugIsOn;
                                            break;
                                        }
                                        case 48: {
                                            this.timer.reset();
                                            this.question = Question.create(this, 0, 0);
                                            break;
                                        }
                                        default: {
                                            b = false;
                                        }
                                    }
                                    if (b) {
                                        this.getGraphics().drawString("" + Question.debugIsOn + ", T:" + Question.debugType + ", L:" + Question.debugLevel + ", QT:" + Question.debugRandom, 0, 0, 20);
                                        this.flushGraphics();
                                    }
                                }
                                if (this.determineRightSoft(k)) {
                                    this.onAction(1);
                                    break;
                                }
                                break block26;
                            }
                        }
                        break block26;
                    }
                    switch (this.getGameAction(k)) {
                        case 2: {
                            this.noSoftState = 0;
                            Question.setNoSoft(false);
                            this.doPaint();
                            break;
                        }
                        case 8: {
                            this.noSoftState = 0;
                            Question.setNoSoft(false);
                            this.onAction(1);
                        }
                    }
                }
                if (noSoft && (k == 82 || k == 4)) {
                    this.onAction(1);
                }
                break block28;
            }
            if (k == 82 || k == 4) {
                this.onAction(1);
            }
        }
    }

    protected void onHideNotify() {
        if (this.popup == null) {
            this.onAction(1);
        }
    }

    protected int getRecord() {
        return F.loadInt("GAME_RECORD_" + this.getClass().getName());
    }

    protected void setRecord(int score) {
        F.saveInt("GAME_RECORD_" + this.getClass().getName(), score);
    }

    protected void complete() {
        F.saveBytes("GAME_COMPLETE_" + this.getClass().getName(), COMPLETE);
    }
}

