/*
 * Decompiled with CFR 0.152.
 */
package com.c2m.utils;

import com.c2m.utils.F;
import com.c2m.utils.R;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;

public class Sound
implements PlayerListener {
    private static final boolean multiSounds;
    private static boolean isActive;
    private static final Vector players;
    private final String filename;
    private Player player = null;
    private static Player sPlayer;

    public Sound(String filename) {
        this.filename = filename;
        if (multiSounds) {
            try {
                this.player = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream(filename), (String)R.SOUND_MIME);
                this.player.addPlayerListener((PlayerListener)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void setActive(boolean t) {
        isActive = t;
        F.saveInt("SOUND_ACTIVE", isActive ? 1 : 0);
        if (!isActive) {
            Sound.stopAll();
        }
    }

    public static boolean isActive() {
        return isActive;
    }

    public synchronized void play(boolean stopOthers) {
        block17: {
            if (isActive) {
                try {
                    if (multiSounds) {
                        if (stopOthers) {
                            Sound.stopAll();
                        }
                        if (!players.contains(this.player)) {
                            players.addElement(this.player);
                        }
                        try {
                            if (this.player.getState() == 400) {
                                this.player.stop();
                                if (this.player.getState() == 300) {
                                    this.player.deallocate();
                                }
                            }
                            if (this.player.getState() == 100) {
                                this.player.realize();
                            }
                            if (this.player.getState() == 200) {
                                this.player.prefetch();
                            }
                            try {
                                this.player.start();
                                break block17;
                            }
                            catch (Throwable t) {
                                throw new MediaException("Throwble thown by p.start");
                            }
                        }
                        catch (MediaException ex) {
                            Sound.stopAll();
                            if (this.player.getState() == 100) {
                                this.player.realize();
                            }
                            if (this.player.getState() == 200) {
                                this.player.prefetch();
                            }
                            this.player.start();
                        }
                        break block17;
                    }
                    if (sPlayer != null) {
                        sPlayer.stop();
                        sPlayer.close();
                    }
                    sPlayer = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream(this.filename), (String)R.SOUND_MIME);
                    sPlayer.start();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public static void stopAll() {
        if (multiSounds) {
            for (int i = 0; i < players.size(); ++i) {
                Player p = (Player)players.elementAt(i);
                if (p.getState() == 400) {
                    try {
                        p.stop();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (p.getState() != 300) continue;
                p.deallocate();
            }
            players.removeAllElements();
        } else if (sPlayer != null) {
            try {
                sPlayer.stop();
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                sPlayer.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            sPlayer = null;
        }
    }

    public void close() {
        if (multiSounds) {
            try {
                this.player.stop();
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                this.player.close();
            }
            catch (Throwable t) {}
        } else if (sPlayer != null) {
            try {
                sPlayer.stop();
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                sPlayer.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            sPlayer = null;
        }
    }

    public synchronized void playerUpdate(Player player, String event, Object eventData) {
        if (event.equals("endOfMedia")) {
            try {
                players.removeElement(player);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    static {
        String ver;
        if (F.loadInt("SOUND_ACTIVE") == Integer.MIN_VALUE) {
            F.saveInt("SOUND_ACTIVE", 1);
        }
        isActive = F.loadInt("SOUND_ACTIVE") == 1;
        boolean b = false;
        if (!"false".equals(System.getProperty("supports.mixing"))) {
            // empty if block
        }
        if ((ver = System.getProperty("microediton.media.version")) != null && ver.length() > 0) {
            int v = 0;
            for (int i = 0; i < ver.length(); ++i) {
                char c = ver.charAt(i);
                if (!Character.isDigit(c)) continue;
                v = v * 10 + c - 48;
            }
            if (v >= 12) {
                b = true;
            }
        }
        multiSounds = b;
        players = new Vector();
        sPlayer = null;
    }
}

