/*
 * Decompiled with CFR 0.152.
 */
package com.c2m.screens.games.questions;

import com.c2m.screens.games.questions.QuestionListener;
import com.c2m.screens.games.questions.TextQuestion;
import com.c2m.utils.C;
import com.c2m.utils.R;
import com.c2m.utils.T;
import com.c2m.utils.U;
import javax.microedition.lcdui.Graphics;

public class ShapesQuestion
extends TextQuestion {
    private static final int[] COLORS = new int[]{0, 1, 2, 3};
    private static final int[] SHAPES = new int[]{0, 1, 2, 3};
    private static final int[] FRAMES = new int[]{0, 1, 4, 7};
    private static final int COLOR = 0;
    private static final int SHAPE = 1;
    private static final int FRAME = 2;
    private static final int ROTATE = 3;
    private final int[][] shapes = new int[9][4];

    protected ShapesQuestion(int type, QuestionListener questionListener, int level, int randNum) {
        super(type, questionListener, level, randNum);
        String[] t = this.generate();
        this.title = t[0];
        this.subtitle = t[1];
        System.arraycopy(t, 2, this.answers, 0, this.answers.length);
        this.shuffleAnswers();
    }

    public void onPaint(Graphics g) {
        for (int i = 0; i < this.shapes.length; ++i) {
            int[] f = C.SHAPES_FRAMES[this.shapes[i][2]];
            if (C.SHAPE_LEVEL_SHAKING[this.level] == 1) {
                g.drawRegion(R.SHAPES.i[this.shapes[i][0]], f[0], f[1], f[2], f[3], this.shapes[i][3], C.SHAPE_LEFT_MARGIN + (C.WIDTH - C.SHAPE_LEFT_MARGIN - C.SHAPE_RIGHT_MARGIN) * i / this.shapes.length - 2 + U.rand(5), C.SHAPE_Y - 2 + U.rand(5), 3);
                continue;
            }
            g.drawRegion(R.SHAPES.i[this.shapes[i][0]], f[0], f[1], f[2], f[3], this.shapes[i][3], C.SHAPE_LEFT_MARGIN + (C.WIDTH - C.SHAPE_LEFT_MARGIN - C.SHAPE_RIGHT_MARGIN) * i / this.shapes.length, C.SHAPE_Y - 2, 3);
        }
        super.onPaint(g);
    }

    protected void drawQuestion(Graphics g) {
        R.BLUE_FONT.f.drawString(g, this.title, C.QUESTION_FRAME_POS[0], C.SHAPE_QUESTION_TITLE_Y, 2);
        R.BLUE_FONT.f.drawString(g, this.subtitle, C.QUESTION_FRAME_POS[0], C.SHAPE_QUESTION_SUBTITLE_Y, 2);
    }

    private String[] generate() {
        U.suffle(COLORS);
        U.suffle(SHAPES);
        for (int i = 0; i < this.shapes.length; ++i) {
            this.shapes[i][0] = COLORS[U.rand(C.SHAPE_LEVEL_COLORS[this.level])];
            this.shapes[i][1] = SHAPES[U.rand(C.SHAPE_LEVEL_SHAPES[this.level])];
            this.shapes[i][2] = FRAMES[this.shapes[i][1]];
            if (this.shapes[i][1] > 1 && C.SHAPE_LEVEL_ROTATIONS[this.level] > 0) {
                int[] nArray = this.shapes[i];
                nArray[2] = nArray[2] + U.rand(3);
                this.shapes[i][3] = U.rand(8);
                continue;
            }
            this.shapes[i][3] = 0;
        }
        int t = C.SHAPE_LEVEL_MIN_QUESTION_TYPE[this.level] + this.randNum % (C.SHAPE_LEVEL_MAX_QUESTION_TYPE[this.level] - C.SHAPE_LEVEL_MIN_QUESTION_TYPE[this.level] + 1);
        switch (t) {
            case 0: {
                int c = COLORS[U.rand(C.SHAPE_LEVEL_COLORS[this.level])];
                int s = SHAPES[U.rand(C.SHAPE_LEVEL_SHAPES[this.level])];
                int r = this.countShapesColors(s, c);
                return this.generateResponse(T.SHAPES_TEXTS[0], new String[]{T.SHAPES_COLORS[c], T.SHAPES_SHAPES[s + 4]}, r);
            }
            case 1: {
                int c = COLORS[U.rand(C.SHAPE_LEVEL_COLORS[this.level])];
                int r = this.countColors(c);
                return this.generateResponse(T.SHAPES_TEXTS[1], new String[]{T.SHAPES_COLORS[c]}, r);
            }
            case 2: {
                int s = SHAPES[U.rand(C.SHAPE_LEVEL_SHAPES[this.level])];
                int r = this.countShapes(s);
                return this.generateResponse(T.SHAPES_TEXTS[2], new String[]{T.SHAPES_SHAPES[s]}, r);
            }
            case 3: {
                int c = COLORS[U.rand(C.SHAPE_LEVEL_COLORS[this.level])];
                int s = SHAPES[U.rand(C.SHAPE_LEVEL_SHAPES[this.level])];
                int r = this.countColorsNotShapes(s, c);
                return this.generateResponse(T.SHAPES_TEXTS[3], new String[]{T.SHAPES_COLORS[c], T.SHAPES_SHAPES[s + 8]}, r);
            }
            case 4: {
                int c = COLORS[U.rand(C.SHAPE_LEVEL_COLORS[this.level])];
                int s = SHAPES[U.rand(C.SHAPE_LEVEL_SHAPES[this.level])];
                int r = this.countShapesNotColors(s, c);
                return this.generateResponse(T.SHAPES_TEXTS[4], new String[]{T.SHAPES_SHAPES[s], T.SHAPES_COLORS[c]}, r);
            }
        }
        int c0 = COLORS[U.rand(C.SHAPE_LEVEL_COLORS[this.level])];
        int s0 = SHAPES[U.rand(C.SHAPE_LEVEL_SHAPES[this.level])];
        int c1 = COLORS[U.rand(C.SHAPE_LEVEL_COLORS[this.level])];
        int s1 = SHAPES[U.rand(C.SHAPE_LEVEL_SHAPES[this.level])];
        while (c0 == c1 && s0 == s1) {
            c1 = COLORS[U.rand(C.SHAPE_LEVEL_COLORS[this.level])];
            s1 = SHAPES[U.rand(C.SHAPE_LEVEL_SHAPES[this.level])];
        }
        int r = this.countShapesColors(s0, c0) + this.countShapesColors(s1, c1);
        return this.generateResponse(T.SHAPES_TEXTS[5], new String[]{T.SHAPES_COLORS[c0], T.SHAPES_SHAPES[s0 + 4], T.SHAPES_COLORS[c1], T.SHAPES_SHAPES[s1 + 4]}, r);
    }

    private String[] generateResponse(String[] line, String[] options, int answer) {
        String title = null;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < line.length; ++i) {
            if (line[i].length() == 0) {
                title = sb.toString();
                sb = new StringBuffer();
                continue;
            }
            if (line[i].length() == 1 && line[i].charAt(0) >= '0' && line[i].charAt(0) <= '9') {
                sb.append(options[line[i].charAt(0) - 48]);
                continue;
            }
            sb.append(line[i]);
        }
        String subtitle = sb.toString();
        int c = answer - 3 + U.rand(4);
        if (c < 0) {
            c = 0;
        }
        int[] a = new int[3];
        for (int i = 0; i < 3; ++i) {
            if (c == answer) {
                // empty if block
            }
            a[i] = ++c;
            ++c;
        }
        return new String[]{title, subtitle, "" + answer, "" + a[0], "" + a[1], "" + a[2]};
    }

    private int countShapesColors(int shape, int color) {
        int c = 0;
        for (int i = 0; i < this.shapes.length; ++i) {
            if (this.shapes[i][1] != shape || this.shapes[i][0] != color) continue;
            ++c;
        }
        return c;
    }

    private int countShapes(int shape) {
        int c = 0;
        for (int i = 0; i < this.shapes.length; ++i) {
            if (this.shapes[i][1] != shape) continue;
            ++c;
        }
        return c;
    }

    private int countColors(int color) {
        int c = 0;
        for (int i = 0; i < this.shapes.length; ++i) {
            if (this.shapes[i][0] != color) continue;
            ++c;
        }
        return c;
    }

    private int countShapesNotColors(int shape, int color) {
        int c = 0;
        for (int i = 0; i < this.shapes.length; ++i) {
            if (this.shapes[i][1] != shape || this.shapes[i][0] == color) continue;
            ++c;
        }
        return c;
    }

    private int countColorsNotShapes(int shape, int color) {
        int c = 0;
        for (int i = 0; i < this.shapes.length; ++i) {
            if (this.shapes[i][1] == shape || this.shapes[i][0] != color) continue;
            ++c;
        }
        return c;
    }
}

