/*
 * Decompiled with CFR 0.152.
 */
package com.c2m.screens.games;

import com.c2m.screens.Machine;
import com.c2m.screens.games.Game;
import com.c2m.screens.games.questions.Question;
import com.c2m.screens.games.timers.SandTimer;
import com.c2m.screens.games.timers.Timer;
import com.c2m.screens.popups.Ingame;
import com.c2m.screens.popups.Quit;
import com.c2m.utils.A;
import com.c2m.utils.C;
import com.c2m.utils.R;
import com.c2m.utils.U;
import java.io.ByteArrayOutputStream;
import javax.microedition.lcdui.Graphics;

public class Risk
extends Game {
    private final int[] pips = new int[C.DETERMINATION_PIPS.length / 2];
    private int currentQuestion = 0;
    private int questionLevel = 0;
    private int maxAnswerTime = 0;
    private static final R[][] activeResources = new R[][]{{R.RISK_BG_ELEMENT, R.BOMBS}, Game.activeResources, SandTimer.activeResources, Ingame.activeResources, Quit.activeResources};

    public Risk() {
        this.pips[0] = 1;
        for (int i = 1; i < this.pips.length; ++i) {
            this.pips[i] = 2;
        }
    }

    protected Timer createTimer() {
        return Timer.createSand(this, C.SPONTANEITY_TIMER);
    }

    protected void drawBackground(Graphics g) {
        g.drawImage(R.RISK_BG_ELEMENT.i, C.DETERMINATION_BG_ELEMENT_X, C.DETERMINATION_BG_ELEMENT_Y, 20);
        this.drawCables(g, C.PERFECTIONISM_CABLES);
        for (int i = 0; i < C.DETERMINATION_PIPS.length; i += 2) {
            this.drawBomb(g, C.DETERMINATION_PIPS[i], C.DETERMINATION_PIPS[i + 1], this.pips[i / 2]);
        }
    }

    protected R[][] getActiveResources() {
        return activeResources;
    }

    protected void nextQuestion() {
        this.timer.reset();
        if (this.currentQuestion >= C.DETERMINATION_PIPS.length / 2 - 1 || this.pips != null && this.pips[this.currentQuestion] == 4) {
            this.gameOver = true;
        } else {
            R.NEW_QUESTION_SOUND.s.play(true);
            this.question = Question.create(this, (this.lastQuestionType + 1 + U.rand(Question.QUESTION_TYPE_COUNT - 1)) % Question.QUESTION_TYPE_COUNT, this.questionLevel);
            this.lastQuestionType = this.question.getType();
            if (this.pips != null) {
                this.pips[++this.currentQuestion] = 1;
            }
        }
    }

    public void onTimeout(Timer timer) {
        this.question.dispatchWrongAnswer();
    }

    public void onAnswer(int index, boolean isCorrect) {
        this.question.onHighlight(this.getGraphics(), index);
        this.click(false);
        this.doPaint();
        this.timer.pause();
        if (isCorrect) {
            ++this.totalCorrectAnswers;
            this.maxAnswerTime = Math.max(this.maxAnswerTime, (int)this.timer.getTimePassed());
            this.setGlobalScore(this.getGlobalScore() + 1);
            this.pips[this.currentQuestion] = 0;
            ++this.questionLevel;
        } else {
            this.onWrongAnswer();
        }
        this.nextQuestionCountDown = C.QUESTION_NEXT_COUNTDOWN;
    }

    private void onWrongAnswer() {
        ++this.totalWrongAnswers;
        this.setGlobalScore(this.getGlobalScore() - 1);
        Graphics g = this.getGraphics();
        this.drawBomb(g, C.DETERMINATION_PIPS[this.currentQuestion], C.DETERMINATION_PIPS[this.currentQuestion + 1], 3);
        this.click(false);
        this.pips[this.currentQuestion] = 4;
    }

    public void onGameOver(boolean isTimeout) {
        int lr;
        this.complete();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (this.totalCorrectAnswers == this.pips.length && this.totalWrongAnswers == 0) {
            if (this.maxAnswerTime <= 2000) {
                A.raise(3, baos);
            }
            A.raise(2, baos);
        }
        if ((lr = this.getRecord()) == Integer.MIN_VALUE) {
            lr = this.questionLevel;
            this.setRecord(lr);
        }
        if (this.questionLevel > lr) {
            this.setGlobalScore(this.getGlobalScore() + C.BREAKING_RECORD_BONUS);
            if (!A.raise(4, baos)) {
                A.raise(20, baos);
            }
            this.setRecord(this.questionLevel);
        }
        A.raise(18, baos);
        A.raise(13, baos);
        A.raise(14, baos);
        A.raise(15, baos);
        A.raise(16, baos);
        Risk.setScreen(new Machine(this.lastGlobalScore, false, this.questionLevel, lr, baos.toByteArray(), isTimeout));
    }

    protected void drawBomb(Graphics g, int x, int y, int type) {
        g.drawRegion(R.BOMBS.i, C.BOMBS_FRAMES[type][0], C.BOMBS_FRAMES[type][1], C.BOMBS_FRAMES[type][2], C.BOMBS_FRAMES[type][3], 0, x, y, 3);
    }
}

