/*
 * Decompiled with CFR 0.152.
 */
package com.c2m.screens.games.questions;

import com.c2m.screens.games.questions.QuestionListener;
import com.c2m.screens.games.questions.TextQuestion;
import com.c2m.utils.T;
import com.c2m.utils.U;
import java.util.Enumeration;
import java.util.Hashtable;

public class MathQuestion
extends TextQuestion {
    protected MathQuestion(int type, QuestionListener questionListener, int level, int randNum) {
        super(type, questionListener, level, randNum);
        String[] t = this.generate();
        this.title = t[0];
        this.subtitle = t[1];
        System.arraycopy(t, 2, this.answers, 0, this.answers.length);
        this.shuffleAnswers();
    }

    private int numGen1to9() {
        return U.rand(9) + 1;
    }

    private int numGen2to9() {
        return U.rand(8) + 2;
    }

    private int numGen10to99() {
        return 10 + U.rand(90);
    }

    private int numGen10to12() {
        return 10 + U.rand(3);
    }

    private int numGen13to20() {
        return 13 + U.rand(8);
    }

    private int numGen100to999() {
        return 100 + U.rand(900);
    }

    private String[] generate() {
        switch (this.level) {
            case 0: {
                switch (this.randNum % 3) {
                    case 0: {
                        return this.exrGenPlus(this.numGen1to9(), this.numGen1to9());
                    }
                    case 1: {
                        return this.exrGenMinus(this.numGen1to9(), this.numGen1to9());
                    }
                }
                return this.exrGenPlus(this.numGen10to99(), this.numGen1to9());
            }
            case 1: {
                switch (this.randNum % 3) {
                    case 0: {
                        return this.exrGenMinus(this.numGen10to99(), this.numGen1to9());
                    }
                    case 1: {
                        return this.exrGenMultiple(this.numGen2to9(), this.numGen2to9());
                    }
                }
                return this.exrGenPlusMinusBraket(this.numGen1to9(), this.numGen1to9(), this.numGen1to9());
            }
            case 2: {
                switch (this.randNum % 5) {
                    case 0: {
                        return this.exrGenPlus(this.numGen100to999(), this.numGen1to9());
                    }
                    case 1: {
                        return this.exrGenMinus(this.numGen100to999(), this.numGen1to9());
                    }
                    case 2: {
                        return this.exrGenMultiple(this.numGen10to12(), this.numGen2to9());
                    }
                    case 3: {
                        int a = this.numGen2to9();
                        int b = this.numGen2to9();
                        while (a * b > 50) {
                            a = this.numGen2to9();
                            b = this.numGen2to9();
                        }
                        return this.exrGenDevide(a * b, b);
                    }
                }
                return this.exrGenPlusMinusBraket(this.numGen10to99(), this.numGen1to9(), this.numGen1to9());
            }
            case 3: {
                switch (this.randNum % 4) {
                    case 0: {
                        return this.exrGenPlus(this.numGen10to99(), this.numGen10to99());
                    }
                    case 1: {
                        return this.exrGenMinus(this.numGen10to99(), this.numGen10to99());
                    }
                    case 2: {
                        return this.exrGenMultiple(this.numGen10to12(), this.numGen10to12());
                    }
                }
                return this.exrGenPlusMinusBraket(this.numGen10to99(), this.numGen10to99(), this.numGen10to99());
            }
            case 4: {
                switch (this.randNum % 5) {
                    case 0: {
                        return this.exrGenPlus(this.numGen100to999(), this.numGen10to99());
                    }
                    case 1: {
                        return this.exrGenMinus(this.numGen100to999(), this.numGen10to99());
                    }
                    case 2: {
                        return this.exrGenMultiple(this.numGen13to20(), this.numGen2to9());
                    }
                    case 3: {
                        int a = this.numGen2to9();
                        int b = this.numGen2to9();
                        return this.exrGenDevide(a * b, b);
                    }
                }
                return this.exrGenPlusMinusBraket(this.numGen100to999(), this.numGen10to99(), this.numGen1to9());
            }
            case 5: {
                switch (this.randNum % 5) {
                    case 0: {
                        return this.exrGenPlus(this.numGen100to999(), this.numGen100to999());
                    }
                    case 1: {
                        return this.exrGenMinus(this.numGen100to999(), this.numGen100to999());
                    }
                    case 2: {
                        return this.exrGenMultiple(this.numGen13to20(), this.numGen10to12());
                    }
                    case 3: {
                        return this.exrGenPlusMinusBraket(this.numGen100to999(), this.numGen10to99(), this.numGen10to99());
                    }
                }
                return this.exrGenPlusMinusBraketMultiple(this.numGen1to9(), this.numGen1to9(), this.numGen2to9());
            }
            case 6: {
                switch (this.randNum % 6) {
                    case 0: {
                        return this.exrGenMultiple(this.numGen100to999(), this.numGen2to9());
                    }
                    case 1: {
                        int a = this.numGen10to99();
                        int b = this.numGen2to9();
                        return this.exrGenDevide(a * b, b);
                    }
                    case 2: {
                        return this.exrGenPlusMinusBraket(this.numGen100to999(), this.numGen10to99(), this.numGen100to999());
                    }
                    case 3: {
                        return this.exrGenMultipleBraketPlusMinus(this.numGen10to12(), this.numGen2to9(), this.numGen1to9());
                    }
                    case 4: {
                        return this.exrGenMultipleBraketPlusMinus(this.numGen10to12(), this.numGen2to9(), this.numGen10to99());
                    }
                }
                return this.exrGenMultipleBraket(this.numGen2to9(), this.numGen2to9(), this.numGen2to9());
            }
            case 7: {
                switch (this.randNum % 6) {
                    case 0: {
                        return this.exrGenMultiple(this.numGen13to20(), this.numGen13to20());
                    }
                    case 1: {
                        int a = this.numGen10to99();
                        int b = this.numGen2to9();
                        while (a * b < 100) {
                            a = this.numGen10to99();
                            b = this.numGen2to9();
                        }
                        return this.exrGenDevide(a * b, b);
                    }
                    case 2: {
                        return this.exrGenPlusMinusBraket(this.numGen100to999(), this.numGen100to999(), this.numGen100to999());
                    }
                    case 3: {
                        return this.exrGenMultipleBraketPlusMinus(this.numGen10to12(), this.numGen10to12(), this.numGen1to9());
                    }
                    case 4: {
                        return this.exrGenMultipleBraketPlusMinus(this.numGen10to12(), this.numGen10to12(), this.numGen10to99());
                    }
                }
                return this.exrGenPlusMinusBraketMultiple(this.numGen1to9(), this.numGen1to9(), this.numGen10to99());
            }
            case 8: {
                switch (this.randNum % 4) {
                    case 0: {
                        return this.exrGenMultipleBraketPlusMinus(this.numGen10to12(), this.numGen2to9(), this.numGen1to9());
                    }
                    case 1: {
                        return this.exrGenMultipleBraketPlusMinus(this.numGen13to20(), this.numGen2to9(), this.numGen1to9());
                    }
                    case 2: {
                        return this.exrGenPlusMinusBraketMultiple(this.numGen1to9(), this.numGen1to9(), this.numGen13to20());
                    }
                }
                return this.exrGenPlusMinusBraketMultiple(this.numGen10to99(), this.numGen1to9(), this.numGen13to20());
            }
            case 9: {
                switch (this.randNum % 5) {
                    case 0: {
                        return this.exrGenMultipleBraketPlusMinus(this.numGen10to12(), this.numGen10to12(), this.numGen100to999());
                    }
                    case 1: {
                        return this.exrGenMultipleBraketPlusMinus(this.numGen10to12(), this.numGen10to99(), this.numGen100to999());
                    }
                    case 2: {
                        return this.exrGenMultipleBraketPlusMinus(this.numGen10to12(), this.numGen10to99(), this.numGen100to999());
                    }
                }
                int a = U.rand(50) + 10;
                int b = U.rand(50) + 10;
                while (a * b > 1000) {
                    a = U.rand(50) + 10;
                    b = U.rand(50) + 10;
                }
                return this.exrGenDevide(a * b, b);
            }
        }
        return null;
    }

    private String[] exrGenPlus(int a, int b) {
        int r = a + b;
        Object[] wr = new String[]{"" + (r - 3), "" + (r - 2), "" + (r - 1), "" + (r + 1), "" + (r + 2), "" + (r + 3)};
        U.suffle(wr);
        return new String[]{T.MATH_TEXTS[0], "" + a + " + " + b + " = ", "" + r, wr[0], wr[1], wr[2]};
    }

    private String[] exrGenMinus(int a, int b) {
        int r = a - b;
        Object[] wr = new String[]{"" + (r - 3), "" + (r - 2), "" + (r - 1), "" + (r + 1), "" + (r + 2), "" + (r + 3)};
        U.suffle(wr);
        return new String[]{T.MATH_TEXTS[0], "" + a + " - " + b + " = ", "" + r, wr[0], wr[1], wr[2]};
    }

    private String[] exrGenPlusMinusBraket(int a, int b, int c) {
        int b0 = U.rand(2) == 0 ? b : -b;
        int c0 = U.rand(2) == 0 ? c : -c;
        int r = a + b0 + c0;
        Object[] wr = new String[]{"" + (r - 3), "" + (r - 2), "" + (r - 1), "" + (r + 1), "" + (r + 2), "" + (r + 3)};
        U.suffle(wr);
        return new String[]{T.MATH_TEXTS[0], "(" + a + (b0 > 0 ? " + " : " - ") + b + ")" + (c0 > 0 ? " + " : " - ") + c + " = ", "" + r, wr[0], wr[1], wr[2]};
    }

    private String[] exrGenPlusMinusBraketMultiple(int a, int b, int c) {
        int b0 = U.rand(2) == 0 ? b : -b;
        int t = a + b0;
        int r = t * c;
        Object[] wr = this.cleanResultCandidates(r, new int[]{(t - 2) * c, (t - 1) * c, (t + 1) * c, (t + 2) * c, t * (c - 1), t * (c + 1)});
        U.suffle(wr);
        return new String[]{T.MATH_TEXTS[0], "(" + a + (b0 > 0 ? " + " : " - ") + b + ") * " + c + " = ", "" + r, wr[0], wr[1], wr[2]};
    }

    private String[] exrGenMultiple(int a, int b) {
        int r = a * b;
        Object[] wr = this.cleanResultCandidates(r, new int[]{(a - 2) * b, (a - 1) * b, (a + 1) * b, (a + 2) * b, a * (b - 1), a * (b + 1)});
        U.suffle(wr);
        return new String[]{T.MATH_TEXTS[0], "" + a + " * " + b + " = ", "" + r, wr[0], wr[1], wr[2]};
    }

    private String[] exrGenMultipleBraket(int a, int b, int c) {
        int r = a * b * c;
        Object[] wr = this.cleanResultCandidates(r, new int[]{(a + 1) * b * c, (a - 1) * b * c, a * (b + 1) * c, a * (b - 1) * c, a * b * (c + 1), a * b * (c - 1)});
        U.suffle(wr);
        return new String[]{T.MATH_TEXTS[0], "(" + a + " * " + b + ") * " + c + " = ", "" + r, wr[0], wr[1], wr[2]};
    }

    private String[] exrGenMultipleBraketPlusMinus(int a, int b, int c) {
        int c0 = U.rand(2) == 0 ? c : -c;
        int r = a * b + c0;
        Object[] wr = this.cleanResultCandidates(r, new int[]{(a + 1) * b + c, (a - 1) * b + c, a * (b + 1) + c, a * (b - 1) + c, a * b + c + 1, a * b + c - 1});
        U.suffle(wr);
        return new String[]{T.MATH_TEXTS[0], "(" + a + " * " + b + ")" + (c0 > 0 ? " + " : " - ") + c + " = ", "" + r, wr[0], wr[1], wr[2]};
    }

    private String[] exrGenDevide(int a, int b) {
        int r = a / b;
        Object[] wr = new String[]{"" + (r - 3), "" + (r - 2), "" + (r - 1), "" + (r + 1), "" + (r + 2), "" + (r + 3)};
        U.suffle(wr);
        return new String[]{T.MATH_TEXTS[0], "" + a + " / " + b + " = ", "" + r, wr[0], wr[1], wr[2]};
    }

    private String[] cleanResultCandidates(int correctAnswer, int[] wrongAnswers) {
        Hashtable<Integer, Integer> h = new Hashtable<Integer, Integer>();
        h.put(new Integer(correctAnswer), new Integer(correctAnswer));
        for (int i = 0; i < wrongAnswers.length; ++i) {
            h.put(new Integer(wrongAnswers[i]), new Integer(wrongAnswers[i]));
        }
        h.remove(new Integer(correctAnswer));
        if (h.size() < 4) {
            throw new RuntimeException("Not enough results");
        }
        String[] r = new String[h.size()];
        int i = 0;
        Enumeration e = h.keys();
        while (e.hasMoreElements()) {
            r[i++] = e.nextElement().toString();
        }
        return r;
    }
}

