/*
 * Decompiled with CFR 0.152.
 */
package com.c2m.screens;

import com.c2m.screens.Brain;
import com.c2m.screens.Help;
import com.c2m.screens.Screen;
import com.c2m.screens.popups.Popup;
import com.c2m.screens.popups.PopupListener;
import com.c2m.screens.popups.Quit;
import com.c2m.utils.C;
import com.c2m.utils.R;
import com.c2m.utils.Sound;
import com.c2m.utils.T;
import com.c2m.utils.U;
import javax.microedition.lcdui.Graphics;

public class Menu
extends Screen
implements PopupListener {
    private int selected = this.hasPointerEvents() ? -1 : 0;
    private final boolean HAS_MORE_GAMES = "menu, exit".equals(this.getAppProperty("C2M-BuySetup"));
    private static final R[][] activeResources = new R[][]{{R.BG_YELLOW, R.MENU_BUTTONS, R.ORANGE_FONT, R.CABLE, R.CLICK_SOUND, R.SOFT_KEY_ELEMENTS}, Quit.activeResources};

    public Menu() {
        T.MENU_BUTTONS[1] = Sound.isActive() ? T.MENU_BUTTONS[T.MENU_BUTTONS.length - 2] : T.MENU_BUTTONS[T.MENU_BUTTONS.length - 1];
        T.MENU_BUTTONS[4] = this.HAS_MORE_GAMES ? T.MENU_BUTTONS[6] : T.MENU_BUTTONS[5];
    }

    private void drawButton(Graphics g, int i, boolean s) {
        int[] b = C.MENU_BUTTONS[i];
        int[] f = C.MENU_BUTTONS_FRAMES[b[4]];
        g.drawRegion(s ? R.MENU_BUTTONS.i[1] : R.MENU_BUTTONS.i[0], f[0], f[1], f[2], f[3], 0, b[0] + b[2] / 2, b[1] + b[3] / 2, 3);
        R.ORANGE_FONT.f.drawString(g, T.MENU_BUTTONS[i], b[0] + b[2] / 2, b[1] + C.MENU_BUTTON_TEXT_DY, 2);
    }

    protected void onPaint(Graphics g) {
        g.drawImage(R.BG_YELLOW.i, 0, 0, 20);
        for (int i = 0; i < C.MENU_BUTTONS.length; ++i) {
            this.drawButton(g, i, i == this.selected);
        }
        this.drawCables(g, C.MENU_CABLES);
        if (this.HAS_MORE_GAMES) {
            int[] f = C.SOFT_KEYS_FRAMES[9];
            g.drawRegion(R.SOFT_KEY_ELEMENTS.i, f[0], f[1], f[2], f[3], 0, C.SOFT_KEYS[0][0] + C.SOFT_KEYS[0][2] / 2 + f[4], C.SOFT_KEYS[0][1] + C.SOFT_KEYS[0][3] / 2 + f[5], 3);
        }
        if (this.popup != null) {
            this.popup.onPaint(g);
        }
    }

    protected R[][] getActiveResources() {
        return activeResources;
    }

    protected void onTouch(int x, int y) {
        for (int i = 0; i < C.MENU_BUTTONS.length; ++i) {
            if (!U.pointIn(x, y, C.MENU_BUTTONS[i])) continue;
            this.drawButton(this.getGraphics(), i, true);
            this.onAction(i);
            break;
        }
        if (this.HAS_MORE_GAMES && U.pointIn(x, y, C.SOFT_KEYS[0])) {
            this.onAction(-1);
        }
    }

    protected void onKey(int k) {
        if (!this.hasPointerEvents()) {
            if (this.selected >= 0) {
                switch (this.getGameAction(k)) {
                    case 1: {
                        this.selected = (this.selected + C.MENU_BUTTONS.length - 1) % C.MENU_BUTTONS.length;
                        this.doPaint();
                        break;
                    }
                    case 6: {
                        ++this.selected;
                        this.selected %= C.MENU_BUTTONS.length;
                        this.doPaint();
                        break;
                    }
                    case 8: {
                        this.onAction(this.selected);
                        break;
                    }
                    default: {
                        if (!this.determineLeftSoft(k) && (this.getGameAction(k) != 2 || !noSoft) || !this.HAS_MORE_GAMES) break;
                        this.onAction(-1);
                    }
                }
            }
            if (noSoft && (k == 82 || k == 4)) {
                this.onAction(-1);
            }
        } else if (k == 82 || k == 4) {
            this.onAction(-1);
        }
    }

    protected void onAction(int i) {
        switch (i) {
            case -1: {
                this.click(true);
                this.popup = new Quit(this);
                this.doPaint();
                break;
            }
            case 0: {
                this.click(true);
                Screen.setScreen(new Brain());
                break;
            }
            case 1: {
                Sound.setActive(!Sound.isActive());
                this.click(true);
                T.MENU_BUTTONS[1] = Sound.isActive() ? T.MENU_BUTTONS[T.MENU_BUTTONS.length - 2] : T.MENU_BUTTONS[T.MENU_BUTTONS.length - 1];
                this.doPaint();
                break;
            }
            case 2: {
                this.click(true);
                Screen.setScreen(new Help(this, T.ACHIEVEMENTS_TEXTS));
                break;
            }
            case 3: {
                this.click(true);
                Screen.setScreen(new Help(this, T.HELP_TEXTS));
                break;
            }
            case 4: {
                this.click(true);
                this.popup = new Quit(this, this.HAS_MORE_GAMES);
                this.doPaint();
            }
        }
    }

    public void onPopupAction(Popup popup, int i) {
        if (popup instanceof Quit) {
            if (i == 0) {
                if (((Quit)popup).isMoreGamesPopup) {
                    this.platformRequest(this.getAppProperty("C2M-URL"));
                    if ("true".equals(this.getAppProperty("X-Android"))) {
                        this.popup = null;
                        this.doPaint();
                    } else {
                        this.notifyDestroyed();
                    }
                } else {
                    this.notifyDestroyed();
                }
            } else {
                this.popup = null;
                this.doPaint();
            }
        }
    }
}

