/*
 * Decompiled with CFR 0.152.
 */
package com.c2m.screens.games;

import com.c2m.screens.Machine;
import com.c2m.screens.games.Game;
import com.c2m.screens.games.questions.Question;
import com.c2m.screens.games.timers.RoundTimer;
import com.c2m.screens.games.timers.Timer;
import com.c2m.screens.popups.Ingame;
import com.c2m.screens.popups.Quit;
import com.c2m.utils.A;
import com.c2m.utils.C;
import com.c2m.utils.R;
import com.c2m.utils.U;
import java.io.ByteArrayOutputStream;
import javax.microedition.lcdui.Graphics;

public class Perfectionism
extends Game {
    private final int[] pips = new int[C.PERFECTIONISM_PIPS.length / 2];
    private int currentQuestion = this.findAvailablePip();
    private Question[] questions;
    private static final R[][] activeResources = new R[][]{{R.PERFECTIONISM_BG_ELEMENT, R.PIPS}, Game.activeResources, RoundTimer.activeResources, Ingame.activeResources, Quit.activeResources};

    public Perfectionism() {
        this.pips[this.currentQuestion] = 3;
    }

    protected Timer createTimer() {
        return Timer.createRound(this, C.PERFECTIONISM_TIMER);
    }

    protected void drawBackground(Graphics g) {
        g.drawImage(R.PERFECTIONISM_BG_ELEMENT.i, C.WIDTH / 2, C.PERFECTIONISM_BG_ELEMENT_Y, 3);
        this.drawCables(g, C.PERFECTIONISM_CABLES);
        for (int i = 0; i < C.PERFECTIONISM_PIPS.length; i += 2) {
            this.drawPip(g, C.PERFECTIONISM_PIPS[i], C.PERFECTIONISM_PIPS[i + 1], this.pips[i / 2]);
        }
    }

    protected R[][] getActiveResources() {
        return activeResources;
    }

    protected void nextQuestion() {
        if (this.questions == null) {
            this.questions = new Question[C.PERFECTIONISM_PIPS.length / 2];
            for (int i = 0; i < this.questions.length; ++i) {
                this.questions[i] = Question.create(this, (this.lastQuestionType + 1 + U.rand(Question.QUESTION_TYPE_COUNT - 1)) % Question.QUESTION_TYPE_COUNT, Question.generateRandomLevelAccordingBrainSize(this.brainSize));
                this.lastQuestionType = this.questions[i].getType();
            }
        }
        this.timer.resume();
        this.currentQuestion = this.findAvailablePip();
        if (this.currentQuestion == -1) {
            this.gameOver = true;
        } else {
            R.NEW_QUESTION_SOUND.s.play(true);
            this.question = this.questions[this.currentQuestion];
            this.question.reset();
            if (this.pips != null) {
                this.pips[this.currentQuestion] = 3;
            }
        }
    }

    public void onTimeout(Timer timer) {
        this.onGameOver(true);
    }

    public void onAnswer(int index, boolean isCorrect) {
        this.question.onHighlight(this.getGraphics(), index);
        this.click(false);
        this.doPaint();
        this.timer.pause();
        if (isCorrect) {
            ++this.totalCorrectAnswers;
            this.setGlobalScore(this.getGlobalScore() + 1);
            this.pips[this.currentQuestion] = 2;
        } else {
            ++this.totalWrongAnswers;
            this.pips[this.currentQuestion] = 1;
            this.setGlobalScore(this.getGlobalScore() - 1);
            this.timer.add(C.PERFECTIONISM_PENALTY);
        }
        this.nextQuestionCountDown = C.QUESTION_NEXT_COUNTDOWN;
    }

    public void onGameOver(boolean isTimeout) {
        this.complete();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (this.totalCorrectAnswers == this.pips.length && this.totalWrongAnswers == 0) {
            A.raise(0, baos);
        }
        int lr = this.getRecord();
        int s = (int)this.timer.getTimePassed();
        if (s > C.PERFECTIONISM_TIMER) {
            s = C.PERFECTIONISM_TIMER;
        }
        if (lr == Integer.MIN_VALUE) {
            lr = s;
            this.setRecord(lr);
        }
        if (s < lr) {
            this.setGlobalScore(this.getGlobalScore() + C.BREAKING_RECORD_BONUS);
            if (!A.raise(1, baos)) {
                A.raise(20, baos);
            }
            this.setRecord(s);
        }
        if (this.timer.getTimeLeft() < 5000L && this.timer.getTimeLeft() > 0L) {
            A.raise(19, baos);
        }
        A.raise(18, baos);
        A.raise(13, baos);
        A.raise(14, baos);
        A.raise(15, baos);
        A.raise(16, baos);
        Perfectionism.setScreen(new Machine(this.lastGlobalScore, true, s, lr, baos.toByteArray(), isTimeout));
    }

    private int findAvailablePip() {
        int r = U.rand(C.PERFECTIONISM_PIPS.length / 2);
        if (this.pips == null) {
            return r;
        }
        for (int i = 0; i < this.pips.length; ++i) {
            int t = (i + r) % this.pips.length;
            if (this.pips[t] != 0 && this.pips[t] != 1) continue;
            return t;
        }
        return -1;
    }
}

