/*
 * Decompiled with CFR 0.152.
 */
package com.c2m.screens;

import com.c2m.C2MCanvas;
import com.c2m.screens.popups.Popup;
import com.c2m.utils.C;
import com.c2m.utils.F;
import com.c2m.utils.R;
import com.c2m.utils.Sound;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;

public abstract class Screen {
    public static final int UP = 1;
    public static final int DOWN = 6;
    public static final int LEFT = 2;
    public static final int RIGHT = 5;
    public static final int FIRE = 8;
    public static final int KEY_NUM0 = 48;
    public static final int KEY_NUM1 = 49;
    public static final int KEY_NUM2 = 50;
    public static final int KEY_NUM3 = 51;
    public static final int KEY_NUM4 = 52;
    public static final int KEY_NUM5 = 53;
    public static final int KEY_NUM6 = 54;
    public static final int KEY_NUM7 = 55;
    public static final int KEY_NUM8 = 56;
    public static final int KEY_NUM9 = 57;
    public static final int KEY_NUM0_E61 = 109;
    public static final int KEY_NUM1_E61 = 114;
    public static final int KEY_NUM2_E61 = 116;
    public static final int KEY_NUM3_E61 = 121;
    public static final int KEY_NUM4_E61 = 102;
    public static final int KEY_NUM5_E61 = 103;
    public static final int KEY_NUM6_E61 = 104;
    public static final int KEY_NUM7_E61 = 118;
    public static final int KEY_NUM8_E61 = 98;
    public static final int KEY_NUM9_E61 = 110;
    public static final int KEY_BACK = 4;
    public static final int KEY_MENU = 82;
    private static int curX = C.WIDTH / 2;
    private static int curY = C.HEIGHT / 2;
    private static Screen current = null;
    private static MIDlet midlet;
    private static C2MCanvas canvas;
    protected Popup popup = null;
    protected final int brainSize;
    protected static boolean noSoft;
    protected int noSoftState = 0;
    private final Object HIDE_NOTIFY = new Object();
    private static final Timer timer;

    protected Screen() {
        this.reloadResources();
        this.brainSize = this.calculateBrainSize(this.getGlobalScore());
    }

    protected final void reloadResources() {
        try {
            R[][] r = this.getActiveResources();
            for (int i = 0; i < r.length; ++i) {
                for (int j = 0; j < r[i].length; ++j) {
                    r[i][j].reload();
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage());
        }
        R.releaseUnused();
    }

    protected abstract R[][] getActiveResources();

    protected abstract void onPaint(Graphics var1);

    protected abstract void onTouch(int var1, int var2);

    protected abstract void onKey(int var1);

    protected abstract void onAction(int var1);

    protected void onSet() {
        this.doPaint();
    }

    protected void onHideNotify() {
    }

    public final void doPaint() {
        Graphics g = this.getGraphics();
        this.onPaint(g);
        if (this.popup != null) {
            this.popup.onPaint(g);
        }
        this.flushGraphics();
    }

    public final void flushGraphics() {
        canvas.flushGraphics();
    }

    public final boolean hasPointerEvents() {
        return canvas.hasPointerEvents();
    }

    public final void hideNotify() {
        this.schedule(this, this.HIDE_NOTIFY, 0L);
    }

    public final void showNotify() {
        if ("true".equals(midlet.getAppProperty("X-M600")) && Sound.isActive()) {
            Sound.setActive(false);
            Sound.setActive(true);
        }
    }

    public final void pointerPressed(int x, int y) {
        curX = x;
        curY = y;
        this.schedule(new int[]{x, y}, 0L);
    }

    public final void keyPressed(int k) {
        this.schedule(new int[]{k}, 0L);
    }

    public static void setScreen(MIDlet midlet, C2MCanvas canvas, Screen screen) {
        Screen.midlet = midlet;
        Screen.canvas = canvas;
        Display.getDisplay((MIDlet)midlet).setCurrent((Displayable)canvas);
        noSoft = "true".equals(midlet.getAppProperty("X-NoSoft"));
        Screen.setScreen(screen);
    }

    public static void setScreen(Screen screen) {
        current = screen;
        screen.onSet();
    }

    protected final boolean platformRequest(String URL2) {
        try {
            return midlet.platformRequest(URL2);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public final String getAppProperty(String key) {
        return midlet == null ? null : midlet.getAppProperty(key);
    }

    public static Screen getCurrent() {
        return current;
    }

    public void schedule(Object params, long time) {
        this.schedule(Screen.getCurrent(), params, time);
    }

    private void schedule(final Screen scope, final Object params, long time) {
        timer.schedule(new TimerTask(){

            public void run() {
                try {
                    if (Screen.getCurrent() == scope) {
                        if (params instanceof Runnable) {
                            ((Runnable)params).run();
                        }
                        if (params instanceof int[]) {
                            int[] p = (int[])params;
                            if (p.length == 1) {
                                if (scope.popup == null) {
                                    scope.onKey(p[0]);
                                } else {
                                    scope.popup.onKey(p[0]);
                                }
                            } else if (p.length == 2) {
                                if (scope.popup == null) {
                                    scope.onTouch(p[0], p[1]);
                                } else {
                                    scope.popup.onTouch(p[0], p[1]);
                                }
                            }
                        } else if (params == Screen.this.HIDE_NOTIFY) {
                            scope.onHideNotify();
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }, time);
    }

    protected void notifyDestroyed() {
        midlet.notifyDestroyed();
    }

    public void click(boolean playSound) {
        this.flushGraphics();
        if (playSound) {
            R.CLICK_SOUND.s.play(true);
        }
        this.sleep(100);
    }

    public void sleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public Graphics getGraphics() {
        return canvas.getGraphics();
    }

    protected void drawSoftKey(Graphics g, int x, int y, int i, int t, boolean s) {
        int[] f0 = C.SOFT_KEYS_FRAMES[s ? 5 : 4];
        int[] f1 = C.SOFT_KEYS_FRAMES[i];
        g.drawRegion(R.SOFT_KEY_ELEMENTS.i, f0[0], f0[1], f0[2], f0[3], 0, x, y, 3);
        g.drawRegion(R.SOFT_KEY_ELEMENTS.i, f1[0], f1[1], f1[2], f1[3], t, x + f1[4], y + f1[5], 3);
    }

    public boolean determineLeftSoft(int k) {
        return k == -6 || k == -21;
    }

    public boolean determineRightSoft(int k) {
        return k == -7 || k == -22;
    }

    public int getGameAction(int k) {
        if ("true".equals(midlet.getAppProperty("X-E61"))) {
            switch (k) {
                case 102: {
                    return canvas.getGameAction(canvas.getKeyCode(2));
                }
                case 104: {
                    return canvas.getGameAction(canvas.getKeyCode(5));
                }
                case 116: {
                    return canvas.getGameAction(canvas.getKeyCode(1));
                }
                case 98: {
                    return canvas.getGameAction(canvas.getKeyCode(6));
                }
                case 103: {
                    return canvas.getGameAction(canvas.getKeyCode(8));
                }
            }
            if (k < 0) {
                return canvas.getGameAction(k);
            }
            return 0;
        }
        switch (k) {
            case 52: {
                return canvas.getGameAction(canvas.getKeyCode(2));
            }
            case 54: {
                return canvas.getGameAction(canvas.getKeyCode(5));
            }
            case 50: {
                return canvas.getGameAction(canvas.getKeyCode(1));
            }
            case 56: {
                return canvas.getGameAction(canvas.getKeyCode(6));
            }
            case 53: {
                return canvas.getGameAction(canvas.getKeyCode(8));
            }
        }
        return canvas.getGameAction(k);
    }

    protected void drawCables(Graphics g, int[][] cables) {
        for (int i = 0; i < cables.length; ++i) {
            this.drawCable(g, cables[i][0], cables[i][1], cables[i][2], cables[i][3]);
        }
    }

    private void drawCable(Graphics g, int i, int x, int y, int t) {
        if (t == 0) {
            g.drawImage(R.CABLE.i[i], x, y, 3);
        } else {
            g.drawRegion(R.CABLE.i[i], 0, 0, R.CABLE.i[i].getWidth(), R.CABLE.i[i].getHeight(), t, x, y, 3);
        }
    }

    protected final int getGlobalScore() {
        return F.loadInt("GLOBAL_SCORE");
    }

    public void setGlobalScore(int score) {
        if (score < 0) {
            score = 0;
        } else if (score > C.BRAIN_SIZE_STEPS[C.BRAIN_SIZE_STEPS.length - 1]) {
            score = C.BRAIN_SIZE_STEPS[C.BRAIN_SIZE_STEPS.length - 1];
        }
        F.saveInt("GLOBAL_SCORE", score);
    }

    protected final int calculateBrainSize(int gs) {
        int i;
        for (i = 1; gs > C.BRAIN_SIZE_STEPS[i] && i < C.BRAIN_SIZE_STEPS.length; ++i) {
        }
        return i;
    }

    static {
        timer = new Timer();
        if (F.loadInt("GLOBAL_SCORE") == Integer.MIN_VALUE) {
            F.saveInt("GLOBAL_SCORE", 0);
        }
    }
}

