/*
 * Decompiled with CFR 0.152.
 */
package com.c2m.screens;

import com.c2m.screens.Brain;
import com.c2m.screens.Menu;
import com.c2m.screens.Screen;
import com.c2m.utils.BMFont;
import com.c2m.utils.C;
import com.c2m.utils.F;
import com.c2m.utils.R;
import com.c2m.utils.T;
import com.c2m.utils.U;
import javax.microedition.lcdui.Graphics;

public class Machine
extends Screen
implements Runnable {
    private static final int STATE_SCORE = 0;
    private static final int STATE_CALCULATING = 1;
    private static final int STATE_BAR_ANIMATION = 2;
    private static final int STATE_BAR_DONE = 3;
    private static final int STATE_BRAIN_SIZE = 4;
    private static final int STATE_ACHIEVEMENT = 5;
    private static final int SOFT_KEY_TYPE_NONE = 0;
    private static final int SOFT_KEY_TYPE_NEXT = 1;
    private static final int SOFT_KEY_TYPE_PLAY = 2;
    private int state = 0;
    private final int BAR_WIDTH;
    private final int BAR_HEIGHT;
    private final int globalScore;
    private final boolean isTime;
    private final boolean isTimeout;
    private final int score;
    private final int lastRecord;
    private final int lastBrainSize;
    private final int barDirection;
    private final int lastGlobalScore;
    private int currentGlobalScore;
    private int currentBrainSize;
    private final byte[] achievements;
    private int achievementsPtr;
    private int softKeyType;
    private int calculatingFrames;
    private final String[] EMPTY_TEXTS;
    private static final R[][] activeResources = new R[][]{{R.BG_BLUE, R.BG_BLUE_ELEMENTS1, R.SOFT_KEY_ELEMENTS, R.MACHINE_ANIMATION, R.BAR, R.BRAIN_SIZE_ELEMENTS, R.BLUE_FONT, R.WHITE_FONT, R.BADGE, R.CLICK_SOUND, R.BAR_LONGER_SOUND, R.BAR_SHORTER_SOUND, R.BRAIN_DECREASE_SOUND, R.BRAIN_INCREASE_SOUND, R.CALCULATING_DECREASE_SOUND, R.CALCULATING_INCREASE_SOUND, R.CALCULATING_NEUTRAL_SOUND, R.GAME_OVER_SOUND}};

    public Machine(int lastGlobalScore, boolean isTime, int score, int lastRecord, byte[] achievements, boolean isTimeout) {
        this.BAR_WIDTH = R.BAR.i.getWidth() / 4;
        this.BAR_HEIGHT = R.BAR.i.getHeight();
        this.achievementsPtr = 0;
        this.softKeyType = 1;
        this.calculatingFrames = 100;
        this.EMPTY_TEXTS = new String[0];
        this.globalScore = this.getGlobalScore();
        this.lastGlobalScore = lastGlobalScore;
        this.lastBrainSize = this.calculateBrainSize(lastGlobalScore);
        this.isTime = isTime;
        this.score = score;
        this.lastRecord = lastRecord;
        this.barDirection = lastGlobalScore < this.globalScore ? 1 : (lastGlobalScore > this.globalScore ? -1 : 0);
        this.achievements = achievements;
        this.isTimeout = isTimeout;
        this.currentGlobalScore = lastGlobalScore;
        this.currentBrainSize = this.calculateBrainSize(this.currentGlobalScore);
        R.GAME_OVER_SOUND.s.play(true);
        this.sleep(1500);
    }

    protected void onSet() {
        this.doPaint();
    }

    protected void onPaint(Graphics g) {
        int[] f2;
        int[] f1;
        int[] f0;
        String title;
        g.drawImage(R.BG_BLUE.i, 0, 0, 20);
        g.drawImage(R.BG_BLUE_ELEMENTS1.i, 0, 0, 20);
        String[] texts = this.EMPTY_TEXTS;
        switch (this.state) {
            case 0: {
                title = this.isTimeout ? T.MACHINE_TITLES[1] : T.MACHINE_TITLES[0];
                texts = this.generateScoreTexts();
                f0 = C.MACHINE_ANIMATION_FRAMES[5];
                f1 = C.MACHINE_ANIMATION_FRAMES[3];
                f2 = C.MACHINE_ANIMATION_FRAMES[0];
                break;
            }
            case 1: {
                title = T.MACHINE_TITLES[2];
                f0 = C.MACHINE_ANIMATION_FRAMES[5];
                f1 = C.MACHINE_ANIMATION_FRAMES[3 + this.calculatingFrames / 5 % 2];
                f2 = C.MACHINE_ANIMATION_FRAMES[this.calculatingFrames / 4 % 3];
                break;
            }
            case 2: 
            case 3: {
                title = "";
                f0 = C.MACHINE_ANIMATION_FRAMES[5];
                f1 = C.MACHINE_ANIMATION_FRAMES[3];
                f2 = C.MACHINE_ANIMATION_FRAMES[0];
                this.drawBar(g);
                break;
            }
            default: {
                title = T.MACHINE_TITLES[this.barDirection == 1 ? 3 : 4];
                texts = new String[]{T.MACHINE_TEXTS[9]};
                f0 = C.MACHINE_ANIMATION_FRAMES[5];
                f1 = C.MACHINE_ANIMATION_FRAMES[3];
                f2 = C.MACHINE_ANIMATION_FRAMES[0];
                int[] f3 = C.BRAIN_SIZE_ELEMENTS_FRAMES[0];
                int[] f4 = C.BRAIN_SIZE_ELEMENTS_FRAMES[1 + this.brainSize];
                g.drawRegion(R.BRAIN_SIZE_ELEMENTS.i, f3[0], f3[1], f3[2], f3[3], 0, C.WIDTH / 2, C.MACHINE_BRAIN_SIZE_Y, 17);
                g.drawRegion(R.BRAIN_SIZE_ELEMENTS.i, f4[0], f4[1], f4[2], f4[3], 0, C.WIDTH / 2, C.MACHINE_BRAIN_SIZE_Y + C.MACHINE_BRAIN_SIZE_DY, 17);
            }
        }
        switch (this.softKeyType) {
            case 1: {
                this.drawSoftKey(g, C.SOFT_KEYS[1][0] + C.SOFT_KEYS[1][2] / 2, C.SOFT_KEYS[1][1] + C.SOFT_KEYS[1][3] / 2, 2, 0, noSoft);
                break;
            }
            case 2: {
                this.drawSoftKey(g, C.SOFT_KEYS[1][0] + C.SOFT_KEYS[1][2] / 2, C.SOFT_KEYS[1][1] + C.SOFT_KEYS[1][3] / 2, 1, 0, noSoft);
            }
        }
        g.drawRegion(R.MACHINE_ANIMATION.i, f0[0], f0[1], f0[2], f0[3], 0, f0[4], f0[5], 3);
        g.drawRegion(R.MACHINE_ANIMATION.i, f1[0], f1[1], f1[2], f1[3], 0, f1[4], f1[5], 3);
        g.drawRegion(R.MACHINE_ANIMATION.i, f2[0], f2[1], f2[2], f2[3], 0, f2[4], f2[5], 3);
        R.WHITE_FONT.f.drawString(g, title, C.WIDTH / 2, C.MACHINE_TEXT_Y0, 2);
        for (int i = 0; i < texts.length; ++i) {
            BMFont f = i % 2 == 0 ? R.BLUE_FONT.f : R.WHITE_FONT.f;
            f.drawString(g, texts[i], C.WIDTH / 2, C.MACHINE_TEXT_Y1 + i * C.MACHINE_DY, 2);
        }
    }

    public void run() {
        switch (this.state) {
            case 1: {
                if (--this.calculatingFrames <= 0) {
                    this.state = 2;
                    if (this.barDirection > 0) {
                        R.BAR_LONGER_SOUND.s.play(true);
                    } else if (this.barDirection < 0) {
                        R.BAR_SHORTER_SOUND.s.play(true);
                    }
                }
                this.doPaint();
                this.schedule(this, 0L);
                break;
            }
            case 2: {
                if (this.currentGlobalScore != this.globalScore) {
                    this.currentGlobalScore += this.barDirection;
                    this.currentBrainSize = this.calculateBrainSize(this.currentGlobalScore);
                    this.doPaint();
                    this.schedule(this, 0L);
                    break;
                }
                this.state = 3;
                this.doPaint();
                this.schedule(this, 1500L);
                break;
            }
            case 3: {
                if (this.brainSize != this.lastBrainSize) {
                    this.state = 4;
                    if (this.barDirection > 0) {
                        R.BRAIN_INCREASE_SOUND.s.play(true);
                    } else {
                        R.BRAIN_DECREASE_SOUND.s.play(true);
                    }
                    if (this.achievements == null || this.achievements.length == 0) {
                        this.softKeyType = 2;
                        this.doPaint();
                        break;
                    }
                    this.doPaint();
                    this.state = 5;
                    this.schedule(this, 3000L);
                    break;
                }
                if (this.achievements == null || this.achievements.length == 0) {
                    this.softKeyType = 2;
                    this.doPaint();
                    break;
                }
                this.state = 5;
                this.schedule(this, 1500L);
                break;
            }
            case 5: {
                R.CLICK_SOUND.s.play(true);
                Graphics g = this.getGraphics();
                this.drawAchievements(g);
                if (++this.achievementsPtr == this.achievements.length) {
                    this.softKeyType = 2;
                    this.drawSoftKey(g, C.SOFT_KEYS[1][0] + C.SOFT_KEYS[1][2] / 2, C.SOFT_KEYS[1][1] + C.SOFT_KEYS[1][3] / 2, 1, 0, noSoft);
                } else {
                    this.schedule(this, 2000L);
                }
                this.flushGraphics();
            }
        }
    }

    protected R[][] getActiveResources() {
        return activeResources;
    }

    protected void onTouch(int x, int y) {
        if (U.pointIn(x, y, C.SOFT_KEYS[1])) {
            this.onAction(1);
        }
    }

    protected void onKey(int k) {
        if (!this.hasPointerEvents() && (this.determineRightSoft(k) || noSoft && this.getGameAction(k) == 8)) {
            this.onAction(1);
        }
        if ((this.hasPointerEvents() || noSoft) && (k == 82 || k == 4) && (this.state == 0 || this.state == 4 || this.brainSize == this.lastBrainSize && this.state == 3)) {
            Machine.setScreen(k == 82 ? new Menu() : new Brain());
        }
    }

    protected void onAction(int i) {
        switch (this.softKeyType) {
            case 1: {
                this.softKeyType = 0;
                this.drawSoftKey(this.getGraphics(), C.SOFT_KEYS[1][0] + C.SOFT_KEYS[1][2] / 2, C.SOFT_KEYS[1][1] + C.SOFT_KEYS[1][3] / 2, 2, 0, true);
                this.click(false);
                this.state = 1;
                if (this.barDirection > 0) {
                    R.CALCULATING_INCREASE_SOUND.s.play(true);
                } else if (this.barDirection < 0) {
                    R.CALCULATING_DECREASE_SOUND.s.play(true);
                } else {
                    R.CALCULATING_NEUTRAL_SOUND.s.play(true);
                }
                this.schedule(this, 100L);
                break;
            }
            case 2: {
                this.drawSoftKey(this.getGraphics(), C.SOFT_KEYS[1][0] + C.SOFT_KEYS[1][2] / 2, C.SOFT_KEYS[1][1] + C.SOFT_KEYS[1][3] / 2, 1, 0, true);
                this.click(true);
                Machine.setScreen(new Brain());
            }
        }
    }

    private void drawAchievements(Graphics g) {
        g.setColor(F.SEQUEL_NO == 2 ? 10191285 : 65280);
        g.fillRect(0, 0, C.WIDTH, C.MACHINE_ACHIEVEMENTS_HEIGHT);
        g.setColor(34816);
        g.drawLine(0, C.MACHINE_ACHIEVEMENTS_HEIGHT, C.WIDTH, C.MACHINE_ACHIEVEMENTS_HEIGHT);
        String s = "  " + T.ACHIEVEMENTS_TITLES[this.achievements[this.achievementsPtr]];
        int w = R.WHITE_FONT.f.getStringWidth(s);
        int x = (C.WIDTH - (C.BADGE_FRAMES[1][2] + w)) / 2;
        g.drawRegion(R.BADGE.i, C.BADGE_FRAMES[1][0], C.BADGE_FRAMES[1][1], C.BADGE_FRAMES[1][2], C.BADGE_FRAMES[1][3], 0, x, C.MACHINE_ACHIEVEMENTS_HEIGHT / 2, 6);
        R.WHITE_FONT.f.drawString(g, s, x += C.BADGE_FRAMES[1][2], C.MACHINE_ACHIEVEMENTS_HEIGHT / 2 - R.WHITE_FONT.f.getHeight() / 2, 0);
    }

    private int calculateBarPercent(int score) {
        return (score - C.BRAIN_SIZE_STEPS[this.currentBrainSize - 1]) * 100 / (C.BRAIN_SIZE_STEPS[this.currentBrainSize] - C.BRAIN_SIZE_STEPS[this.currentBrainSize - 1]);
    }

    private void drawBar(Graphics g) {
        int lastBarPercent;
        g.drawRegion(R.BAR.i, 0, 0, this.BAR_WIDTH, this.BAR_HEIGHT, 0, (C.WIDTH - this.BAR_WIDTH) / 2, C.MACHINE_BAR_POS_Y, 20);
        int currentPercent = this.calculateBarPercent(this.currentGlobalScore);
        if (this.barDirection > 0) {
            lastBarPercent = this.currentBrainSize == this.lastBrainSize ? this.calculateBarPercent(this.lastGlobalScore) : 0;
            g.drawRegion(R.BAR.i, this.BAR_WIDTH, 0, this.BAR_WIDTH * currentPercent / 100, this.BAR_HEIGHT, 0, (C.WIDTH - this.BAR_WIDTH) / 2, C.MACHINE_BAR_POS_Y, 20);
            g.drawRegion(R.BAR.i, this.BAR_WIDTH * 2, 0, this.BAR_WIDTH * lastBarPercent / 100, this.BAR_HEIGHT, 0, (C.WIDTH - this.BAR_WIDTH) / 2, C.MACHINE_BAR_POS_Y, 20);
        } else if (this.barDirection < 0) {
            lastBarPercent = this.currentBrainSize == this.lastBrainSize ? this.calculateBarPercent(this.lastGlobalScore) : 100;
            g.drawRegion(R.BAR.i, this.BAR_WIDTH * 3, 0, this.BAR_WIDTH * lastBarPercent / 100, this.BAR_HEIGHT, 0, (C.WIDTH - this.BAR_WIDTH) / 2, C.MACHINE_BAR_POS_Y, 20);
            g.drawRegion(R.BAR.i, this.BAR_WIDTH * 2, 0, this.BAR_WIDTH * currentPercent / 100, this.BAR_HEIGHT, 0, (C.WIDTH - this.BAR_WIDTH) / 2, C.MACHINE_BAR_POS_Y, 20);
        } else {
            lastBarPercent = this.calculateBarPercent(this.lastGlobalScore);
            g.drawRegion(R.BAR.i, this.BAR_WIDTH * 2, 0, this.BAR_WIDTH * lastBarPercent / 100, this.BAR_HEIGHT, 0, (C.WIDTH - this.BAR_WIDTH) / 2, C.MACHINE_BAR_POS_Y, 20);
        }
        R.WHITE_FONT.f.drawString(g, "" + currentPercent + "%", C.WIDTH / 2, C.MACHINE_PERCENT_Y, 2);
        int[] f0 = C.BRAIN_SIZE_ELEMENTS_FRAMES[8 + this.currentBrainSize];
        g.drawRegion(R.BRAIN_SIZE_ELEMENTS.i, f0[0], f0[1], f0[2], f0[3], 0, C.MACHINE_SMALL_BRAIN_SIZE_X, C.MACHINE_SMALL_BRAIN_SIZE_Y, 3);
        int[] f1 = C.BRAIN_SIZE_ELEMENTS_FRAMES[8 + this.currentBrainSize + 1];
        g.drawRegion(R.BRAIN_SIZE_ELEMENTS.i, f1[0], f1[1], f1[2], f1[3], 0, C.WIDTH - C.MACHINE_SMALL_BRAIN_SIZE_X, C.MACHINE_SMALL_BRAIN_SIZE_Y, 3);
    }

    private String[] generateScoreTexts() {
        if (this.isTime) {
            if (this.score < this.lastRecord) {
                return new String[]{T.MACHINE_TEXTS[0], this.generateTimeString(this.score), T.MACHINE_TEXTS[1], this.generateTimeString(this.lastRecord)};
            }
            return new String[]{T.MACHINE_TEXTS[2], this.generateTimeString(this.score), T.MACHINE_TEXTS[3], this.generateTimeString(this.lastRecord)};
        }
        if (this.score > this.lastRecord) {
            return new String[]{T.MACHINE_TEXTS[0], T.MACHINE_TEXTS[4] + " " + this.score, T.MACHINE_TEXTS[1], T.MACHINE_TEXTS[4] + " " + this.lastRecord};
        }
        return new String[]{T.MACHINE_TEXTS[2], T.MACHINE_TEXTS[4] + " " + this.score, T.MACHINE_TEXTS[3], T.MACHINE_TEXTS[4] + " " + this.lastRecord};
    }

    private String generateTimeString(int time) {
        int s = (time /= 1000) % 60;
        int m = time / 60;
        String r = m == 0 ? "" : (m == 1 ? "1 " + T.MACHINE_TEXTS[6] : "" + m + " " + T.MACHINE_TEXTS[5]) + ", ";
        r = r + "" + s + " " + (s == 1 ? T.MACHINE_TEXTS[8] : T.MACHINE_TEXTS[7]);
        return r;
    }
}

