/*
 * Decompiled with CFR 0.152.
 */
package com.c2m.utils;

import com.c2m.utils.U;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class BMFont {
    private final short[] pos;
    private final Character[] chars;
    private final Hashtable encoding;
    private final Image strip;
    private byte hspacing = 1;
    private byte vspacing = 1;
    public static final int LEFT_ALIGN = 0;
    public static final int RIGHT_ALIGN = 1;
    public static final int CENTER_ALIGN = 2;

    public BMFont(byte[] b) throws IOException {
        this(new ByteArrayInputStream(b));
    }

    public BMFont(String filename) throws IOException {
        this(U.getResourceAsStream(filename));
    }

    private BMFont(InputStream is) throws IOException {
        DataInputStream dis = new DataInputStream(is);
        this.encoding = new Hashtable(256);
        this.chars = new Character[dis.read()];
        this.pos = new short[this.chars.length + 1];
        for (int i = 0; i < this.chars.length; ++i) {
            this.chars[i] = new Character(dis.readChar());
            this.encoding.put(this.chars[i], new Integer(i));
            this.pos[i + 1] = (short)(this.pos[i] + dis.read());
        }
        this.hspacing = dis.readByte();
        this.vspacing = dis.readByte();
        if (dis.available() <= 1) {
            this.strip = Image.createImage((InputStream)dis);
        } else {
            byte[] b = new byte[dis.available()];
            dis.readFully(b);
            this.strip = Image.createImage((byte[])b, (int)0, (int)b.length);
        }
    }

    private BMFont(BMFont src, Image strip) {
        this.pos = src.pos;
        this.chars = src.chars;
        this.encoding = src.encoding;
        this.strip = strip;
        this.hspacing = src.hspacing;
        this.vspacing = src.vspacing;
    }

    public int[] encode(String s) {
        int[] r = new int[s.length()];
        for (int i = 0; i < r.length; ++i) {
            r[i] = this.encode(s.charAt(i));
        }
        return r;
    }

    public int encode(char c) {
        Integer r = (Integer)this.encoding.get(new Character(c));
        return r == null ? this.encode('?') : r.intValue();
    }

    public void setSpacing(byte hs, byte vs) {
        this.hspacing = hs;
        this.vspacing = vs;
    }

    public int drawChar(Graphics g, char c, int x, int y) {
        return this.drawChar(g, this.encode(c), x, y);
    }

    public int drawChar(Graphics g, int b, int x, int y) {
        g.drawRegion(this.strip, (int)this.pos[b], 0, this.pos[b + 1] - this.pos[b], this.strip.getHeight(), 0, x, y, 20);
        return this.pos[b + 1] - this.pos[b] + this.hspacing;
    }

    public void drawString(Graphics g, String str, int x, int y, int align) {
        this.drawString(g, this.encode(str), x, y, align);
    }

    public void drawString(Graphics g, int[] str, int x, int y, int align) {
        this.drawString(g, str, 0, str.length, x, y, align);
    }

    private void drawString(Graphics g, int[] encoded, int offset, int length, int x, int y, int align) {
        if (encoded == null || encoded.length == 0) {
            return;
        }
        if (align != 0) {
            x -= this.getStringWidth(encoded, offset, length) / align;
        }
        length += offset;
        while (offset < length) {
            x += this.drawChar(g, encoded[offset], x, y);
            ++offset;
        }
    }

    public void drawString(Graphics g, String str, int x, int y, int align, int w) {
        this.drawString(g, this.encode(str), x, y, align, w);
    }

    public void drawString(Graphics g, int[] encoded, int x, int y, int align, int w) {
        int space = this.encode(' ');
        int newLine = this.encode('\n');
        int lineWidth = 0;
        int lastI = 0;
        for (int i = 0; i < encoded.length; ++i) {
            if ((lineWidth += this.getCharWidth(encoded[i])) > w) {
                int j = i;
                if (encoded[j] == space) {
                    --j;
                }
                while (j > lastI && encoded[j] != space) {
                    --j;
                }
                if (j > lastI) {
                    i = j + 1;
                    this.drawString(g, encoded, lastI, i - lastI - 1, x, y, align);
                } else {
                    this.drawString(g, encoded, lastI, --i - lastI, x, y, align);
                }
                lastI = i;
                lineWidth = 0;
                y += this.getHeight() + this.vspacing;
                continue;
            }
            if (encoded[i] != newLine) continue;
            this.drawString(g, encoded, lastI, i - lastI, x, y, align);
            lastI = ++i;
            lineWidth = 0;
            y += this.getHeight() + this.vspacing;
        }
        this.drawString(g, encoded, lastI, encoded.length - lastI, x, y, align);
    }

    public int getStringWidth(String s) {
        return this.getStringWidth(this.encode(s));
    }

    public int getStringWidth(int[] encoded) {
        return this.getStringWidth(encoded, 0, encoded.length);
    }

    public int getStringWidth(int[] encoded, int offset, int length) {
        if (encoded == null || encoded.length == 0) {
            return 0;
        }
        int w = 0;
        length += offset;
        while (offset < length) {
            w += this.pos[encoded[offset] + 1] - this.pos[encoded[offset]] + this.hspacing;
            ++offset;
        }
        return w;
    }

    public int getCharWidth(char ch) {
        return this.getCharWidth(this.encode(ch));
    }

    public int getCharWidth(int ch) {
        return this.pos[ch + 1] - this.pos[ch] + this.hspacing;
    }

    public int getHeight() {
        return this.strip.getHeight();
    }

    public BMFont setColor(int[][] colorMap) {
        int[] c = new int[this.strip.getWidth() * this.strip.getHeight()];
        this.strip.getRGB(c, 0, this.strip.getWidth(), 0, 0, this.strip.getWidth(), this.strip.getHeight());
        for (int j = 0; j < colorMap.length; ++j) {
            for (int i = 0; i < c.length; ++i) {
                if (c[i] != colorMap[j][0]) continue;
                c[i] = colorMap[j][1];
            }
        }
        BMFont f = new BMFont(this, Image.createRGBImage((int[])c, (int)this.strip.getWidth(), (int)this.strip.getHeight(), (boolean)true));
        return f;
    }

    public void setHSpacing(byte v) {
        this.hspacing = v;
    }

    public void setVSpacing(byte v) {
        this.vspacing = v;
    }

    public byte getHSpacing() {
        return this.hspacing;
    }

    public byte getVSpacing() {
        return this.vspacing;
    }
}

