/*
 * Decompiled with CFR 0.152.
 */
package com.c2m.screens.games.questions;

import com.c2m.screens.Screen;
import com.c2m.screens.games.questions.CountryQuestion;
import com.c2m.screens.games.questions.ExceptionalQuestion;
import com.c2m.screens.games.questions.LanguageQuestion;
import com.c2m.screens.games.questions.MathQuestion;
import com.c2m.screens.games.questions.QuestionListener;
import com.c2m.screens.games.questions.RhymesQuestion;
import com.c2m.screens.games.questions.ShapesQuestion;
import com.c2m.screens.games.questions.SpellingQuestion;
import com.c2m.screens.games.questions.VisualMathQuestion;
import com.c2m.screens.games.questions.WhichIsQuestion;
import com.c2m.utils.C;
import com.c2m.utils.F;
import com.c2m.utils.R;
import com.c2m.utils.U;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class Question {
    public static final int QUESTION_TYPE_COUNT;
    protected final int type;
    protected QuestionListener questionListener;
    protected int selected = Screen.getCurrent().hasPointerEvents() ? -1 : 0;
    public static boolean debugIsOn;
    public static int debugType;
    public static int debugLevel;
    public static int debugRandom;
    protected final int level;
    protected final int randNum;
    protected String title;
    protected String subtitle;
    protected String[] answers = new String[4];
    protected int[] answersWidths = new int[4];
    protected int correctAnswer;
    protected boolean isWrongAnswer = false;
    protected int response = -1;
    protected static boolean noSoft;
    public static final int RHYMES = 0;
    public static final int SPELLING = 1;
    public static final int MATH = 2;
    public static final int SHAPES = 3;
    public static final int WHICH = 4;
    public static final int VISUAL_MATH = 5;
    public static final int COUNTRY = 6;
    public static final int LANGUAGE = 7;
    public static final int EXCEPTIONAL = 8;
    private static final int RED_BUTTON_WIDTH;
    private static final int RED_BUTTON_HEIGHT;

    public abstract void onHighlight(Graphics var1, int var2);

    public abstract void onPaint(Graphics var1);

    public abstract void onTouch(int var1, int var2);

    public abstract void onKey(int var1);

    public void reset() {
        this.isWrongAnswer = false;
        this.selected = Screen.getCurrent().hasPointerEvents() ? -1 : 0;
        this.response = -1;
    }

    protected Question(int type, QuestionListener questionListener, int level, int randNum) {
        this.type = type;
        this.questionListener = questionListener;
        this.level = level;
        this.randNum = randNum;
    }

    protected void shuffleAnswers() {
        int i;
        int ca = 0;
        for (i = 0; i < this.answers.length; ++i) {
            this.answersWidths[i] = R.BLUE_FONT.f.getStringWidth(this.answers[i]);
        }
        for (i = 0; i < this.answers.length * 10; ++i) {
            int r0 = U.rand(4);
            int r1 = (r0 + U.rand(3)) % 4;
            ca = this.swapShuffle(r0, r1, ca);
        }
        if (this.answersWidths[3] + C.ANSWER_BUTTON_MARGIN * 2 > C.ANSWER_BOTTOM_BUTTON_MAX_WIDTH) {
            for (i = 0; i < 3; ++i) {
                if (this.answersWidths[3] + C.ANSWER_BUTTON_MARGIN * 2 > C.ANSWER_BOTTOM_BUTTON_MAX_WIDTH) continue;
                ca = this.swapShuffle(3, i, ca);
                break;
            }
        }
        if (this.answersWidths[3] + C.ANSWER_BUTTON_MARGIN * 2 > C.ANSWER_BOTTOM_BUTTON_MAX_WIDTH) {
            for (i = 0; i < 3; ++i) {
                if (this.answersWidths[3] <= this.answersWidths[i]) continue;
                ca = this.swapShuffle(3, i, ca);
            }
        }
        this.correctAnswer = ca;
    }

    public void dispatchWrongAnswer() {
        if (this.response < 0) {
            R.WRONG_ANSWER_SOUND.s.play(true);
            this.isWrongAnswer = true;
            this.questionListener.onAnswer(-1, false);
        }
    }

    private int swapShuffle(int i, int j, int ca) {
        String ts = this.answers[i];
        this.answers[i] = this.answers[j];
        this.answers[j] = ts;
        int ti = this.answersWidths[i];
        this.answersWidths[i] = this.answersWidths[j];
        this.answersWidths[j] = ti;
        if (ca == i) {
            return j;
        }
        if (ca == j) {
            return i;
        }
        return ca;
    }

    public static Question create(QuestionListener questionListener, int type, int level) {
        int randNum;
        if (C.DEBUG == 1 && debugIsOn) {
            type = debugType;
            level = debugLevel;
            randNum = debugRandom;
        } else {
            randNum = U.rand(Integer.MAX_VALUE);
        }
        switch (type) {
            case 0: {
                return new RhymesQuestion(type, questionListener, level, randNum);
            }
            case 1: {
                return new SpellingQuestion(type, questionListener, level, randNum);
            }
            case 2: {
                return new MathQuestion(type, questionListener, level, randNum);
            }
            case 3: {
                return new ShapesQuestion(type, questionListener, level, randNum);
            }
            case 4: {
                return new WhichIsQuestion(type, questionListener, level, randNum);
            }
            case 5: {
                return new VisualMathQuestion(type, questionListener, level, randNum);
            }
            case 6: {
                return new CountryQuestion(type, questionListener, level, randNum);
            }
            case 7: {
                return new LanguageQuestion(type, questionListener, level, randNum);
            }
        }
        return new ExceptionalQuestion(type, questionListener, level, randNum);
    }

    protected void drawButton(Graphics g, int i, boolean isSelected, String text, int textWidth) {
        int x0;
        int buttonWidth = textWidth + C.ANSWER_BUTTON_MARGIN * 2;
        int x = (C.WIDTH - buttonWidth) / 2;
        Image im = isSelected ? R.RED_BUTTON.i[1] : R.RED_BUTTON.i[0];
        g.drawRegion(im, 0, 0, C.ANSWER_BUTTON_MARGIN, RED_BUTTON_HEIGHT, 0, x, C.ANSWER_BUTTONS[i][1], 20);
        g.drawRegion(im, RED_BUTTON_WIDTH - C.ANSWER_BUTTON_MARGIN, 0, C.ANSWER_BUTTON_MARGIN, RED_BUTTON_HEIGHT, 0, x + buttonWidth - C.ANSWER_BUTTON_MARGIN, C.ANSWER_BUTTONS[i][1], 20);
        for (x0 = x + C.ANSWER_BUTTON_MARGIN; x0 < x + buttonWidth + C.ANSWER_BUTTON_MARGIN - RED_BUTTON_WIDTH; x0 += RED_BUTTON_WIDTH - 2 * C.ANSWER_BUTTON_MARGIN) {
            g.drawRegion(im, C.ANSWER_BUTTON_MARGIN, 0, RED_BUTTON_WIDTH - 2 * C.ANSWER_BUTTON_MARGIN, RED_BUTTON_HEIGHT, 0, x0, C.ANSWER_BUTTONS[i][1], 20);
        }
        g.drawRegion(im, C.ANSWER_BUTTON_MARGIN, 0, x + buttonWidth - C.ANSWER_BUTTON_MARGIN - x0, RED_BUTTON_HEIGHT, 0, x0, C.ANSWER_BUTTONS[i][1], 20);
        R.BLUE_FONT.f.drawString(g, text, C.ANSWER_BUTTONS[i][0] + C.ANSWER_BUTTONS[i][2] / 2, C.ANSWER_BUTTONS[i][1] + C.ANSWER_BUTTONS[i][3] / 2 + C.ANSWER_BUTTON_TEXT_DY, 2);
    }

    public static int generateRandomLevelAccordingBrainSize(int bs) {
        return C.BRAIN_SIZE_QUESTIONS_MIN_LEVEL[bs] + U.rand(C.BRAIN_SIZE_QUESTIONS_MAX_LEVEL[bs] - C.BRAIN_SIZE_QUESTIONS_MIN_LEVEL[bs] + 1);
    }

    public int getType() {
        return this.type;
    }

    public static void setNoSoft(boolean noSoft) {
        Question.noSoft = noSoft;
    }

    static {
        switch (F.SEQUEL_NO) {
            case 2: {
                QUESTION_TYPE_COUNT = 6;
                break;
            }
            case 3: {
                QUESTION_TYPE_COUNT = 8;
                break;
            }
            case 4: {
                QUESTION_TYPE_COUNT = 9;
                break;
            }
            default: {
                QUESTION_TYPE_COUNT = 4;
            }
        }
        debugIsOn = false;
        debugType = 0;
        debugLevel = 0;
        debugRandom = 0;
        noSoft = false;
        RED_BUTTON_WIDTH = R.RED_BUTTON.i[0].getWidth();
        RED_BUTTON_HEIGHT = R.RED_BUTTON.i[0].getHeight();
    }
}

