/*
 * Decompiled with CFR 0.152.
 */
package com.c2m;

import com.c2m.screens.Screen;
import com.c2m.utils.C;
import com.c2m.utils.T;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.midlet.MIDlet;

public class C2MCanvas
extends GameCanvas
implements Runnable {
    private final MIDlet midlet;
    private final boolean orientationCheckEnable;
    private static int currentWidth = 0;

    protected C2MCanvas(MIDlet midlet) {
        super(false);
        this.setFullScreenMode(true);
        this.midlet = midlet;
        this.orientationCheckEnable = "true".equals(midlet.getAppProperty("X-Orientation"));
    }

    public Graphics getGraphics() {
        return super.getGraphics();
    }

    public final void pointerPressed(int x, int y) {
        if (this.checkOrientation(this.getGraphics())) {
            Screen.getCurrent().pointerPressed(x, y);
        }
    }

    public final void keyPressed(int k) {
        if (this.checkOrientation(this.getGraphics())) {
            Screen.getCurrent().keyPressed(k);
        }
    }

    public final void hideNotify() {
        Screen.getCurrent().hideNotify();
    }

    public final void showNotify() {
        currentWidth = this.getWidth();
        if (Screen.getCurrent() != null) {
            Screen.getCurrent().showNotify();
            Screen.getCurrent().doPaint();
        }
    }

    public final void sizeChanged(int width, int height) {
        if (this.orientationCheckEnable) {
            currentWidth = width;
            if (width == C.WIDTH) {
                this.showNotify();
            } else {
                Screen.getCurrent().hideNotify();
            }
            Display.getDisplay((MIDlet)this.midlet).callSerially((Runnable)this);
        }
    }

    public boolean checkOrientation(Graphics g) {
        if (this.orientationCheckEnable && (currentWidth != C.WIDTH || this.getWidth() != C.WIDTH)) {
            g.setColor(0);
            g.fillRect(0, 0, currentWidth, this.getHeight());
            g.setColor(0xFFFFFF);
            g.drawString(T.CHANGE_ORIENTATION[0], currentWidth / 2, (this.getHeight() - g.getFont().getHeight()) / 2, 65);
            g.drawString(T.CHANGE_ORIENTATION[1], currentWidth / 2, (this.getHeight() + g.getFont().getHeight()) / 2, 65);
            super.flushGraphics();
            return false;
        }
        return true;
    }

    public void paint(Graphics g) {
        if (this.checkOrientation(g)) {
            Display.getDisplay((MIDlet)this.midlet).callSerially((Runnable)this);
        }
    }

    public void flushGraphics() {
        if (this.checkOrientation(this.getGraphics())) {
            super.flushGraphics();
        }
    }

    public final void run() {
        if (Screen.getCurrent() != null) {
            Screen.getCurrent().doPaint();
        } else {
            Display.getDisplay((MIDlet)this.midlet).callSerially((Runnable)this);
        }
    }
}

