/*
 * Decompiled with CFR 0.152.
 */
package com.c2m.screens.games.timers;

import com.c2m.screens.games.timers.RoundTimer;
import com.c2m.screens.games.timers.SandTimer;
import com.c2m.screens.games.timers.TimerListener;
import com.c2m.screens.popups.Popup;
import javax.microedition.lcdui.Graphics;

public abstract class Timer
implements Runnable {
    protected long startTime;
    protected long endTime;
    protected long pauseTime;
    protected final int framesCount;
    protected final TimerListener timerListener;
    protected boolean timeout = false;

    protected Timer(TimerListener timerListener, int milliseconds, int framesCount) {
        this.timerListener = timerListener;
        this.startTime = System.currentTimeMillis();
        this.endTime = this.startTime + (long)milliseconds;
        this.framesCount = framesCount;
        this.pauseTime = 0L;
    }

    public abstract void onPaint(Graphics var1, Popup var2);

    public void pause() {
        this.pauseTime = System.currentTimeMillis();
    }

    public void resume() {
        if (this.pauseTime > 0L) {
            long dt = System.currentTimeMillis() - this.pauseTime;
            this.startTime += dt;
            this.endTime += dt;
            this.pauseTime = 0L;
        }
    }

    public void reset() {
        long dt = System.currentTimeMillis() - this.startTime;
        this.startTime += dt;
        this.endTime += dt;
        this.pauseTime = 0L;
    }

    public void add(int dt) {
        this.startTime -= (long)dt;
        this.endTime -= (long)dt;
    }

    public long getTimePassed() {
        return System.currentTimeMillis() - this.startTime;
    }

    public long getTimeLeft() {
        return this.endTime - System.currentTimeMillis();
    }

    public static Timer createRound(TimerListener timerListener, int milliseconds) {
        return new RoundTimer(timerListener, milliseconds);
    }

    public static Timer createSand(TimerListener timerListener, int milliseconds) {
        return new SandTimer(timerListener, milliseconds);
    }

    public final void run() {
        this.timerListener.onTimeout(this);
    }
}

