/*
 * Decompiled with CFR 0.152.
 */
package com.c2m.screens.games;

import com.c2m.screens.Machine;
import com.c2m.screens.games.Game;
import com.c2m.screens.games.questions.Question;
import com.c2m.screens.games.timers.SandTimer;
import com.c2m.screens.games.timers.Timer;
import com.c2m.screens.popups.Ingame;
import com.c2m.screens.popups.Quit;
import com.c2m.utils.A;
import com.c2m.utils.C;
import com.c2m.utils.R;
import com.c2m.utils.U;
import java.io.ByteArrayOutputStream;
import javax.microedition.lcdui.Graphics;

public class Reason
extends Game {
    private final int[] pips = new int[C.SPONTANEITY_PIPS.length / 2];
    private int currentQuestion = 0;
    private int totalTime = 0;
    private static final R[][] activeResources = new R[][]{{R.REASON_BG_ELEMENT, R.PIPS}, Game.activeResources, SandTimer.activeResources, Ingame.activeResources, Quit.activeResources};

    public Reason() {
        this.pips[0] = 3;
    }

    protected Timer createTimer() {
        return Timer.createSand(this, C.SPONTANEITY_TIMER);
    }

    protected void drawBackground(Graphics g) {
        g.drawImage(R.REASON_BG_ELEMENT.i, C.WIDTH / 2, C.SPONTANEITY_BG_ELEMENT_Y, 3);
        this.drawCables(g, C.SPONTANEITY_CABLES);
        for (int i = 0; i < C.SPONTANEITY_PIPS.length; i += 2) {
            this.drawPip(g, C.SPONTANEITY_PIPS[i], C.SPONTANEITY_PIPS[i + 1], this.pips[i / 2]);
        }
    }

    protected R[][] getActiveResources() {
        return activeResources;
    }

    protected void nextQuestion() {
        this.timer.reset();
        if (this.currentQuestion >= C.SPONTANEITY_PIPS.length / 2) {
            this.gameOver = true;
        } else {
            R.NEW_QUESTION_SOUND.s.play(true);
            this.question = Question.create(this, (this.lastQuestionType + 1 + U.rand(Question.QUESTION_TYPE_COUNT - 1)) % Question.QUESTION_TYPE_COUNT, this.currentQuestion);
            this.lastQuestionType = this.question.getType();
            if (this.pips != null) {
                this.pips[this.currentQuestion] = 3;
                if (this.currentQuestion + 1 < this.pips.length) {
                    this.pips[this.currentQuestion + 1] = 0;
                }
            }
        }
    }

    public void onTimeout(Timer timer) {
        this.question.dispatchWrongAnswer();
    }

    public void onAnswer(int index, boolean isCorrect) {
        this.question.onHighlight(this.getGraphics(), index);
        this.click(false);
        this.doPaint();
        this.timer.pause();
        if (isCorrect) {
            ++this.totalCorrectAnswers;
            this.setGlobalScore(this.getGlobalScore() + 1);
            this.pips[this.currentQuestion] = 2;
            ++this.currentQuestion;
            this.totalTime = (int)((long)this.totalTime + this.timer.getTimePassed());
        } else {
            this.pips[this.currentQuestion] = 1;
            if (this.currentQuestion > 0) {
                --this.currentQuestion;
            }
            this.onWrongAnswer();
        }
        this.nextQuestionCountDown = C.QUESTION_NEXT_COUNTDOWN;
    }

    private void onWrongAnswer() {
        ++this.totalWrongAnswers;
        this.setGlobalScore(this.getGlobalScore() - 1);
        this.totalTime += C.SPONTANEITY_TIMER;
    }

    public void onGameOver(boolean isTimeout) {
        int lr;
        this.complete();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (this.totalCorrectAnswers == this.pips.length && this.totalWrongAnswers == 0) {
            A.raise(11, baos);
        }
        if ((lr = this.getRecord()) == Integer.MIN_VALUE) {
            lr = this.totalTime;
            this.setRecord(lr);
        }
        if (this.totalTime < lr) {
            this.setGlobalScore(this.getGlobalScore() + C.BREAKING_RECORD_BONUS);
            if (!A.raise(12, baos)) {
                A.raise(20, baos);
            }
            this.setRecord(this.totalTime);
        }
        A.raise(18, baos);
        A.raise(13, baos);
        A.raise(14, baos);
        A.raise(15, baos);
        A.raise(16, baos);
        Reason.setScreen(new Machine(this.lastGlobalScore, true, this.totalTime, lr, baos.toByteArray(), isTimeout));
    }
}

