/*
 * Decompiled with CFR 0.152.
 */
package com.c2m.screens.games;

import com.c2m.screens.Machine;
import com.c2m.screens.games.Game;
import com.c2m.screens.games.questions.Question;
import com.c2m.screens.games.timers.RoundTimer;
import com.c2m.screens.games.timers.Timer;
import com.c2m.screens.popups.Ingame;
import com.c2m.screens.popups.Quit;
import com.c2m.utils.A;
import com.c2m.utils.C;
import com.c2m.utils.F;
import com.c2m.utils.R;
import com.c2m.utils.U;
import java.io.ByteArrayOutputStream;
import javax.microedition.lcdui.Graphics;

public class Flexibility
extends Game {
    public static final int[] CATEGORIES;
    public static final int[] QUESTION_TYPE_INDEX;
    private final int[] pips = new int[C.FLEXIBILITY_PIPS.length / 2];
    private int currentQuestion = 0;
    private final int FLEXIBILITY_BG_ELEMENT_WIDTH;
    private final int FLEXIBILITY_BG_ELEMENT_HEIGHT;
    private static final R[][] activeResources;

    public Flexibility() {
        this.FLEXIBILITY_BG_ELEMENT_WIDTH = R.FLEXIBILITY_BG_ELEMENT.i.getWidth();
        this.FLEXIBILITY_BG_ELEMENT_HEIGHT = R.FLEXIBILITY_BG_ELEMENT.i.getHeight();
        this.pips[0] = 3;
    }

    protected Timer createTimer() {
        return Timer.createRound(this, C.FLEXIBILITY_TIMER);
    }

    protected void drawBackground(Graphics g) {
        g.drawImage(R.FLEXIBILITY_BG_ELEMENT.i, C.FLEXIBILITY_BG_ELEMENT_X, C.FLEXIBILITY_BG_ELEMENT_Y, 20);
        g.drawRegion(R.FLEXIBILITY_BG_ELEMENT.i, 0, 0, this.FLEXIBILITY_BG_ELEMENT_WIDTH, this.FLEXIBILITY_BG_ELEMENT_HEIGHT, 2, C.WIDTH - C.FLEXIBILITY_BG_ELEMENT_X, C.FLEXIBILITY_BG_ELEMENT_Y, 24);
        this.drawCables(g, C.PERFECTIONISM_CABLES);
        for (int i = 0; i < C.FLEXIBILITY_PIPS.length; i += 2) {
            this.drawPip(g, C.FLEXIBILITY_PIPS[i], C.FLEXIBILITY_PIPS[i + 1], this.pips[i / 2]);
        }
    }

    protected R[][] getActiveResources() {
        return activeResources;
    }

    protected void nextQuestion() {
        this.timer.resume();
        if (this.currentQuestion >= C.FLEXIBILITY_PIPS.length / 2) {
            this.gameOver = true;
        } else {
            R.NEW_QUESTION_SOUND.s.play(true);
            this.question = Question.create(this, CATEGORIES[QUESTION_TYPE_INDEX[this.currentQuestion]], Question.generateRandomLevelAccordingBrainSize(this.brainSize));
        }
    }

    public void onTimeout(Timer timer) {
        this.onGameOver(true);
    }

    public void onAnswer(int index, boolean isCorrect) {
        this.question.onHighlight(this.getGraphics(), index);
        this.click(false);
        this.doPaint();
        this.timer.pause();
        if (isCorrect) {
            ++this.totalCorrectAnswers;
            this.setGlobalScore(this.getGlobalScore() + 1);
            this.pips[this.currentQuestion] = 2;
            if (++this.currentQuestion < this.pips.length) {
                this.pips[this.currentQuestion] = 3;
            }
        } else {
            ++this.totalWrongAnswers;
            this.setGlobalScore(this.getGlobalScore() - 1);
            this.timer.add(C.PERFECTIONISM_PENALTY);
        }
        this.nextQuestionCountDown = C.QUESTION_NEXT_COUNTDOWN;
    }

    public void onGameOver(boolean isTimeout) {
        this.complete();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (this.totalCorrectAnswers == this.pips.length && this.totalWrongAnswers == 0) {
            A.raise(7, baos);
        }
        U.suffle(CATEGORIES);
        int lr = this.getRecord();
        int s = (int)this.timer.getTimePassed();
        if (s > C.FLEXIBILITY_TIMER) {
            s = C.FLEXIBILITY_TIMER;
        }
        if (lr == Integer.MIN_VALUE) {
            lr = s;
            this.setRecord(lr);
        }
        if (s < lr) {
            this.setGlobalScore(this.getGlobalScore() + C.BREAKING_RECORD_BONUS);
            if (!A.raise(8, baos)) {
                A.raise(20, baos);
            }
            this.setRecord(s);
        }
        if (this.timer.getTimeLeft() < 5000L && this.timer.getTimeLeft() > 0L) {
            A.raise(19, baos);
        }
        A.raise(18, baos);
        A.raise(13, baos);
        A.raise(14, baos);
        A.raise(15, baos);
        A.raise(16, baos);
        Flexibility.setScreen(new Machine(this.lastGlobalScore, true, s, lr, baos.toByteArray(), isTimeout));
    }

    static {
        switch (F.SEQUEL_NO) {
            default: {
                CATEGORIES = U.suffle(new int[]{0, 1, 2, 3});
                QUESTION_TYPE_INDEX = new int[]{0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3};
                break;
            }
            case 2: {
                CATEGORIES = U.suffle(new int[]{0, 1, 2, 3, 4, 5});
                QUESTION_TYPE_INDEX = new int[]{0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5};
                break;
            }
            case 3: {
                CATEGORIES = U.suffle(new int[]{0, 1, 2, 3, 4, 5, 6, 7});
                QUESTION_TYPE_INDEX = new int[]{0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7};
                break;
            }
            case 4: {
                CATEGORIES = U.suffle(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8});
                QUESTION_TYPE_INDEX = new int[]{0, 0, 0, 1, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8};
            }
        }
        activeResources = new R[][]{{R.FLEXIBILITY_BG_ELEMENT, R.PIPS}, Game.activeResources, RoundTimer.activeResources, Ingame.activeResources, Quit.activeResources};
    }
}

