/*
 * Decompiled with CFR 0.152.
 */
package com.c2m.screens.games.questions;

import com.c2m.screens.Screen;
import com.c2m.screens.games.questions.Question;
import com.c2m.screens.games.questions.QuestionListener;
import com.c2m.utils.C;
import com.c2m.utils.F;
import com.c2m.utils.R;
import com.c2m.utils.U;
import javax.microedition.lcdui.Graphics;

public class TextQuestion
extends Question {
    protected TextQuestion(int type, QuestionListener questionListener, int level, int randNum) {
        super(type, questionListener, level, randNum);
    }

    public void onPaint(Graphics g) {
        this.drawQuestion(g);
        if (this.response < 0 && !this.isWrongAnswer) {
            for (int i = 0; i < C.ANSWER_BUTTONS.length; ++i) {
                this.drawButton(g, i, i == this.selected && !noSoft, this.answers[i], this.answersWidths[i]);
            }
        } else {
            int[] f = C.ANIMATED_TEXT_FRAMES[this.response == this.correctAnswer ? 0 : 1];
            g.drawRegion(R.ANIMATED_TEXT.i, f[0], f[1], f[2], f[3], 0, C.WIDTH / 2, C.ANSWER_BUTTONS[1][1], 3);
        }
    }

    protected void drawQuestion(Graphics g) {
        R.BLUE_FONT.f.drawString(g, this.title, C.QUESTION_FRAME_POS[0], C.QUESTION_TITLE_Y, 2);
        R.BLUE_FONT.f.drawString(g, this.subtitle, C.QUESTION_FRAME_POS[0], C.QUESTION_SUBTITLE_Y, 2);
    }

    public void onHighlight(Graphics g, int i) {
        if (i >= 0) {
            this.drawButton(g, i, true, this.answers[i], this.answersWidths[i]);
        }
    }

    public void onTouch(int x, int y) {
        if (!this.isWrongAnswer && this.response < 0) {
            for (int i = 0; i < C.ANSWER_BUTTONS.length; ++i) {
                if (!U.pointIn(x, y, C.ANSWER_BUTTONS[i])) continue;
                if (i == this.correctAnswer) {
                    R.CORRECT_ANSWER_SOUND.s.play(true);
                    int ca = F.loadInt("CORRECT_ANSWER_" + this.type);
                    F.saveInt("CORRECT_ANSWER_" + this.type, ca == Integer.MIN_VALUE ? 0 : ca + 1);
                    this.questionListener.onAnswer(i, true);
                } else {
                    R.WRONG_ANSWER_SOUND.s.play(true);
                    this.questionListener.onAnswer(i, false);
                }
                this.response = i;
                return;
            }
        }
    }

    public void onKey(int k) {
        if (!this.isWrongAnswer && this.response < 0) {
            switch (Screen.getCurrent().getGameAction(k)) {
                case 1: {
                    this.selected = (this.selected + 3) % 4;
                    break;
                }
                case 6: {
                    ++this.selected;
                    this.selected %= 4;
                    break;
                }
                case 8: {
                    if (this.selected == this.correctAnswer) {
                        R.CORRECT_ANSWER_SOUND.s.play(true);
                        int ca = F.loadInt("CORRECT_ANSWER_" + this.type);
                        F.saveInt("CORRECT_ANSWER_" + this.type, ca == Integer.MIN_VALUE ? 0 : ca + 1);
                        this.questionListener.onAnswer(this.selected, true);
                    } else {
                        R.WRONG_ANSWER_SOUND.s.play(true);
                        this.questionListener.onAnswer(this.selected, false);
                    }
                    this.response = this.selected;
                }
            }
        }
    }
}

