/*
 * Decompiled with CFR 0.152.
 */
package com.c2m.screens.games;

import com.c2m.screens.Machine;
import com.c2m.screens.games.Game;
import com.c2m.screens.games.questions.Question;
import com.c2m.screens.games.timers.RoundTimer;
import com.c2m.screens.games.timers.Timer;
import com.c2m.screens.popups.Ingame;
import com.c2m.screens.popups.Quit;
import com.c2m.utils.A;
import com.c2m.utils.C;
import com.c2m.utils.R;
import com.c2m.utils.U;
import java.io.ByteArrayOutputStream;
import javax.microedition.lcdui.Graphics;

public class Determination
extends Game {
    private final int[] pips = new int[C.DETERMINATION_PIPS.length / 2];
    private int currentQuestion = 0;
    private int questionLevel = 0;
    private static final R[][] activeResources = new R[][]{{R.DETERMINATION_BG_ELEMENT, R.PIPS}, Game.activeResources, RoundTimer.activeResources, Ingame.activeResources, Quit.activeResources};

    public Determination() {
        this.pips[0] = 3;
    }

    protected Timer createTimer() {
        return Timer.createRound(this, C.PERFECTIONISM_TIMER);
    }

    protected void drawBackground(Graphics g) {
        g.drawImage(R.DETERMINATION_BG_ELEMENT.i, C.DETERMINATION_BG_ELEMENT_X, C.DETERMINATION_BG_ELEMENT_Y, 20);
        this.drawCables(g, C.PERFECTIONISM_CABLES);
        for (int i = 0; i < C.DETERMINATION_PIPS.length; i += 2) {
            this.drawPip(g, C.DETERMINATION_PIPS[i], C.DETERMINATION_PIPS[i + 1], this.pips[i / 2]);
        }
    }

    protected R[][] getActiveResources() {
        return activeResources;
    }

    protected void nextQuestion() {
        this.timer.resume();
        if (this.currentQuestion >= C.DETERMINATION_PIPS.length / 2 - 1) {
            this.gameOver = true;
        } else {
            R.NEW_QUESTION_SOUND.s.play(true);
            this.question = Question.create(this, (this.lastQuestionType + 1 + U.rand(Question.QUESTION_TYPE_COUNT - 1)) % Question.QUESTION_TYPE_COUNT, this.questionLevel);
            this.lastQuestionType = this.question.getType();
            if (this.pips != null) {
                this.pips[++this.currentQuestion] = 3;
            }
        }
    }

    public void onTimeout(Timer timer) {
        this.onGameOver(true);
    }

    public void onAnswer(int index, boolean isCorrect) {
        this.question.onHighlight(this.getGraphics(), index);
        this.click(false);
        this.doPaint();
        this.timer.pause();
        if (isCorrect) {
            ++this.totalCorrectAnswers;
            this.setGlobalScore(this.getGlobalScore() + 1);
            this.pips[this.currentQuestion] = 2;
            ++this.questionLevel;
        } else {
            ++this.totalWrongAnswers;
            this.setGlobalScore(this.getGlobalScore() - 1);
            this.pips[this.currentQuestion] = 1;
        }
        this.nextQuestionCountDown = C.QUESTION_NEXT_COUNTDOWN;
    }

    public void onGameOver(boolean isTimeout) {
        int lr;
        this.complete();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (this.totalCorrectAnswers == this.pips.length && this.totalWrongAnswers == 0) {
            A.raise(9, baos);
        }
        if ((lr = this.getRecord()) == Integer.MIN_VALUE) {
            lr = this.questionLevel;
            this.setRecord(lr);
        }
        if (this.questionLevel > lr) {
            this.setGlobalScore(this.getGlobalScore() + C.BREAKING_RECORD_BONUS);
            if (!A.raise(10, baos)) {
                A.raise(20, baos);
            }
            this.setRecord(this.questionLevel);
        }
        if (this.timer.getTimeLeft() < 5000L && this.timer.getTimeLeft() > 0L) {
            A.raise(19, baos);
        }
        A.raise(18, baos);
        A.raise(13, baos);
        A.raise(14, baos);
        A.raise(15, baos);
        A.raise(16, baos);
        Determination.setScreen(new Machine(this.lastGlobalScore, false, this.questionLevel, lr, baos.toByteArray(), isTimeout));
    }
}

