/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.Resources;
import sk.inlogic.util.RandomNum;

public class Jewel {
    public static final int BONUS_NONE = 0;
    public static final int BONUS_BOMB = 1;
    public static final int BONUS_SPECTRUM = 2;
    public static final int BONUS_ROW = 3;
    public static final int BONUS_COL = 4;
    public static final int BONUS_CROSS = 5;
    public static final int BONUS_FALL = 6;
    public static final int BONUS_ESCAPE = 7;
    public static final int RES_ROTATE = 0;
    public static final int RES_FADE = 1;
    public static final int RES_SPECTRUM = 2;
    public static final int RES_FALL = 3;
    public static final int RES_FADEFALL = 4;
    public static int BLOCKSIZE;
    public static int MOVE_VELOCITY;
    public static int DSP_BNSBOMB;
    public static int DSP_BNSCROSS;
    public static final int UPDATEDURATION = 50;
    private static final int[] RESROTATEFRAMESEQUENCE;
    private static final int[] RESSPECTRUMFRAMESEQUENCE;
    private static final int[] RESFALLFRAMESEQUENCE;
    private static final int[] RESFALLFFRAMESEQUENCE;
    private static final int[] RESCROSSFRAMESEQUENCE;
    private static final int[] RESEXPLODEFRAMESEQUENCE;
    private static final int[] RESESCAPEFFRAMESEQUENCE;
    private int resource;
    private int resourceFrame;
    private int repeats;
    private int color;
    private int deltaX;
    private int deltaY;
    private int velX;
    private int velY;
    private int accX;
    private int accY;
    private int bonusType;
    private int bonusFrame;

    public Jewel() {
        this.reset();
    }

    public void reset() {
        this.resource = 0;
        this.color = 0;
        this.deltaX = 0;
        this.deltaY = 0;
        this.velX = 0;
        this.velY = 0;
        this.accX = 0;
        this.accY = 0;
        this.repeats = 0;
        this.resourceFrame = 0;
        this.bonusType = 0;
        this.bonusFrame = 0;
    }

    public void update() {
        this.updatePosition();
        this.updateAnimation();
        this.updateBonus();
    }

    public void updateFall() {
        this.updatePositionFall();
        this.updateAnimation();
        this.updateBonus();
    }

    private void updatePositionFall() {
        this.deltaX += this.velX;
        this.velX += this.accX;
        this.deltaY += this.velY;
        this.velY += this.accY;
        if (this.velX < -1280) {
            this.velX = -1280;
        }
    }

    private void updatePosition() {
        if (this.deltaX > 0) {
            this.deltaX += this.velX;
            this.velX += this.accX;
            if (this.deltaX <= 0) {
                this.deltaX = 0;
                this.velX = 0;
                this.accX = 0;
            }
        } else if (this.deltaX < 0) {
            this.deltaX += this.velX;
            this.velX += this.accX;
            if (this.deltaX >= 0) {
                this.deltaX = 0;
                this.velX = 0;
                this.accX = 0;
            }
        }
        if (this.deltaY > 0) {
            this.deltaY += this.velY;
            this.velY += this.accY;
            if (this.deltaY <= 0) {
                this.deltaY = 0;
                this.velY = 0;
                this.accY = 0;
            }
        } else if (this.deltaY < 0) {
            this.deltaY += this.velY;
            this.velY += this.accY;
            if (this.deltaY >= 0) {
                this.deltaY = 0;
                this.velY = 0;
                this.accY = 0;
            }
        }
    }

    private void updateAnimation() {
        if (this.repeats != 0) {
            int framesCount = 0;
            if (this.resource == 0) {
                framesCount = RESROTATEFRAMESEQUENCE.length - 1;
            } else if (this.resource == 2) {
                framesCount = RESSPECTRUMFRAMESEQUENCE.length - 1;
            }
            if (this.resourceFrame < framesCount) {
                ++this.resourceFrame;
            } else {
                if (this.repeats > 0) {
                    --this.repeats;
                }
                this.resourceFrame = 0;
            }
        }
    }

    private void updateBonus() {
        if (this.bonusType == 5) {
            this.bonusFrame = this.bonusFrame < RESCROSSFRAMESEQUENCE.length - 1 ? ++this.bonusFrame : 0;
        } else if (this.bonusType == 1) {
            this.bonusFrame = this.bonusFrame < RESEXPLODEFRAMESEQUENCE.length - 1 ? ++this.bonusFrame : 0;
        } else if (this.bonusType == 7) {
            this.bonusFrame = this.bonusFrame < RESESCAPEFFRAMESEQUENCE.length - 1 ? ++this.bonusFrame : 0;
        }
    }

    public void paint(Graphics g, int x, int y, boolean shake) {
        int bonusType = this.bonusType;
        int resource = this.resource;
        int resourceFrame = this.resourceFrame;
        Sprite sprRes = Resources.resSprs[1];
        int animFrame = 0;
        int color = this.color;
        int dx = 0;
        int dy = 0;
        if (resource == 0) {
            if (resourceFrame >= RESROTATEFRAMESEQUENCE.length) {
                resourceFrame = 0;
            }
            animFrame = RESROTATEFRAMESEQUENCE[resourceFrame];
            if (shake) {
                dx = RandomNum.getRandomInt(2);
                dy = RandomNum.getRandomInt(2);
            }
        } else if (resource != 1) {
            if (resource == 2) {
                sprRes = Resources.resSprs[2];
                animFrame = RESSPECTRUMFRAMESEQUENCE[resourceFrame];
                color = 0;
            } else if (resource == 3) {
                sprRes = Resources.resSprs[10];
                animFrame = 0;
                color = 0;
            } else if (resource == 4) {
                sprRes = Resources.resSprs[10];
                animFrame = 0;
                color = 0;
            }
        }
        sprRes.setFrame(6 * color + animFrame);
        sprRes.setPosition(x + (this.deltaX >> 8) + dx, y + (this.deltaY >> 8) + dy);
        if (bonusType != 1 && bonusType != 5) {
            sprRes.paint(g);
        }
        if (bonusType == 1) {
            Sprite sprBns = Resources.resSprs[3];
            sprBns.setFrame(6 * color + RESEXPLODEFRAMESEQUENCE[this.bonusFrame]);
            sprBns.setPosition(x + (this.deltaX >> 8) - DSP_BNSBOMB, y + (this.deltaY >> 8) - DSP_BNSBOMB);
            sprBns.paint(g);
        } else if (bonusType == 7) {
            Sprite jewel = Resources.resSprs[10];
            jewel.setFrame(1 + color);
            jewel.setPosition(x + (this.deltaX >> 8), y + (this.deltaY >> 8));
            jewel.paint(g);
        } else if (bonusType == 5) {
            Sprite sprBns = Resources.resSprs[8];
            sprBns.setFrame(6 * color + RESCROSSFRAMESEQUENCE[this.bonusFrame]);
            sprBns.setPosition(x + (this.deltaX >> 8) - DSP_BNSCROSS, y + (this.deltaY >> 8) - DSP_BNSCROSS);
            sprBns.paint(g);
        }
    }

    public int getResource() {
        return this.resource;
    }

    public int getColor() {
        return this.color;
    }

    public int getDeltaX() {
        return this.deltaX >> 8;
    }

    public int getDeltaY() {
        return this.deltaY >> 8;
    }

    public int getVelX() {
        return this.velX;
    }

    public int getVelY() {
        return this.velY;
    }

    public int getAccY() {
        return this.accY;
    }

    public int getAccX() {
        return this.accX;
    }

    public int getAnimationRepeats() {
        return this.repeats;
    }

    public int getAnimationFrame() {
        return this.resourceFrame;
    }

    public void setResource(int resource) {
        this.resource = resource;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setVelX(int velX) {
        this.velX = velX;
    }

    public void setVelY(int velY) {
        this.velY = velY;
    }

    public void setAccY(int accY) {
        this.accY = accY;
    }

    public void setAccX(int accX) {
        this.accX = accX;
    }

    public void setDeltaX(int dx) {
        this.deltaX = dx << 8;
    }

    public void setDeltaY(int dy) {
        this.deltaY = dy << 8;
    }

    public boolean isMoving() {
        return this.deltaX != 0 || this.deltaY != 0;
    }

    public void startAnimation(int repeat) {
        this.repeats = repeat;
        this.resourceFrame = 0;
    }

    public void stopAnimation() {
        this.repeats = 0;
        this.resourceFrame = 0;
    }

    public void setBonus(int bonusType) {
        this.bonusType = bonusType;
        this.bonusFrame = 0;
        this.resource = 0;
        if (bonusType == 2) {
            this.resource = 2;
            this.startAnimation(-1);
        } else if (bonusType == 6) {
            this.resource = 3;
            this.startAnimation(-1);
        }
    }

    public int getBonus() {
        return this.bonusType;
    }

    public boolean isColorDepended() {
        return this.bonusType != 2 && this.bonusType != 6;
    }

    public int getTileColor(int i, int j) {
        for (int x = 0; x < 8; ++x) {
            for (int y = 0; y < 8; ++y) {
                if ((x + y) % 2 == 0) {
                    if (x != i || y != j) continue;
                    return 0;
                }
                if (x != i || y != j) continue;
                return 1;
            }
        }
        return 0;
    }

    public void load(DataInputStream dis) throws IOException {
        this.resource = dis.readInt();
        this.resourceFrame = dis.readInt();
        this.repeats = dis.readInt();
        this.color = dis.readInt();
        this.deltaX = dis.readInt();
        this.deltaY = dis.readInt();
        this.velX = dis.readInt();
        this.velY = dis.readInt();
        this.accX = dis.readInt();
        this.accY = dis.readInt();
        this.bonusType = dis.readInt();
        this.bonusFrame = dis.readInt();
    }

    public void save(DataOutputStream dos) throws IOException {
        dos.writeInt(this.resource);
        dos.writeInt(this.resourceFrame);
        dos.writeInt(this.repeats);
        dos.writeInt(this.color);
        dos.writeInt(this.deltaX);
        dos.writeInt(this.deltaY);
        dos.writeInt(this.velX);
        dos.writeInt(this.velY);
        dos.writeInt(this.accX);
        dos.writeInt(this.accY);
        dos.writeInt(this.bonusType);
        dos.writeInt(this.bonusFrame);
    }

    static {
        RESROTATEFRAMESEQUENCE = new int[]{0, 1, 1, 2, 2, 3, 3, 4, 4, 5};
        RESSPECTRUMFRAMESEQUENCE = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5};
        RESFALLFRAMESEQUENCE = new int[]{0};
        RESFALLFFRAMESEQUENCE = new int[]{0};
        RESCROSSFRAMESEQUENCE = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5};
        RESEXPLODEFRAMESEQUENCE = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5};
        RESESCAPEFFRAMESEQUENCE = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11};
    }
}

