/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.Settings;
import sk.inlogic.Sounds;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenSplash
implements IScreen {
    private static final int MODE_ENABLE_MUSIC_QUESTION = 0;
    private static final int MODE_COMPANY_LOGO = 1;
    private static final int MODE_SPLASH = 2;
    private static final int MODE_TIME = 3000;
    private MainCanvas mainCanvas;
    private int mode;
    private long modeDelay;
    private int bodyAnimation;
    private final int[] ORNAMENTSEQUENCE = new int[]{0, 0, 0, 1, 1, 1, 2, 2, 2};
    private final int[] SELECTEDSEQUENCE = new int[]{1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6};
    private int resourceFrame = 0;
    private int repeats = 0;
    private int resourceFrame1 = 0;
    private int repeats1 = 0;
    private int fkAnimationR = 0;
    private int fkAnimationL = 0;
    private int fkIconAnimationR = 0;
    private int fkIconAnimationL = 0;
    private int hideFkLAnimation = 0;
    private int hideFkRAnimation = 0;
    private int showFkRAnimation = 0;
    private int bodyAnimation2 = 0;
    private int bottomHide = 0;
    private int bottomAnimationS = 0;
    private int bottomAnimationH = 0;
    private int interuption = 0;
    private int topAnimation = 0;
    boolean bottom = false;
    private boolean hide = false;
    private Rectangle rectDialog;
    private PreparedText title;
    private int kCode = 0;

    public ScreenSplash(MainCanvas mainCanvas) {
        this.mainCanvas = mainCanvas;
    }

    public void beforeShow() {
        Resources.loadSprite(16);
        this.mode = 0;
        Resources.loadImage(19);
        Resources.loadImages(new int[]{15, 17, 1});
        Resources.loadSprites(new int[]{19, 17, 15, 16, 18, 16, 16, 0});
        Resources.loadGFont(3);
        Resources.loadText(0);
        this.calculatePosition();
    }

    public void afterHide() {
        Resources.freeSprite(16);
        Resources.freeImage(19);
        Resources.freeImages(new int[]{15, 17, 1});
        Resources.freeSprites(new int[]{19, 17, 15, 16, 18, 16, 16, 0});
        Resources.freeGFont(3);
    }

    public void calculatePosition() {
        int iconWidth = Resources.resSprs[0].getWidth();
        int bgIconWidth = Resources.resSprs[16].getWidth();
        int downHeight = Resources.resSprs[18].getHeight();
        this.rectDialog = new Rectangle(0, Resources.resSprs[15].getHeight(), this.mainCanvas.getWidth(), this.mainCanvas.getHeight() - Resources.resSprs[18].getHeight() - Resources.resSprs[15].getHeight());
        this.fkAnimationR = this.mainCanvas.getWidth();
        this.fkAnimationL = 0 - bgIconWidth;
        this.fkIconAnimationR = this.mainCanvas.getWidth() + iconWidth;
        this.fkIconAnimationL = 0 - iconWidth;
        this.showFkRAnimation = this.mainCanvas.getWidth() + iconWidth;
        this.hideFkRAnimation = this.mainCanvas.getWidth() - iconWidth;
        this.hideFkLAnimation = 0 - iconWidth;
        this.bottomAnimationH = this.bottomHide = this.mainCanvas.getHeight();
        this.bottomAnimationS = this.mainCanvas.getHeight() - downHeight;
        this.topAnimation = 0 - Resources.resSprs[16].getHeight();
        this.bodyAnimation = this.rectDialog.y + this.rectDialog.height;
        this.title = new PreparedText(Resources.resGFonts[3]);
        this.title.prepareText(Resources.resTexts[0].getHashedString(28), this.mainCanvas.getWidth());
    }

    public void beforeInteruption() {
        if (this.mode == 0) {
            MainCanvas.soundManager.Stop();
        }
        MainCanvas.soundManager.Stop();
    }

    public void afterInteruption() {
        MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
        if (this.mode == 0) {
            MainCanvas.soundManager.Stop();
        }
    }

    public void update(long lastRunLenght) {
        switch (this.mode) {
            case 1: 
            case 2: {
                if (this.modeDelay > 0L) {
                    this.modeDelay -= lastRunLenght;
                    return;
                }
                this.nextMode();
                break;
            }
            case 0: {
                this.topAnimationShow();
                this.bottomAnimationShow();
                this.bodyAnimationShow();
                this.fkAnimationShow();
                this.updateAnimationTop();
                this.updateAnimationBottom();
                if (!this.hide) break;
                this.topAnimationHide();
                this.bodyAnimationHide();
                this.bottomAnimationHide();
                this.fkAnimationHide();
                if (Keys.isFKRightCode(this.kCode)) {
                    Settings.musicOn = false;
                    MainCanvas.soundManager.SetSoundOn(false);
                    this.nextMode();
                    break;
                }
                if (!Keys.isFKLeftCode(this.kCode)) break;
                Settings.musicOn = true;
                MainCanvas.soundManager.SetSoundOn(true);
                this.nextMode();
            }
        }
    }

    private void nextMode() {
        switch (this.mode) {
            case 0: {
                Resources.loadImage(1);
                Resources.loadSprite(0);
                this.modeDelay = 3000L;
                this.mode = 1;
                this.mainCanvas.repaint();
                this.mainCanvas.serviceRepaints();
                break;
            }
            case 1: {
                Resources.freeImage(1);
                Resources.loadImage(0);
                this.modeDelay = 3000L;
                this.mode = 2;
                this.mainCanvas.repaint();
                this.mainCanvas.serviceRepaints();
                break;
            }
            case 2: {
                Resources.freeImage(0);
                if (MainCanvas.soundManager.IsSoundOn()) {
                    MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                }
                this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0));
                this.mainCanvas.repaint();
                this.mainCanvas.serviceRepaints();
            }
        }
    }

    private void topAnimationShow() {
        while (this.topAnimation != 0) {
            ++this.topAnimation;
            this.mainCanvas.repaint();
        }
    }

    private void topAnimationHide() {
        while (this.topAnimation != 0 - Resources.resSprs[15].getHeight()) {
            --this.topAnimation;
            this.mainCanvas.repaint();
        }
    }

    private void bodyAnimationShow() {
        while (this.bodyAnimation != this.rectDialog.y) {
            --this.bodyAnimation;
            ++this.bodyAnimation2;
            this.mainCanvas.repaint();
        }
    }

    private void bodyAnimationHide() {
        while (this.bodyAnimation < this.bottomAnimationS) {
            ++this.bodyAnimation;
            --this.bodyAnimation2;
            this.mainCanvas.repaint();
        }
        this.bottom = false;
    }

    private void bottomAnimationShow() {
        while (this.bottomHide != this.bottomAnimationS) {
            --this.bottomHide;
            this.mainCanvas.repaint();
        }
        this.bottom = true;
    }

    private void bottomAnimationHide() {
        while (this.bottomHide != this.bottomAnimationH) {
            ++this.bottomHide;
            this.mainCanvas.repaint();
        }
    }

    private void fkAnimationShow() {
        while (this.fkAnimationR != this.mainCanvas.getWidth() - Resources.resSprs[16].getWidth()) {
            --this.fkAnimationR;
            if (0 > this.fkAnimationL) {
                ++this.fkAnimationL;
            }
            this.mainCanvas.repaint();
        }
        while (this.fkIconAnimationR != this.hideFkRAnimation) {
            --this.fkIconAnimationR;
            if (this.fkIconAnimationL != 0) {
                ++this.fkIconAnimationL;
            }
            this.mainCanvas.repaint();
        }
    }

    private void fkAnimationHide() {
        while (this.fkIconAnimationR != this.showFkRAnimation) {
            ++this.fkIconAnimationR;
            if (this.fkIconAnimationL > this.hideFkLAnimation) {
                --this.fkIconAnimationL;
            }
            this.mainCanvas.repaint();
        }
        while (this.fkAnimationR != this.mainCanvas.getWidth() + Resources.resSprs[16].getWidth()) {
            ++this.fkAnimationR;
            if (0 - Resources.resSprs[16].getWidth() < this.fkAnimationL) {
                --this.fkAnimationL;
            }
            this.mainCanvas.repaint();
        }
    }

    public void updateAnimationTop() {
        int framesCount = 0;
        framesCount = this.ORNAMENTSEQUENCE.length - 1;
        if (this.resourceFrame1 < framesCount) {
            ++this.resourceFrame1;
        } else {
            if (this.repeats1 > 0) {
                --this.repeats1;
            }
            this.resourceFrame1 = 0;
        }
        this.mainCanvas.repaint();
    }

    public void updateAnimationBottom() {
        int framesCount = 0;
        framesCount = this.ORNAMENTSEQUENCE.length - 1;
        if (this.resourceFrame < framesCount) {
            ++this.resourceFrame;
        } else {
            if (this.repeats > 0) {
                --this.repeats;
            }
            this.resourceFrame = 0;
        }
        this.mainCanvas.repaint();
    }

    public void paintSoundTop(Graphics g) {
        Sprite time = Resources.resSprs[15];
        Sprite bg = Resources.resSprs[16];
        Image light = Resources.resImgs[17];
        Sprite icons = Resources.resSprs[17];
        Rectangle tit = new Rectangle();
        int animFrame = 0;
        animFrame = this.resourceFrame1 < 0 ? 0 : this.SELECTEDSEQUENCE[this.resourceFrame1];
        g.drawImage(light, 0, this.topAnimation, 20);
        bg.setFrame(0);
        bg.setPosition(5, this.topAnimation + time.getHeight() / 8);
        bg.paint(g);
        bg.setFrame(1);
        for (int i = bg.getWidth(); i < MainCanvas.WIDTH - 5 - bg.getWidth(); i += bg.getWidth()) {
            bg.setPosition(i, this.topAnimation + time.getHeight() / 8);
            bg.paint(g);
        }
        Rectangle titleRect = new Rectangle(5 + bg.getWidth() / 4 + time.getWidth(), this.topAnimation + time.getHeight() / 8, MainCanvas.WIDTH, bg.getHeight());
        this.title.drawText(g, titleRect, 0, 6);
        bg.setFrame(2);
        bg.setPosition(MainCanvas.WIDTH - bg.getWidth() - 5, this.topAnimation + time.getHeight() / 8);
        bg.paint(g);
        time.setFrame(animFrame);
        time.setPosition(5 + bg.getWidth() / 4, this.topAnimation);
        g.drawImage(light, 0, this.topAnimation + time.getHeight() / 8 + bg.getHeight(), 20);
        time.paint(g);
        icons.setFrame(3);
        icons.setPosition(5 + bg.getWidth() / 4 + time.getWidth() / 4 + icons.getWidth() / 4, this.topAnimation + bg.getHeight() / 4);
        icons.paint(g);
        Image border = Resources.resImgs[15];
        g.drawImage(border, 0, this.bottom ? this.bodyAnimation : this.bottomHide - border.getHeight(), 20);
    }

    public void paintSoundBottom(Graphics g) {
        Image border = Resources.resImgs[15];
        g.drawImage(border, 0, this.bottomHide - border.getHeight(), 20);
        int animFrame = 0;
        animFrame = this.resourceFrame < 0 ? 0 : this.ORNAMENTSEQUENCE[this.resourceFrame];
        Sprite s = Resources.resSprs[18];
        s.setFrame(animFrame);
        s.setPosition(this.mainCanvas.getWidth() / 2 - s.getWidth() / 2, this.bottomHide);
        s.paint(g);
    }

    public void paintSoundBoby(Graphics g) {
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        g.setColor(0);
        g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        g.setColor(0, 49, 49);
        g.fillRect(this.rectDialog.x, this.bodyAnimation, this.rectDialog.width, this.rectDialog.height);
        g.setColor(0, 0, 0);
        g.fillRect(this.rectDialog.x, this.bottomAnimationS, this.rectDialog.width, this.rectDialog.height);
        g.drawImage(Resources.resImgs[19], this.rectDialog.getCenterX(), this.rectDialog.getCenterY(), 3);
        g.setColor(0);
        g.fillRect(this.rectDialog.x, this.rectDialog.y, this.rectDialog.width, this.rectDialog.height - this.bodyAnimation2);
    }

    public void paintSoundFk(Graphics g) {
        Sprite funKey = Resources.resSprs[16];
        Sprite fk = Resources.resSprs[0];
        funKey.setFrame(2);
        funKey.setPosition(this.fkAnimationL, this.mainCanvas.getHeight() - funKey.getHeight());
        funKey.paint(g);
        fk.setFrame(1);
        fk.setPosition(this.fkIconAnimationL, this.mainCanvas.getHeight() - funKey.getHeight() + funKey.getHeight() / 2 - fk.getHeight() / 2);
        fk.paint(g);
        funKey.setFrame(0);
        funKey.setPosition(this.fkAnimationR, this.mainCanvas.getHeight() - funKey.getHeight());
        funKey.paint(g);
        fk.setFrame(2);
        fk.setPosition(this.fkIconAnimationR, this.mainCanvas.getHeight() - funKey.getHeight() + funKey.getHeight() / 2 - fk.getHeight() / 2);
        fk.paint(g);
    }

    public void paint(Graphics g) {
        switch (this.mode) {
            case 0: {
                this.paintSoundBoby(g);
                this.paintSoundBottom(g);
                this.paintSoundTop(g);
                this.paintSoundFk(g);
                break;
            }
            case 1: {
                g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
                g.setColor(0);
                g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
                g.drawImage(Resources.resImgs[1], MainCanvas.WIDTH / 2, MainCanvas.HEIGHT / 2, 3);
                break;
            }
            case 2: {
                g.drawImage(Resources.resImgs[0], 0, 0, 20);
            }
        }
    }

    public void keyPressed(int keyCode) {
    }

    public void keyReleased(int keyCode) {
        switch (this.mode) {
            case 0: {
                if (Keys.isFKLeftCode(keyCode)) {
                    this.kCode = keyCode;
                    this.hide = true;
                    break;
                }
                if (!Keys.isFKRightCode(keyCode)) break;
                this.kCode = keyCode;
                this.hide = true;
                break;
            }
            case 1: 
            case 2: {
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                this.nextMode();
            }
        }
    }

    public void pointerPressed(int x, int y) {
        switch (this.mode) {
            case 0: {
                if (x < MainCanvas.WIDTH / 2) {
                    Keys.keyPressed(-202);
                    break;
                }
                Keys.keyPressed(-203);
                break;
            }
            case 1: 
            case 2: {
                Keys.keyPressed(53);
            }
        }
    }

    public void pointerDragged(int x, int y) {
    }

    public void pointerReleased(int x, int y) {
        switch (this.mode) {
            case 0: {
                if (x < MainCanvas.WIDTH / 2) {
                    this.keyReleased(-202);
                    Keys.keyReleased(-202);
                    break;
                }
                this.keyReleased(-203);
                Keys.keyReleased(-203);
                break;
            }
            case 1: 
            case 2: {
                if (!Keys.isKeyPressed(53)) break;
                this.keyReleased(53);
                Keys.keyReleased(53);
            }
        }
    }
}

