/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.X;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenAbout
implements IScreen {
    private MainCanvas mainCanvas;
    private static final int COMP_ID_BACK = 0;
    private static final int COMP_ID_INLOGIC = 1;
    private static final int TOTAL_COMP_IDS = 2;
    private Rectangle[] rectItems = new Rectangle[2];
    private Rectangle rectText;
    private Rectangle rectDialog;
    private int selectedCompId;
    private static PreparedText preparedText;
    private static final String INLOGIC_URL = "http://www.inlogic.eu";
    private int interuption = 0;
    private static final int textMarginTop = 20;
    private final int[] ORNAMENTSEQUENCE = new int[]{0, 0, 0, 1, 1, 1, 2, 2, 2};
    private final int[] SELECTEDSEQUENCE = new int[]{1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6};
    private int resourceFrame = 0;
    private int repeats = 0;
    private int resourceFrame1 = 0;
    private int repeats1 = 0;
    private PreparedText title;
    private int fkAnimation = 0;
    private int fkIconAnimation = 0;
    private int bottomHide = 0;
    private int bottomAnimationS = 0;
    private int bottomAnimationH = 0;
    private int topAnimation = 0;
    boolean bottom = false;
    private int bodyAnimation2 = 0;
    private int bodyAnimation;

    public ScreenAbout(MainCanvas mainCanvas) {
        this.mainCanvas = mainCanvas;
    }

    public void beforeShow() {
        Resources.loadImages(new int[]{15, 17, 1});
        Resources.loadSprites(new int[]{19, 17, 15, 16, 18, 16, 16, 0});
        Resources.loadGFont(3);
        this.calculatePositions();
        Resources.loadGFont(3);
        preparedText = new PreparedText(Resources.resGFonts[3]);
        preparedText.prepareText(X.singleton.getAppProperty("MIDlet-Name").toUpperCase() + ", " + X.singleton.getAppProperty("MIDlet-Version"), this.rectText.width);
        this.title = new PreparedText(Resources.resGFonts[3]);
        this.title.prepareText(Resources.resTexts[0].getHashedString(23), this.rectText.width);
    }

    public void afterHide() {
        Resources.freeImages(new int[]{15, 17, 1});
        Resources.freeSprites(new int[]{19, 17, 15, 16, 18, 16, 16, 0});
        Resources.freeGFont(3);
    }

    public void beforeInteruption() {
        MainCanvas.soundManager.Stop();
    }

    public void afterInteruption() {
        MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
    }

    private void calculatePositions() {
        int fkWidth = Resources.resSprs[0].getWidth();
        int fkHeight = Resources.resSprs[0].getHeight();
        this.rectDialog = new Rectangle(0, Resources.resSprs[15].getHeight(), this.mainCanvas.getWidth(), this.mainCanvas.getHeight() - Resources.resSprs[18].getHeight() - Resources.resSprs[15].getHeight());
        this.rectItems[0] = new Rectangle(MainCanvas.WIDTH - fkWidth, MainCanvas.HEIGHT - fkHeight, fkWidth, fkHeight);
        Image imgLogo = Resources.resImgs[1];
        this.rectItems[1] = new Rectangle(this.rectDialog.x + (this.rectDialog.width >> 1) - (imgLogo.getWidth() >> 1), this.rectDialog.y + (this.rectDialog.height >> 1) - (imgLogo.getHeight() >> 1) - 20, imgLogo.getWidth(), imgLogo.getHeight());
        this.rectText = new Rectangle(this.rectDialog.x, this.rectItems[1].getBottom() + 20, this.rectDialog.width, (this.rectDialog.height >> 1) - 20);
        this.fkAnimation = this.mainCanvas.getWidth() + Resources.resSprs[16].getWidth();
        this.fkIconAnimation = this.mainCanvas.getWidth() + Resources.resSprs[0].getWidth();
        this.bodyAnimation = this.rectDialog.y + this.rectDialog.height;
        this.bottomAnimationH = this.bottomHide = this.mainCanvas.getHeight();
        this.bottomAnimationS = this.mainCanvas.getHeight() - Resources.resSprs[18].getHeight();
        this.topAnimation = 0 - Resources.resSprs[16].getHeight();
        this.bodyAnimation = this.rectDialog.y + this.rectDialog.height;
    }

    public void update(long lastRunLenght) {
        this.topAnimationShow();
        this.bottomAnimationShow();
        this.bodyAnimationShow();
        this.fkAnimation(true);
        this.updateAnimationTop();
        this.updateAnimationBottom();
        if (Keys.isKeyPressed(-203)) {
            this.topAnimationHide();
            this.bodyAnimationHide();
            this.bottomAnimationHide();
            this.fkAnimation(false);
            this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 2));
        }
    }

    private void topAnimationShow() {
        while (this.topAnimation != 0) {
            ++this.topAnimation;
            this.mainCanvas.repaint();
        }
    }

    private void topAnimationHide() {
        while (this.topAnimation != 0 - Resources.resSprs[15].getHeight()) {
            --this.topAnimation;
            this.mainCanvas.repaint();
        }
    }

    private void bodyAnimationShow() {
        while (this.bodyAnimation != this.rectDialog.y) {
            --this.bodyAnimation;
            ++this.bodyAnimation2;
            this.mainCanvas.repaint();
        }
    }

    private void bodyAnimationHide() {
        while (this.bodyAnimation < this.bottomAnimationS) {
            ++this.bodyAnimation;
            --this.bodyAnimation2;
            this.mainCanvas.repaint();
        }
        this.bottom = false;
    }

    private void bottomAnimationShow() {
        while (this.bottomHide != this.bottomAnimationS) {
            --this.bottomHide;
            this.mainCanvas.repaint();
        }
        this.bottom = true;
    }

    private void bottomAnimationHide() {
        while (this.bottomHide != this.bottomAnimationH) {
            ++this.bottomHide;
            this.mainCanvas.repaint();
        }
    }

    private void fkAnimation(boolean show) {
        if (show) {
            while (this.fkAnimation != this.mainCanvas.getWidth() - Resources.resSprs[16].getWidth()) {
                --this.fkAnimation;
                this.mainCanvas.repaint();
            }
            while (this.fkIconAnimation != this.mainCanvas.getWidth() - Resources.resSprs[0].getWidth()) {
                --this.fkIconAnimation;
                this.mainCanvas.repaint();
            }
        } else {
            while (this.fkIconAnimation != this.mainCanvas.getWidth()) {
                ++this.fkIconAnimation;
                this.mainCanvas.repaint();
            }
            while (this.fkAnimation != this.mainCanvas.getWidth()) {
                ++this.fkAnimation;
                this.mainCanvas.repaint();
            }
        }
    }

    public void updateAnimationTop() {
        int framesCount = 0;
        framesCount = this.ORNAMENTSEQUENCE.length - 1;
        if (this.resourceFrame1 < framesCount) {
            ++this.resourceFrame1;
        } else {
            if (this.repeats1 > 0) {
                --this.repeats1;
            }
            this.resourceFrame1 = 0;
        }
        this.mainCanvas.repaint();
    }

    public void updateAnimationBottom() {
        int framesCount = 0;
        framesCount = this.ORNAMENTSEQUENCE.length - 1;
        if (this.resourceFrame < framesCount) {
            ++this.resourceFrame;
        } else {
            if (this.repeats > 0) {
                --this.repeats;
            }
            this.resourceFrame = 0;
        }
        this.mainCanvas.repaint();
    }

    public void keyPressed(int keyCode) {
    }

    public void keyReleased(int keyCode) {
        this.mainCanvas.repaint();
    }

    public void paint(Graphics g) {
        g.setColor(0);
        this.paintBody(g);
        this.paintTop(g);
        this.paintBottom(g);
        this.paintFK(g);
    }

    private void paintTop(Graphics g) {
        Sprite time = Resources.resSprs[15];
        Sprite bg = Resources.resSprs[16];
        Image light = Resources.resImgs[17];
        Sprite icons = Resources.resSprs[17];
        Image border = Resources.resImgs[15];
        int animFrame = 0;
        animFrame = this.resourceFrame1 < 0 ? 0 : this.SELECTEDSEQUENCE[this.resourceFrame1];
        g.drawImage(light, 0, this.topAnimation, 20);
        bg.setFrame(0);
        bg.setPosition(5, this.topAnimation + time.getHeight() / 8);
        bg.paint(g);
        bg.setFrame(1);
        for (int i = bg.getWidth(); i < MainCanvas.WIDTH - 5 - bg.getWidth(); i += bg.getWidth()) {
            bg.setPosition(i, this.topAnimation + time.getHeight() / 8);
            bg.paint(g);
        }
        Rectangle titleRect = new Rectangle(5 + bg.getWidth() / 4 + time.getWidth(), this.topAnimation + time.getHeight() / 8, MainCanvas.WIDTH, bg.getHeight());
        this.title.drawText(g, titleRect, 0, 6);
        bg.setFrame(2);
        bg.setPosition(MainCanvas.WIDTH - bg.getWidth() - 5, this.topAnimation + time.getHeight() / 8);
        bg.paint(g);
        time.setFrame(animFrame);
        time.setPosition(5 + bg.getWidth() / 4, this.topAnimation);
        g.drawImage(light, 0, time.getHeight() / 8 + bg.getHeight() + this.topAnimation, 20);
        time.paint(g);
        icons.setFrame(2);
        icons.setPosition(5 + bg.getWidth() / 4 + time.getWidth() / 4 + icons.getWidth() / 4, this.topAnimation + 0 + bg.getHeight() / 4);
        icons.paint(g);
        g.drawImage(border, 0, this.bottom ? this.bodyAnimation : this.bottomHide - border.getHeight(), 20);
    }

    private void paintBody(Graphics g) {
        g.setColor(0, 49, 49);
        g.fillRect(this.rectDialog.x, this.bodyAnimation, this.rectDialog.width, this.rectDialog.height);
        g.drawImage(Resources.resImgs[1], this.rectItems[1].x, this.rectItems[1].y, 20);
        g.setColor(0, 0, 0);
        g.fillRect(this.rectDialog.x, this.bottomAnimationS, this.rectDialog.width, this.rectDialog.height);
        preparedText.drawText(g, this.rectText, 0, 17);
        g.setColor(0);
        g.fillRect(this.rectDialog.x, this.rectDialog.y, this.rectDialog.width, this.rectDialog.height - this.bodyAnimation2);
    }

    private void paintBottom(Graphics g) {
        Image border = Resources.resImgs[15];
        g.drawImage(border, 0, this.bottomHide - border.getHeight(), 20);
        g.drawImage(border, 0, this.rectDialog.y - border.getHeight(), 20);
        int animFrame = 0;
        animFrame = this.resourceFrame < 0 ? 0 : this.ORNAMENTSEQUENCE[this.resourceFrame];
        Sprite s = Resources.resSprs[18];
        s.setFrame(animFrame);
        s.setPosition(this.mainCanvas.getWidth() / 2 - s.getWidth() / 2, this.bottomHide);
        s.paint(g);
    }

    private void paintFK(Graphics g) {
        Sprite funKey = Resources.resSprs[16];
        Sprite fk = Resources.resSprs[0];
        funKey.setFrame(0);
        funKey.setPosition(this.fkAnimation, this.mainCanvas.getHeight() - funKey.getHeight());
        funKey.paint(g);
        fk.setFrame(9);
        fk.setPosition(this.fkIconAnimation, this.mainCanvas.getHeight() - funKey.getHeight() + funKey.getHeight() / 2 - fk.getHeight() / 2);
        fk.paint(g);
    }

    public void pointerPressed(int x, int y) {
        for (int i = 0; i < this.rectItems.length; ++i) {
            if (!this.rectItems[i].contains(x, y)) continue;
            this.selectedCompId = i;
            switch (this.selectedCompId) {
                case 0: {
                    Keys.keyPressed(-203);
                    break;
                }
                default: {
                    Keys.keyPressed(53);
                    this.mainCanvas.repaint();
                    break;
                }
            }
            break;
        }
    }

    public void pointerDragged(int x, int y) {
        if (!this.rectItems[this.selectedCompId].contains(x, y)) {
            switch (this.selectedCompId) {
                case 0: {
                    Keys.keyReleased(-203);
                    break;
                }
                default: {
                    Keys.keyReleased(53);
                }
            }
        }
    }

    public void pointerReleased(int x, int y) {
        switch (this.selectedCompId) {
            case 0: {
                if (!Keys.isKeyPressed(-203)) break;
                this.keyReleased(-203);
                Keys.keyReleased(-203);
                break;
            }
            default: {
                if (!Keys.isKeyPressed(53)) break;
                this.keyReleased(53);
                Keys.keyReleased(53);
            }
        }
    }
}

