/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.core;

import baltorogames.core.MathExt;
import baltorogames.core.MatrixF22;

public class VectorF2 {
    public float x;
    public float y;
    public static VectorF2 g_Vec1 = new VectorF2();
    public static VectorF2 g_Vec2 = new VectorF2();
    public static VectorF2 g_Vec3 = new VectorF2();
    public static VectorF2 g_Vec4 = new VectorF2();
    public static VectorF2 g_Vec5 = new VectorF2();

    public float Normalize() {
        float fL = (float)Math.sqrt(this.x * this.x + this.y * this.y);
        if (fL > 0.0f) {
            this.x /= fL;
            this.y /= fL;
        } else {
            this.x = 0.0f;
            this.y = 0.0f;
        }
        return fL;
    }

    public static void VectorFromAngle(float fAngle, VectorF2 dst) {
        VectorF2 vec = new VectorF2();
        vec.x = 0.0f;
        vec.y = 1.0f;
        float fRA = fAngle * 3.1415f / 180.0f;
        MatrixF22 m = new MatrixF22();
        m.MatrixF22_Rot((float)Math.sin(fRA), (float)Math.cos(fRA), fAngle);
        m.MatrixF22_Mul_VectorF2(vec, dst);
    }

    public static float AngleFromVector(VectorF2 src) {
        if (src.x == 0.0f && src.y == 0.0f) {
            return -3000.0f;
        }
        float vec1_X = 0.0f;
        float vec1_Y = 1.0f;
        float fLength = src.x * src.x + src.y * src.y;
        if (fLength <= 1.0E-6f) {
            return -3000.0f;
        }
        fLength = (float)Math.sqrt(fLength);
        float vec2_X = src.x / fLength;
        float vec2_Y = src.y / fLength;
        float fCos = vec1_X * vec2_X + vec1_Y * vec2_Y;
        float fAngle = (float)MathExt.acos(fCos);
        fAngle *= 57.29579f;
        if (src.x < 0.0f) {
            fAngle = 360.0f - fAngle;
        }
        if (fAngle < 0.0f) {
            fAngle += 360.0f;
        }
        return fAngle;
    }
}

