/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIAnimatedButtonH;
import baltorogames.core_gui.UIButton;
import baltorogames.core_gui.UIFloatingTextBox;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gui.LoadingLevelScreen;
import baltorogames.project_gui.MainMenu;
import baltorogames.project_gui.MainScreen;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;
import baltorogames.system.Platform;

public class SelectSurvivalLevel
extends MainScreen {
    public static boolean forceLevelsUnlock = false;
    private final int LEFT_ARROW_ID;
    private final int RIGHT_ARROW_ID;
    public static int selectedPlanet = 0;
    private UIFloatingTextBox infoBox;
    private boolean bAvailable = true;
    private CGTexture backgroundTexture = null;

    public SelectSurvivalLevel(int mode) {
        this.LEFT_ARROW_ID = 100;
        this.RIGHT_ARROW_ID = 101;
        CGEngine.m_nGameMode = mode;
        this.drawTop = false;
        this.drawTitle = false;
        this.windowCaptionText = "";
        this.bAvailable = true;
        this.backgroundTexture = TextureManager.AddTexture("/menu/level_locked.png");
        this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        int x = 9 * ApplicationData.screenWidth / 10 - ObjectsCache.arrowRight.GetWidth() / 2;
        int y = ApplicationData.screenHeight / 4;
        if (y < ObjectsCache.topMenuBar.GetHeight() + this.backgroundTexture.GetHeight() / 2 + 2) {
            y = ObjectsCache.topMenuBar.GetHeight() + this.backgroundTexture.GetHeight() / 2 + 2;
        }
        UIAnimatedButtonH rightB = new UIAnimatedButtonH(x, y -= ObjectsCache.arrowRight.GetHeight() / 2, ObjectsCache.arrowRight, ObjectsCache.arrowRight_a, 101);
        rightB.setScreen(this);
        rightB.setAnimDir(1.0f);
        this.addButton(rightB);
        x = ApplicationData.screenWidth / 10 - ObjectsCache.arrowRight.GetWidth() / 2;
        UIAnimatedButtonH leftB = new UIAnimatedButtonH(x, y, ObjectsCache.arrowLeft, ObjectsCache.arrowLeft_a, 100);
        leftB.setScreen(this);
        leftB.setAnimDir(-1.0f);
        this.addButton(leftB);
        this.updateInfo();
    }

    public void autoSize() {
        this.clientAreaX = Platform.WND_MARGIN_LEFT;
        this.clientAreaWidth = this.width - Platform.WND_MARGIN_LEFT - Platform.WND_MARGIN_RIGHT;
        this.clientAreaY = Platform.WND_MARGIN_TOP;
        this.clientAreaHeight = this.height - Platform.WND_MARGIN_TOP - Platform.WND_MARGIN_BOTTOM;
    }

    private void updateInfo() {
        for (int j = 0; j < 3; ++j) {
            if (CGUserCareer.GetAdventureLevel() >= 15) {
                CGUserCareer.m_bSurvivalLevel[j][1] = true;
            }
            if (CGUserCareer.GetAdventureLevel() < 30) continue;
            CGUserCareer.m_bSurvivalLevel[j][2] = true;
        }
        this.bAvailable = true;
        this.backgroundTexture = this.bAvailable ? TextureManager.AddTexture("/menu/galaxy_" + (selectedPlanet + 1) + ".png") : TextureManager.AddTexture("/menu/galaxy_" + (selectedPlanet + 1) + "_g.png");
        if (this.infoBox == null) {
            this.infoBox = new UIFloatingTextBox(false, 0, ApplicationData.screenHeight / 4 + this.backgroundTexture.GetHeight() / 2, ApplicationData.screenWidth, ApplicationData.defaultFont.getFontHeight() * 6);
        }
        String s1 = "";
        String s2 = "";
        if (CGEngine.IsSurvival()) {
            s1 = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_SCORE_TO_UNLOCK") + ApplicationData.defaultFont.encodeDynamicString(": " + CGUserCareer.survivalLevelReq[1]);
            s2 = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_SCORE_TO_UNLOCK") + ApplicationData.defaultFont.encodeDynamicString(": " + CGUserCareer.survivalLevelReq[2]);
        } else if (CGEngine.IsTimed()) {
            s1 = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_SCORE_TO_UNLOCK") + ApplicationData.defaultFont.encodeDynamicString(": " + CGUserCareer.timedLevelReq[1]);
            s2 = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_SCORE_TO_UNLOCK") + ApplicationData.defaultFont.encodeDynamicString(": " + CGUserCareer.timedLevelReq[2]);
        } else if (CGEngine.IsZen()) {
            s1 = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_SCORE_TO_UNLOCK") + ApplicationData.defaultFont.encodeDynamicString(": " + CGUserCareer.zenLevelReq[1]);
            s2 = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_SCORE_TO_UNLOCK") + ApplicationData.defaultFont.encodeDynamicString(": " + CGUserCareer.zenLevelReq[2]);
        }
        if (selectedPlanet == 1) {
            this.infoBox.setText(s1);
        } else if (selectedPlanet == 2) {
            this.infoBox.setText(s2);
        }
        this.findByID(UIScreen.ID_BUTTON_OK).setVisible(this.bAvailable);
    }

    public void onUpdate(float deltaTime) {
        super.onUpdate(deltaTime);
    }

    public void draw() {
        int y = ApplicationData.screenHeight / 4 - this.backgroundTexture.GetHeight() / 2;
        if (y < ObjectsCache.topMenuBar.GetHeight() + 2) {
            y = ObjectsCache.topMenuBar.GetHeight() + 2;
        }
        Graphic2D.DrawImage(this.backgroundTexture, ApplicationData.screenWidth / 2, y, 17);
        String mode_header = "";
        switch (CGEngine.m_nGameMode) {
            case 2: {
                mode_header = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_SURVIVAL");
                break;
            }
            case 3: {
                mode_header = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_TIMED");
                break;
            }
            case 4: {
                mode_header = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_ZEN");
            }
        }
        Utils.drawString(mode_header + ApplicationData.defaultFont.encodeDynamicString(" " + (selectedPlanet + 1)), ApplicationData.screenWidth / 2, y, 33, 0);
        if (this.bAvailable) {
            if (CGEngine.m_nGameMode == 2) {
                Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_BEST_SCORE_SURVIVE") + ApplicationData.defaultFont.encodeDynamicString("" + CGUserCareer.m_arrBestForSurvival[0][0]), ApplicationData.screenWidth / 2, y + this.backgroundTexture.GetHeight() + ApplicationData.defaultFont.getFontHeight() * 2, 17, 0);
                Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_LONGEST_TIME_SURVIVE") + ApplicationData.defaultFont.encodeDynamicString("" + CGUserCareer.m_arrBestForSurvival[0][1] / 1000), ApplicationData.screenWidth / 2, y + this.backgroundTexture.GetHeight() + ApplicationData.defaultFont.getFontHeight() * 4, 17, 0);
            } else if (CGEngine.m_nGameMode == 3) {
                Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_BEST_SCORE_SURVIVE") + ApplicationData.defaultFont.encodeDynamicString("" + CGUserCareer.m_arrBestForTimed[0][0]), ApplicationData.screenWidth / 2, y + this.backgroundTexture.GetHeight() + ApplicationData.defaultFont.getFontHeight() * 2, 17, 0);
            } else if (CGEngine.m_nGameMode == 4) {
                Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_BEST_SCORE_SURVIVE") + ApplicationData.defaultFont.encodeDynamicString("" + CGUserCareer.m_arrBestForZen[0][0]), ApplicationData.screenWidth / 2, y + this.backgroundTexture.GetHeight() + ApplicationData.defaultFont.getFontHeight() * 2, 17, 0);
                Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_LONGEST_TIME_SURVIVE") + ApplicationData.defaultFont.encodeDynamicString("" + CGUserCareer.m_arrBestForZen[0][1] / 1000), ApplicationData.screenWidth / 2, y + this.backgroundTexture.GetHeight() + ApplicationData.defaultFont.getFontHeight() * 4, 17, 0);
            }
        } else {
            this.infoBox.draw();
        }
    }

    public boolean rightSoftButton() {
        TextureManager.DeleteTexture(this.backgroundTexture);
        UIScreen.SetCurrentScreen(new MainMenu());
        return true;
    }

    public boolean leftSoftButton() {
        if (this.bAvailable) {
            CGEngine.m_nSurvivalLevel = selectedPlanet;
            TextureManager.DeleteTexture(this.backgroundTexture);
            UIScreen.SetCurrentScreen(new LoadingLevelScreen());
        }
        return true;
    }

    public boolean onRightAction() {
        if (++selectedPlanet >= 3) {
            selectedPlanet = 0;
        }
        this.updateInfo();
        return true;
    }

    public boolean onLeftAction() {
        if (--selectedPlanet < 0) {
            selectedPlanet = 2;
        }
        this.updateInfo();
        return true;
    }

    public boolean onFireAction() {
        return this.leftSoftButton();
    }

    public boolean selectLeftAction() {
        UIButton b = this.findByID(100);
        if (b != null) {
            b.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean selectRightAction() {
        UIButton b = this.findByID(101);
        if (b != null) {
            b.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean actionSoftButton(int nID, boolean pressed) {
        if (super.actionSoftButton(nID, pressed)) {
            return true;
        }
        if (!pressed) {
            this.unselectAllButtons();
            if (nID == 100) {
                this.onLeftAction();
                return true;
            }
            if (nID == 101) {
                this.onRightAction();
                return true;
            }
        }
        return false;
    }
}

