/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.RandSync;
import baltorogames.core.VectorF2;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGEngineRenderer;
import baltorogames.project_gameplay.CGFallingBall;
import baltorogames.project_gameplay.CGHit;
import baltorogames.project_gameplay.CGLevelStats;
import baltorogames.project_gameplay.IBoardListener;
import baltorogames.project_gameplay.LevelScenario;
import baltorogames.project_gameplay.LevelScenarioSurvivalManager;
import baltorogames.system.Platform;

public class CGBoard {
    private static int zenNewRowInterval = 0;
    private static int ZEN_NEW_ROW_GENERATION_INTERVAL = 30000;
    public static int eNumInitialRows = 4;
    public static int TIME_TO_CHECK = 50;
    public static float eBallRadius = 27.0f;
    public static float eBallDiameter = eBallRadius * 2.0f;
    public static float eBallRadiusV = eBallDiameter * 1.732f / 2.0f;
    public static float eBoardMargin = (480.0f - 10.0f * eBallDiameter - eBallRadius) / 2.0f;
    public static float eBoardMarginUp = 0.0f;
    public static int cuttOffLineOffsetY = 0;
    public static final int[] m_arrNeighboursGridXEven = new int[]{-1, 0, 1, 0, -1, -1};
    public static final int[] m_arrNeighboursGridXOdd = new int[]{0, 1, 1, 1, 0, -1};
    public static final int[] m_arrNeighboursGridY = new int[]{-1, -1, 0, 1, 1, 0};
    public char[][] m_arrGrid;
    public int[][] m_arrTmpGrid;
    public int m_OneColorCounter = 0;
    public int m_nGridSizeX;
    public int m_nGridSizeY;
    public int m_nTimeToCheck = -1;
    public int m_nGridXToCheck = -1;
    public int m_nGridYToCheck = -1;
    public float m_fOffset = 0.0f;
    public int m_nChangeOffsetCounter = 2;
    public static final int m_nMaxColors = 6;
    public static final int e_bombColorIndex = 7;
    public static final int e_timeColorIndex = 8;
    public static final int e_colorColorIndex = 9;
    public static final int e_fireColorIndex = 10;
    public static final int e_wallColorIndex = 11;
    public static final int e_itemColorIndex = 12;
    IBoardListener boardEventListener;
    LevelScenario m_LevelScenario = null;

    public static void Init() {
    }

    public CGBoard(int nGridX, int nGridY, IBoardListener listener, LevelScenario ls) {
        this.m_LevelScenario = ls;
        this.boardEventListener = listener;
        this.m_nGridSizeX = nGridX;
        this.m_nGridSizeY = nGridY;
        zenNewRowInterval = 0;
        eBoardMarginUp = Platform.eBoardMarginUp;
        this.m_arrGrid = new char[this.m_nGridSizeX][this.m_nGridSizeY];
        this.m_arrTmpGrid = new int[this.m_nGridSizeX][this.m_nGridSizeY];
        VectorF2 vOut = new VectorF2();
        this.GetRealPosition(0, 10, vOut);
        cuttOffLineOffsetY = (int)vOut.y;
        for (int y = 0; y < eNumInitialRows; ++y) {
            this.GenerateNewRow();
        }
        this.boardEventListener.Event_NewBoardGenerated(this);
    }

    private void GenerateNewRow() {
        if (CGEngine.m_nSurvivalLevel < 0) {
            if (this.m_LevelScenario == null || this.m_LevelScenario.m_nOffset < 0) {
                System.out.println("GenerateNewRow: Scenario m_nOffset < 0");
                return;
            }
            for (int y = this.m_nGridSizeY - 2; y >= 0; --y) {
                for (int x = 0; x < this.m_nGridSizeX; ++x) {
                    this.m_arrGrid[x][y + 1] = this.m_arrGrid[x][y];
                }
            }
            for (int x = 0; x < this.m_nGridSizeX; ++x) {
                char c;
                this.m_arrGrid[x][0] = c = this.m_LevelScenario.m_Data[x][this.m_LevelScenario.m_nOffset];
            }
            --this.m_LevelScenario.m_nOffset;
            System.out.println("GenerateNewRow: Scenario m_nOffset = " + this.m_LevelScenario.m_nOffset);
            this.boardEventListener.Event_NewLineOfBallsGenerated(this);
        } else {
            if (this.m_LevelScenario == null || this.m_LevelScenario.m_nOffset < 0) {
                LevelScenario ls = (LevelScenario)CGEngine.m_LevelScenarioSurvivalManager.m_Vector.elementAt(RandSync.nextInt() % LevelScenarioSurvivalManager.eSize);
                ls.m_nOffset = ls.m_nRowSize - 1;
                this.m_LevelScenario = ls;
            }
            for (int y = this.m_nGridSizeY - 2; y >= 0; --y) {
                for (int x = 0; x < this.m_nGridSizeX; ++x) {
                    this.m_arrGrid[x][y + 1] = this.m_arrGrid[x][y];
                }
            }
            for (int x = 0; x < this.m_nGridSizeX; ++x) {
                char c;
                this.m_arrGrid[x][0] = c = this.m_LevelScenario.m_Data[x][this.m_LevelScenario.m_nOffset];
            }
            --this.m_LevelScenario.m_nOffset;
            System.out.println("GenerateNewRow: Scenario m_nOffset = " + this.m_LevelScenario.m_nOffset);
            this.boardEventListener.Event_NewLineOfBallsGenerated(this);
        }
    }

    public void GetRealPosition(int nGridX, int nGridY, VectorF2 vOut) {
        if (nGridY % 2 == 0) {
            vOut.x = eBoardMargin + (float)nGridX * eBallDiameter + eBallRadius;
            vOut.y = eBoardMarginUp + this.m_fOffset + eBallRadius + (float)nGridY * eBallRadiusV;
        } else {
            vOut.x = eBoardMargin + (float)nGridX * eBallDiameter + eBallRadius + eBallRadius;
            vOut.y = eBoardMarginUp + this.m_fOffset + eBallRadius + (float)nGridY * eBallRadiusV;
        }
    }

    public int getNumRows() {
        int y;
        for (y = 0; y < this.m_nGridSizeY; ++y) {
            int nC = 0;
            for (int x = 0; x < this.m_nGridSizeX; ++x) {
                nC += this.m_arrGrid[x][y];
            }
            if (nC == 0) break;
        }
        return y;
    }

    public char GetColor(int nGridX, int nGridY) {
        return this.m_arrGrid[nGridX][nGridY];
    }

    public void SetColor(int nGridX, int nGridY, char color) {
        this.m_arrGrid[nGridX][nGridY] = color;
    }

    public int GetNeighbourGridXFor(int nGridX, int nGridY, int nNeighbourIndex) {
        if (nGridY % 2 == 0) {
            return nGridX + m_arrNeighboursGridXEven[nNeighbourIndex];
        }
        return nGridX + m_arrNeighboursGridXOdd[nNeighbourIndex];
    }

    public int GetNeighbourGridYFor(int nGridX, int nGridY, int nNeighbourIndex) {
        return nGridY + m_arrNeighboursGridY[nNeighbourIndex];
    }

    public void PutNewBallInRealPos(char color, float xx, float yy, int nGridX, int nGridY) {
        int nCurrentindex = -1;
        float fMinDist = 100000.0f;
        for (int i = 0; i < 6; ++i) {
            int x = this.GetNeighbourGridXFor(nGridX, nGridY, i);
            int y = this.GetNeighbourGridYFor(nGridX, nGridY, i);
            if (x < 0 || y < 0 || x >= this.m_nGridSizeX || y >= this.m_nGridSizeY || this.m_arrGrid[x][y] != '\u0000') continue;
            this.GetRealPosition(x, y, VectorF2.g_Vec1);
            float fD = (VectorF2.g_Vec1.x - xx) * (VectorF2.g_Vec1.x - xx) + (VectorF2.g_Vec1.y - yy) * (VectorF2.g_Vec1.y - yy);
            if (!(fD < fMinDist)) continue;
            fMinDist = fD;
            nCurrentindex = i;
        }
        if (nCurrentindex >= 0) {
            int x = this.GetNeighbourGridXFor(nGridX, nGridY, nCurrentindex);
            int y = this.GetNeighbourGridYFor(nGridX, nGridY, nCurrentindex);
            this.SetColor(x, y, color);
            if (this.GetColor(nGridX, nGridY) != '\t' && this.GetColor(nGridX, nGridY) != '\u0007' && this.GetColor(nGridX, nGridY) != '\b') {
                this.m_nTimeToCheck = TIME_TO_CHECK;
            }
            this.m_nGridXToCheck = x;
            this.m_nGridYToCheck = y;
            this.boardEventListener.Event_NewBallOnBoard(this, x, y, color);
        }
        this.boardEventListener.Event_HitBall(this, nGridX, nGridY, this.GetColor(nGridX, nGridY));
        this.CheckSeparates();
    }

    public void PutNewBallInFirstRow(char nColor, float fBallX, float fBallY) {
        int nCurrentindex = -1;
        float fMinDist = 100000.0f;
        for (int x = 0; x < this.m_nGridSizeX; ++x) {
            this.GetRealPosition(x, 0, VectorF2.g_Vec1);
            float fD = (VectorF2.g_Vec1.x - fBallX) * (VectorF2.g_Vec1.x - fBallX) + (VectorF2.g_Vec1.y - fBallY) * (VectorF2.g_Vec1.y - fBallY);
            if (!(fD < fMinDist) || this.m_arrGrid[x][0] != '\u0000') continue;
            fMinDist = fD;
            nCurrentindex = x;
        }
        if (nCurrentindex >= 0) {
            this.SetColor(nCurrentindex, 0, nColor);
            this.m_nTimeToCheck = TIME_TO_CHECK;
            this.m_nGridXToCheck = nCurrentindex;
            this.m_nGridYToCheck = 0;
            this.boardEventListener.Event_NewBallOnBoard(this, nCurrentindex, 0, nColor);
        }
        this.CheckSeparates();
    }

    private void CheckNeighbourInMyColorRecursive(int nGridX, int nGridY) {
        this.m_arrTmpGrid[nGridX][nGridY] = 1;
        ++this.m_OneColorCounter;
        char c = this.m_arrGrid[nGridX][nGridY];
        for (int i = 0; i < 6; ++i) {
            char cc;
            int xx = this.GetNeighbourGridXFor(nGridX, nGridY, i);
            int yy = this.GetNeighbourGridYFor(nGridX, nGridY, i);
            if (xx < 0 || yy < 0 || xx >= this.m_nGridSizeX || yy >= this.m_nGridSizeY || this.m_arrTmpGrid[xx][yy] != 0 || (cc = this.m_arrGrid[xx][yy]) != c) continue;
            this.CheckNeighbourInMyColorRecursive(xx, yy);
        }
    }

    private void ClearTmpGridTable() {
        for (int x = 0; x < this.m_nGridSizeX; ++x) {
            for (int y = 0; y < this.m_nGridSizeY; ++y) {
                this.m_arrTmpGrid[x][y] = 0;
            }
        }
    }

    private void CheckNeighbourInMyColor(int nGridX, int nGridY) {
        this.ClearTmpGridTable();
        this.m_OneColorCounter = 0;
        this.CheckNeighbourInMyColorRecursive(nGridX, nGridY);
        if (this.m_OneColorCounter >= 3) {
            for (int x = 0; x < this.m_nGridSizeX; ++x) {
                for (int y = 0; y < this.m_nGridSizeY; ++y) {
                    if (this.m_arrTmpGrid[x][y] != 1) continue;
                    this.boardEventListener.Event_BallDestroyed(this, x, y, this.m_arrGrid[x][y], true);
                    this.m_arrGrid[x][y] = '\u0000';
                }
            }
            this.boardEventListener.Event_CleaningDestroyedBallsFinished(this, this.m_OneColorCounter);
            if (CGLevelStats.m_nActualCombo > 1) {
                this.GetRealPosition(nGridX, nGridY + 2, VectorF2.g_Vec1);
                CGHit.NewHit(4 + (CGLevelStats.m_nActualCombo - 2) % 4, VectorF2.g_Vec1.x, VectorF2.g_Vec1.y, 600L);
            }
        } else {
            this.boardEventListener.Event_ShootWithoutMatch3Hit(this);
        }
    }

    private void SetColorRecursive(int nGridX, int nGridY) {
        if (this.m_arrGrid[nGridX][nGridY] > '\u0000' && this.m_arrTmpGrid[nGridX][nGridY] == 0) {
            this.m_arrTmpGrid[nGridX][nGridY] = 1;
            for (int i = 0; i < 6; ++i) {
                int xx = this.GetNeighbourGridXFor(nGridX, nGridY, i);
                int yy = this.GetNeighbourGridYFor(nGridX, nGridY, i);
                if (xx < 0 || yy < 0 || xx >= this.m_nGridSizeX || yy >= this.m_nGridSizeY || this.m_arrGrid[xx][yy] <= '\u0000' || this.m_arrTmpGrid[xx][yy] != 0) continue;
                this.SetColorRecursive(xx, yy);
            }
        }
    }

    public void ClearAllIfOneColor() {
        int y;
        int x;
        if (this.m_LevelScenario.m_nOffset >= 0) {
            return;
        }
        int n = -1;
        for (x = 0; x < this.m_nGridSizeX; ++x) {
            for (y = 0; y < this.m_nGridSizeY; ++y) {
                char c;
                if (this.m_arrGrid[x][y] <= '\u0000' || this.m_arrGrid[x][y] == '\u000b') continue;
                if (c < '\u0000') {
                    c = this.m_arrGrid[x][y];
                    continue;
                }
                if (this.m_arrGrid[x][y] == c) continue;
                return;
            }
        }
        for (x = 0; x < this.m_nGridSizeX; ++x) {
            for (y = 0; y < this.m_nGridSizeY; ++y) {
                if (this.m_arrGrid[x][y] <= '\u0000') continue;
                this.boardEventListener.Event_BallDestroyed(this, x, y, this.m_arrGrid[x][y], true);
                this.m_arrGrid[x][y] = '\u0000';
            }
        }
    }

    private void CheckSeparates() {
        this.ClearTmpGridTable();
        this.m_OneColorCounter = 0;
        for (int x = 0; x < this.m_nGridSizeX; ++x) {
            this.SetColorRecursive(x, 0);
        }
        int nCounter = 0;
        for (int x = 0; x < this.m_nGridSizeX; ++x) {
            for (int y = 0; y < this.m_nGridSizeY; ++y) {
                if (this.m_arrGrid[x][y] <= '\u0000' || this.m_arrTmpGrid[x][y] != 0) continue;
                ++nCounter;
                this.GetRealPosition(x, y, VectorF2.g_Vec1);
                CGFallingBall.NewBall(VectorF2.g_Vec1.x, VectorF2.g_Vec1.y, this.m_arrGrid[x][y]);
                this.boardEventListener.Event_BallSeparated(this, x, y, this.m_arrGrid[x][y]);
                this.m_arrGrid[x][y] = '\u0000';
            }
        }
        if (nCounter > 0) {
            this.boardEventListener.Event_CleaningSeparatedBallsFinished(this, nCounter);
        }
    }

    public void Update(int nDeltatTimeinMs) {
        int nC;
        if (this.m_nTimeToCheck > 0) {
            this.m_nTimeToCheck -= nDeltatTimeinMs;
            if (this.m_nTimeToCheck <= 0) {
                this.CheckNeighbourInMyColor(this.m_nGridXToCheck, this.m_nGridYToCheck);
                this.CheckSeparates();
                this.m_nTimeToCheck = -1;
                this.m_nGridXToCheck = -1;
                this.m_nGridYToCheck = -1;
                if (CGEngine.m_nGameMode == 1) {
                    this.ClearAllIfOneColor();
                }
            }
        }
        if (CGEngine.m_nSurvivalLevel < 0) {
            int nC2;
            if (this.m_fOffset == 0.0f && (nC2 = this.BallsSize()) < 20 && this.getNumRows() < 6) {
                this.m_fOffset = 0.01f;
                this.m_nChangeOffsetCounter = 2;
            }
        } else if (this.m_fOffset == 0.0f && (nC = this.BallsSize()) < 20 && this.getNumRows() < 6) {
            this.m_fOffset = 0.01f;
            this.m_nChangeOffsetCounter = 2;
        }
        if (CGEngine.m_nSurvivalLevel < 0) {
            if (this.m_fOffset > 0.0f && this.m_LevelScenario != null && this.m_LevelScenario.m_nOffset > 0) {
                this.m_fOffset += 1000.0f * (float)nDeltatTimeinMs / 1000.0f;
                if (this.m_fOffset >= 2.0f * eBallRadiusV) {
                    this.GenerateNewRow();
                    this.GenerateNewRow();
                    this.m_fOffset = 0.0f;
                    --this.m_nChangeOffsetCounter;
                    if (this.m_nChangeOffsetCounter > 0) {
                        this.m_fOffset = 0.01f;
                    }
                }
            }
        } else if (CGEngine.IsZen()) {
            if (this.m_fOffset > 0.0f || (zenNewRowInterval += nDeltatTimeinMs) >= ZEN_NEW_ROW_GENERATION_INTERVAL) {
                this.m_fOffset += 1000.0f * (float)nDeltatTimeinMs / 1000.0f;
                if (this.m_fOffset >= 2.0f * eBallRadiusV || zenNewRowInterval >= ZEN_NEW_ROW_GENERATION_INTERVAL) {
                    zenNewRowInterval = 0;
                    this.GenerateNewRow();
                    this.GenerateNewRow();
                    this.m_fOffset = 0.0f;
                    --this.m_nChangeOffsetCounter;
                    if (this.m_nChangeOffsetCounter > 0) {
                        this.m_fOffset = 0.01f;
                    }
                }
            }
        } else if (this.m_fOffset > 0.0f) {
            this.m_fOffset += 1000.0f * (float)nDeltatTimeinMs / 1000.0f;
            if (this.m_fOffset >= 2.0f * eBallRadiusV) {
                zenNewRowInterval = 0;
                this.GenerateNewRow();
                this.GenerateNewRow();
                this.m_fOffset = 0.0f;
                --this.m_nChangeOffsetCounter;
                if (this.m_nChangeOffsetCounter > 0) {
                    this.m_fOffset = 0.01f;
                }
            }
        }
    }

    public int BallsSize() {
        int nC = 0;
        for (int x = 0; x < this.m_nGridSizeX; ++x) {
            for (int y = 0; y < this.m_nGridSizeY; ++y) {
                if (this.m_arrGrid[x][y] <= '\u0000' || this.m_arrGrid[x][y] == '\u000b') continue;
                ++nC;
            }
        }
        return nC;
    }

    public boolean checkColorExists(int color) {
        switch (color) {
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return false;
            }
        }
        boolean anyColor = false;
        int nColors = 0;
        for (int x = 0; x < this.m_nGridSizeX; ++x) {
            for (int y = 0; y < this.m_nGridSizeY; ++y) {
                if (this.m_arrGrid[x][y] == color) {
                    return true;
                }
                if (this.m_arrGrid[x][y] == '\u0007' || this.m_arrGrid[x][y] == '\t' || this.m_arrGrid[x][y] == '\n' || this.m_arrGrid[x][y] == '\b') {
                    anyColor = true;
                    continue;
                }
                if (this.m_arrGrid[x][y] <= '\u0000' || this.m_arrGrid[x][y] > '\u0006') continue;
                ++nColors;
            }
        }
        return anyColor && nColors == 0;
    }

    private void RenderBall(int nGridX, int nGridY) {
        if (this.m_arrGrid[nGridX][nGridY] > '\u0000') {
            this.GetRealPosition(nGridX, nGridY, VectorF2.g_Vec1);
            CGEngineRenderer.RenderBall(this.m_arrGrid[nGridX][nGridY], VectorF2.g_Vec1.x, VectorF2.g_Vec1.y);
        }
    }

    public void Render() {
        for (int x = 0; x < this.m_nGridSizeX; ++x) {
            for (int y = 0; y < this.m_nGridSizeY; ++y) {
                this.RenderBall(x, y);
            }
        }
        int y = (int)CGEngineRenderer.m_fScreenOffsetY + (int)((float)cuttOffLineOffsetY * CGEngine.m_fEngineScale);
        CGEngine.m_DeadLine.Draw(y);
    }

    public void AddScenario(LevelScenario ls) {
        this.m_LevelScenario = ls;
    }

    public int checkGameIsOver() {
        return this.boardEventListener.checkGameIsOver(this);
    }
}

