/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.project_gameplay.CGAchievements;
import baltorogames.project_gameplay.CGSoundSystem;
import baltorogames.project_gameplay.CGUserCareer;

public class DebugConsole {
    private static final int KEY_0_INT_CODE = 48;
    private static int debugCode;
    private static int debugDigit;
    public static boolean debug_switch_FPS;
    public static boolean debug_switch_MEM;

    public static void trackDebugCommand(int keyCode) {
        switch (keyCode) {
            case 42: {
                DebugConsole.clear();
                break;
            }
            case 35: {
                DebugConsole.executeDebugCommand();
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                int digit = keyCode - 48;
                if (debugDigit == 3) {
                    debugCode = 0;
                    debugDigit = 0;
                }
                if (debugDigit == 0) {
                    debugCode += digit * 100;
                }
                if (debugDigit == 1) {
                    debugCode += digit * 10;
                }
                if (debugDigit == 2) {
                    debugCode += digit;
                }
                ++debugDigit;
            }
        }
    }

    private static void clear() {
        debugCode = 0;
        debugDigit = 0;
    }

    private static void executeDebugCommand() {
        int nValue = debugCode;
        if (nValue == 100) {
            CGUserCareer.UnlockAllLevels();
            CGSoundSystem.ForceVibrate(500);
        } else if (nValue == 101) {
            CGUserCareer.UnlockAllSurvivals();
            CGSoundSystem.ForceVibrate(500);
        } else if (nValue >= 200 && nValue <= 225) {
            CGAchievements.completeAchievement(nValue - 200);
            CGSoundSystem.ForceVibrate(500);
        } else if (nValue == 998) {
            debug_switch_MEM = !debug_switch_MEM;
            CGSoundSystem.ForceVibrate(500);
        } else if (nValue == 999) {
            debug_switch_FPS = !debug_switch_FPS;
            CGSoundSystem.ForceVibrate(500);
        } else if (nValue == 500) {
            CGUserCareer.UnlockAllPowerups();
        } else {
            CGSoundSystem.ForceVibrate(100);
        }
    }

    public static void draw() {
        if (debug_switch_FPS) {
            Graphic2D.SetColor(0xFF7070);
            Utils.drawString(ApplicationData.defaultFont.encodeDynamicString("FPS: " + ApplicationData.m_nStats_FPS), 0, ApplicationData.screenHeight, 36, 0);
        }
        if (debug_switch_MEM) {
            long freeMem = Runtime.getRuntime().freeMemory() / 1024L;
            long totalMem = Runtime.getRuntime().totalMemory() / 1024L;
            float memFree = 1.0f - (float)freeMem / (float)totalMem;
            int redLineLength = (int)(memFree * (float)ApplicationData.screenWidth);
            Graphic2D.SetColor(0x40F040);
            Graphic2D.FillRect(0, 0, ApplicationData.screenWidth, 8);
            Graphic2D.SetColor(0xFF4040);
            Graphic2D.FillRect(0, 0, redLineLength, 8);
        }
    }

    static {
        debugDigit = 0;
        debug_switch_FPS = false;
        debug_switch_MEM = false;
    }
}

