/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.system;

import baltorogames.core.ApplicationData;
import baltorogames.core.LanguagePack;
import baltorogames.core_gui.UIScreen;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGSoundSystem;
import baltorogames.project_gui.AboutTB;
import baltorogames.project_gui.HintScreen;
import baltorogames.project_gui.InGameMainMenu;
import baltorogames.project_gui.MainListAnimated;
import baltorogames.project_gui.MainMenu;
import baltorogames.project_gui.MainTextBox;
import baltorogames.project_gui.ResetAppDataTB;
import baltorogames.system.BGStore;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Platform;
import baltorogames.system.SoundEngine;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Options
extends MainListAnimated {
    public static int OPTION_MUSIC = 0;
    public static int OPTION_HELP = 1;
    public static int OPTION_CREDITS = 2;
    public static int OPTION_RESETAPP = 3;
    public static boolean GfxOnOff = false;
    public static int languageID = 0;
    public static String netResultsURL = new String();
    private static String[] languageNames = new String[]{"TID_ENGLISH", "TID_GERMAN", "TID_SPANISH", "TID_ITALIAN", "TID_FRENCH", "TID_PORTUGUESE"};

    public Options() {
        this.drawTop = true;
        this.drawTitle = true;
        this.setCaption(ApplicationData.lp.getTranslatedString(languageID, "TID_OPTIONS"));
        this.refreshList();
        this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
    }

    public static void reset() {
        int currlanguage = languageID;
        Options.readDefaults();
        if (currlanguage != languageID) {
            ApplicationData.lp = LanguagePack.create("/gameTexts.EEE", languageID);
        }
    }

    public static void readDefaults() {
    }

    public static boolean readConfigurationFromStore() {
        BGStore store = BGStore.openStoreToRead("Configuration");
        try {
            DataInputStream inputStream = store.getInStream();
            if (inputStream != null && inputStream.available() > 0) {
                boolean bS = inputStream.readBoolean();
                SoundEngine.soundVolume = inputStream.readInt();
                netResultsURL = inputStream.readUTF();
                HintScreen.deSerialize(inputStream);
                ApplicationData.demoTimeLeft = inputStream.readInt();
                ApplicationData.demoLevelsLeft = inputStream.readInt();
            }
            store.close();
        }
        catch (Exception e) {
            Options.readDefaults();
            return false;
        }
        return true;
    }

    public static void writeConfigurationToStore() {
        BGStore store = BGStore.openStoreToWrite("Configuration");
        try {
            DataOutputStream outputStream = store.getOutStream();
            outputStream.writeBoolean(GfxOnOff);
            outputStream.writeInt(SoundEngine.soundVolume);
            outputStream.writeUTF(netResultsURL);
            HintScreen.serialize(outputStream);
            outputStream.writeInt(ApplicationData.demoTimeLeft);
            outputStream.writeInt(ApplicationData.demoLevelsLeft);
            store.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void refreshList() {
        this.clearList();
        if (languageID != LanguagePack.currentLanguageID) {
            ApplicationData.lp = LanguagePack.create("/gameTexts.EEE", languageID);
            this.setCaption(ApplicationData.lp.getTranslatedString(languageID, "TID_SETTINGS"));
            this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        }
        if (ApplicationData.soundEngine.isSoundEnabled()) {
            if (SoundEngine.soundVolume == SoundEngine.SOUND_VOLUME_LOW) {
                this.append(ApplicationData.lp.getTranslatedString(languageID, "TID_OPTIONS_SOUND_ON"));
            } else if (SoundEngine.soundVolume == SoundEngine.SOUND_VOLUME_MEDIUM) {
                this.append(ApplicationData.lp.getTranslatedString(languageID, "TID_OPTIONS_SOUND_ON"));
            } else if (SoundEngine.soundVolume == SoundEngine.SOUND_VOLUME_HIGH) {
                this.append(ApplicationData.lp.getTranslatedString(languageID, "TID_OPTIONS_SOUND_ON"));
            }
        } else {
            this.append(ApplicationData.lp.getTranslatedString(languageID, "TID_OPTIONS_SOUND_OFF"));
        }
        this.append(ApplicationData.lp.getTranslatedString(languageID, "TID_HELP"));
        this.append(ApplicationData.lp.getTranslatedString(languageID, "TID_CREDITS"));
        if (ApplicationData.generalGameMode != 4) {
            this.append(ApplicationData.lp.getTranslatedString(languageID, "TID_OPTIONS_RESETAPP_DATA"));
        }
    }

    public void currentItemSelected(int currentItemId) {
        if (currentItemId == OPTION_MUSIC) {
            boolean currentState = ApplicationData.soundEngine.isSoundEnabled();
            ApplicationData.soundEngine.onGameEvent(19, null);
            if (ApplicationData.soundEngine.isSoundEnabled()) {
                GfxOnOff = true;
                if (!currentState) {
                    if (ApplicationData.isMainMenuMode()) {
                        CGSoundSystem.PlayMusic("/mainmenu.mid");
                    } else {
                        switch (CGEngine.m_nCurrentGalaxy) {
                            case 1: {
                                CGSoundSystem.PlayMusic("/galaxy_1.mid");
                                break;
                            }
                            case 2: {
                                CGSoundSystem.PlayMusic("/galaxy_2.mid");
                                break;
                            }
                            case 3: {
                                CGSoundSystem.PlayMusic("/galaxy_3.mid");
                            }
                        }
                    }
                }
            } else {
                GfxOnOff = false;
            }
        } else {
            if (currentItemId == OPTION_RESETAPP) {
                UIScreen.SetCurrentScreen(new ResetAppDataTB());
                return;
            }
            if (currentItemId == OPTION_CREDITS) {
                UIScreen.SetCurrentScreen(new AboutTB(true, 0, false, this));
            } else if (currentItemId == OPTION_HELP) {
                MainTextBox help = new MainTextBox(Platform.DEFAULT_TEXTBOX_X, Platform.DEFAULT_TEXTBOX_Y, ApplicationData.screenWidth - 2 * Platform.DEFAULT_TEXTBOX_X, Platform.DEFAULT_TEXTBOX_H, true, this);
                help.setCaption(ApplicationData.lp.getTranslatedString(languageID, "TID_HELP"));
                String helpText = "";
                helpText = ApplicationData.isTouchScreen ? helpText + ApplicationData.lp.getTranslatedString(languageID, "TID_HELP_CONTROLS_TS") : helpText + ApplicationData.lp.getTranslatedString(languageID, "TID_HELP_CONTROLS");
                helpText = helpText + ApplicationData.lp.getTranslatedString(languageID, "TID_HELP_TEXT");
                help.setSoftButtonImage(null, null, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
                help.autoSize();
                help.setText(helpText, "\r\n");
                UIScreen.SetCurrentScreen(help);
            }
        }
        if (languageID < 0) {
            languageID = ApplicationData.lp.getNumLanguages() - 1;
        }
        if (languageID >= ApplicationData.lp.getNumLanguages()) {
            languageID = 0;
        }
        this.refreshList();
    }

    public boolean rightSoftButton() {
        if (ApplicationData.generalGameMode != 3) {
            UIScreen.SetCurrentScreen(new InGameMainMenu());
        } else {
            UIScreen.SetCurrentScreen(new MainMenu());
        }
        return true;
    }

    public boolean leftSoftButton() {
        this.currentItemSelected(this.currentItem);
        return true;
    }

    public boolean actionSoftButton(int nID, boolean pressed) {
        if (pressed) {
            return super.actionSoftButton(nID, pressed);
        }
        this.currentItemSelected(nID - 1000);
        return true;
    }
}

