/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIFloatingTextBox;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gui.LevelWinScreen;
import baltorogames.project_gui.MainScreen;
import baltorogames.project_gui.SelectPlanet;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;
import baltorogames.system.Platform;

public class ShowGalaxyUnlock
extends MainScreen {
    private UIFloatingTextBox infoBox;
    private String[] worldNames = new String[]{"TID_GALAXY_NAME_0", "TID_GALAXY_NAME_1", "TID_GALAXY_NAME_2"};
    private CGTexture worldTexture = null;
    private int unlockedGalaxy;

    public ShowGalaxyUnlock(int galaxyToUnlock) {
        this.unlockedGalaxy = galaxyToUnlock;
        LevelWinScreen.showUnlockScreen = 0;
        this.drawTop = true;
        this.drawTitle = true;
        this.windowCaptionText = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_ADVENTURE");
        this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, null, null);
        this.updateInfo();
    }

    public void autoSize() {
        this.clientAreaX = Platform.WND_MARGIN_LEFT;
        this.clientAreaWidth = this.width - Platform.WND_MARGIN_LEFT - Platform.WND_MARGIN_RIGHT;
        this.clientAreaY = Platform.WND_MARGIN_TOP;
        this.clientAreaHeight = this.height - Platform.WND_MARGIN_TOP - Platform.WND_MARGIN_BOTTOM;
    }

    private void updateInfo() {
        this.worldTexture = TextureManager.AddTexture("/menu/galaxy_" + (this.unlockedGalaxy + 1) + ".png");
        if (this.infoBox == null) {
            this.infoBox = new UIFloatingTextBox(false, 0, ApplicationData.screenHeight / 2 + this.worldTexture.GetHeight() / 2, ApplicationData.screenWidth, ApplicationData.screenHeight / 4);
        }
        this.infoBox.setText(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_UNLOCK_WORLD_" + this.unlockedGalaxy));
    }

    public void onUpdate(float deltaTime) {
        super.onUpdate(deltaTime);
    }

    public void draw() {
        Graphic2D.DrawImage(this.worldTexture, ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2, 3);
        Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, this.worldNames[this.unlockedGalaxy]), ApplicationData.screenWidth >> 1, ApplicationData.screenHeight - this.worldTexture.GetHeight() >> 1, 33, 0);
        this.infoBox.draw();
    }

    public boolean rightSoftButton() {
        return false;
    }

    public boolean leftSoftButton() {
        CGEngine.IncCurrentLevel();
        UIScreen.SetCurrentScreen(new SelectPlanet(CGEngine.m_nCurrentGalaxy - 1, CGEngine.m_nCurrentLevel - 1));
        return true;
    }

    public boolean onFireAction() {
        return this.leftSoftButton();
    }

    public boolean actionSoftButton(int nID, boolean pressed) {
        return super.actionSoftButton(nID, pressed);
    }
}

