/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.ListInt;
import baltorogames.system.Options;
import java.util.Vector;

public class AchievementPopup {
    private static Vector infoList = new Vector();
    private static long startTime = 0L;
    private static float m_xpos;
    private static float m_ypos;
    private static float m_width;
    private static float m_height;
    private static CGTexture backTexture;
    private static Vector headerText;

    public static void Init() {
        startTime = 0L;
        backTexture = TextureManager.CreateFilteredTexture("/menu/achieve_popup_bg.png");
        m_width = backTexture.GetWidth();
        m_height = backTexture.GetHeight();
    }

    public static boolean IsEnabled() {
        return startTime > 0L;
    }

    public static void Step() {
        if (startTime > 0L) {
            long lDeltaTime = ApplicationData.getAppTime() - startTime;
            if (lDeltaTime > 2000L) {
                if (infoList.size() > 0) {
                    int nCurrentID = ((ListInt)AchievementPopup.infoList.elementAt((int)0)).nValue;
                    infoList.removeElementAt(0);
                    AchievementPopup.NewAchievementInfoInternal(nCurrentID);
                } else {
                    startTime = 0L;
                }
            } else {
                AchievementPopup.Render(lDeltaTime);
            }
        }
    }

    public static void NewAchievement(int nIndex) {
        if (startTime > 0L) {
            ListInt obj = new ListInt();
            obj.nValue = nIndex;
            infoList.addElement(obj);
        } else {
            AchievementPopup.NewAchievementInfoInternal(nIndex);
        }
    }

    private static void NewAchievementInfoInternal(int nIndex) {
        startTime = ApplicationData.getAppTime();
        headerText = nIndex < 100 ? Utils.splitText(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_ACHIEVEMENT_HEADER_" + nIndex), ApplicationData.defaultFont.encodeDynamicString("+")) : Utils.splitText(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_POPUP_NEW_SURVIVAL_MAP_AVAILABLE"), ApplicationData.defaultFont.encodeDynamicString("+"));
    }

    private static void Render(long lDeltaTime) {
        float fAlpha = 0.0f;
        if (lDeltaTime <= 300L) {
            fAlpha = (float)lDeltaTime / 300.0f;
        } else if (lDeltaTime <= 1500L) {
            fAlpha = 1.0f;
        } else if (lDeltaTime <= 1800L) {
            fAlpha = 1.0f - (float)(lDeltaTime - 1500L) / 300.0f;
        } else if (lDeltaTime <= 2000L) {
            fAlpha = 0.0f;
        }
        if (fAlpha == 1.0f) {
            int nY = ApplicationData.screenHeight - backTexture.GetHeight() / 3;
            Graphic2D.DrawImage(backTexture, ApplicationData.screenWidth / 2, nY, 33);
            nY -= 2 * backTexture.GetHeight() / 3;
            if (headerText.size() == 1) {
                nY += ApplicationData.defaultFont.getFontHeight() / 2;
            }
            Utils.drawString((String)headerText.elementAt(0), ApplicationData.screenWidth / 2, nY, 17, 0);
            nY += ApplicationData.defaultFont.getFontHeight();
            if (headerText.size() > 1) {
                Utils.drawString((String)headerText.elementAt(1), ApplicationData.screenWidth / 2, nY, 17, 0);
            }
        }
    }

    static {
        backTexture = null;
        headerText = null;
    }
}

