/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIAnimatedButtonH;
import baltorogames.core_gui.UIButton;
import baltorogames.core_gui.UIFloatingTextBox;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gameplay.LevelScenario;
import baltorogames.project_gui.LoadingLevelScreen;
import baltorogames.project_gui.MainScreen;
import baltorogames.project_gui.SelectGalaxy;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;
import baltorogames.system.Platform;

public class SelectPlanet
extends MainScreen {
    public static boolean forceLevelsUnlock = false;
    private final int LEFT_ARROW_ID;
    private final int RIGHT_ARROW_ID;
    public static int selectedPlanet = 0;
    private int selectedGalaxy;
    private UIFloatingTextBox infoBox;
    private LevelScenario ls;
    private boolean bAvailable = true;
    private CGTexture backgroundTexture = null;
    private int fontHeight = 0;
    private String[][] requirements;

    public SelectPlanet(int _selectedGalaxy) {
        this.LEFT_ARROW_ID = 100;
        this.RIGHT_ARROW_ID = 101;
        this.drawTop = true;
        this.drawTitle = true;
        this.windowCaptionText = "";
        this.fontHeight = ApplicationData.defaultFont.getFontHeight();
        this.bAvailable = true;
        this.selectedGalaxy = _selectedGalaxy;
        this.backgroundTexture = TextureManager.AddTexture("/menu/level_locked.png");
        this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        this.requirements = new String[4][2];
        int x = 9 * ApplicationData.screenWidth / 10 - ObjectsCache.arrowRight.GetWidth() / 2;
        int y = ApplicationData.screenHeight / 4;
        if (y < ObjectsCache.topMenuBar.GetHeight() + this.backgroundTexture.GetHeight() / 2 + 2) {
            y = ObjectsCache.topMenuBar.GetHeight() + this.backgroundTexture.GetHeight() / 2 + 2;
        }
        UIAnimatedButtonH rightB = new UIAnimatedButtonH(x, y -= ObjectsCache.arrowRight.GetHeight() / 2, ObjectsCache.arrowRight, ObjectsCache.arrowRight_a, 101);
        rightB.setScreen(this);
        rightB.setAnimDir(1.0f);
        this.addButton(rightB);
        x = ApplicationData.screenWidth / 10 - ObjectsCache.arrowRight.GetWidth() / 2;
        UIAnimatedButtonH leftB = new UIAnimatedButtonH(x, y, ObjectsCache.arrowLeft, ObjectsCache.arrowLeft_a, 100);
        leftB.setScreen(this);
        leftB.setAnimDir(-1.0f);
        this.addButton(leftB);
        this.infoBox = new UIFloatingTextBox(true, 0, ApplicationData.screenHeight / 2, ApplicationData.screenWidth, ApplicationData.defaultFont.getFontHeight() * 5);
        this.updateInfo();
    }

    public SelectPlanet(int _selectedGalaxy, int _selectedPlanet) {
        this(_selectedGalaxy);
        selectedPlanet = _selectedPlanet;
    }

    public void autoSize() {
        this.clientAreaX = Platform.WND_MARGIN_LEFT;
        this.clientAreaWidth = this.width - Platform.WND_MARGIN_LEFT - Platform.WND_MARGIN_RIGHT;
        this.clientAreaY = Platform.WND_MARGIN_TOP;
        this.clientAreaHeight = this.height - Platform.WND_MARGIN_TOP - Platform.WND_MARGIN_BOTTOM;
    }

    private void updateInfo() {
        this.bAvailable = true;
        this.backgroundTexture = !this.bAvailable ? TextureManager.AddTexture("/menu/level_locked.png") : TextureManager.AddTexture("/menu/level_unlocked.png");
        this.findByID(UIScreen.ID_BUTTON_OK).setVisible(this.bAvailable);
        this.ls = new LevelScenario();
        String fileName = "/map_" + CGEngine.m_nCurrentGalaxy + "_" + (selectedPlanet + 1) + ".txt";
        this.ls.Load(fileName);
        this.requirements[0][0] = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_BEAT_MAP");
        this.requirements[0][1] = ApplicationData.defaultFont.encodeDynamicString(" " + this.ls.m_timeLimit);
        this.requirements[1][0] = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_BEAT_SCORE");
        this.requirements[1][1] = ApplicationData.defaultFont.encodeDynamicString(" " + this.ls.m_ballLimit);
        this.requirements[2][0] = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_BEAT_TIME");
        this.requirements[2][1] = ApplicationData.defaultFont.encodeDynamicString(" " + this.ls.m_scoreLimit);
        this.requirements[3][0] = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_BEAT_ITEM");
        this.requirements[3][1] = ApplicationData.defaultFont.encodeDynamicString(" " + this.ls.m_itemLimit);
    }

    public void onUpdate(float deltaTime) {
        super.onUpdate(deltaTime);
    }

    public void draw() {
        int y = ApplicationData.screenHeight / 4 - this.backgroundTexture.GetHeight() / 2;
        if (y < ObjectsCache.topMenuBar.GetHeight() + 2) {
            y = ObjectsCache.topMenuBar.GetHeight() + 2;
        }
        Graphic2D.DrawImage(this.backgroundTexture, ApplicationData.screenWidth / 2, y, 17);
        Utils.drawString(ApplicationData.defaultFont.encodeDynamicString(this.selectedGalaxy + 1 + " - " + (selectedPlanet + 1)), ApplicationData.screenWidth / 2, y + this.backgroundTexture.GetHeight() / 2, 3, 0);
        if (!this.bAvailable) {
            Graphic2D.DrawImage(ObjectsCache.lockTexture, ApplicationData.screenWidth / 2 + this.backgroundTexture.GetWidth() / 4, y + this.backgroundTexture.GetHeight() / 2 + ObjectsCache.lockTexture.GetHeight(), 3);
        }
        y = ApplicationData.screenHeight / 4 + this.backgroundTexture.GetHeight() / 2;
        int nLevel = this.selectedGalaxy * 15 + selectedPlanet;
        int numStars = CGUserCareer.arrLevelStats[nLevel].m_nStars;
        for (int i = 1; i <= 3; ++i) {
            Graphic2D.DrawImage(numStars < i ? ObjectsCache.starEmpty : ObjectsCache.starFull, ApplicationData.screenWidth / 4 * i, y, 17);
        }
        if (this.bAvailable) {
            this.drawRequirements(this.requirements, 2 * ApplicationData.screenWidth / 3, y + ObjectsCache.starFull.GetHeight() + this.fontHeight);
        }
    }

    private void drawRequirements(String[][] req, int x, int y) {
        if (this.ls.m_timeLimit > 0) {
            Utils.drawString(req[0][0], x, y, 24, 0);
            Utils.drawString(req[0][1], x, y, 20, 0);
            y += this.fontHeight;
        }
        if (this.ls.m_ballLimit > 0) {
            Utils.drawString(req[1][0], x, y, 24, 0);
            Utils.drawString(req[1][1], x, y, 20, 0);
            y += this.fontHeight;
        }
        if (this.ls.m_scoreLimit > 0) {
            Utils.drawString(req[2][0], x, y, 24, 0);
            Utils.drawString(req[2][1], x, y, 20, 0);
            y += this.fontHeight;
        }
        if (this.ls.m_itemLimit > 0) {
            Utils.drawString(req[3][0], x, y, 24, 0);
            Utils.drawString(req[3][1], x, y, 20, 0);
            y += this.fontHeight;
        }
    }

    public boolean rightSoftButton() {
        TextureManager.DeleteTexture(this.backgroundTexture);
        UIScreen.SetCurrentScreen(new SelectGalaxy());
        return true;
    }

    public boolean leftSoftButton() {
        if (this.bAvailable) {
            CGEngine.m_nSurvivalLevel = -1;
            CGEngine.m_nCurrentLevel = selectedPlanet + 1;
            TextureManager.DeleteTexture(this.backgroundTexture);
            UIScreen.SetCurrentScreen(new LoadingLevelScreen());
        }
        return true;
    }

    public boolean onRightAction() {
        if (++selectedPlanet >= 15) {
            selectedPlanet = 0;
        }
        this.updateInfo();
        return true;
    }

    public boolean onLeftAction() {
        if (--selectedPlanet < 0) {
            selectedPlanet = 14;
        }
        this.updateInfo();
        return true;
    }

    public boolean onFireAction() {
        return this.leftSoftButton();
    }

    public boolean selectLeftAction() {
        UIButton b = this.findByID(100);
        if (b != null) {
            b.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean selectRightAction() {
        UIButton b = this.findByID(101);
        if (b != null) {
            b.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean actionSoftButton(int nID, boolean pressed) {
        if (super.actionSoftButton(nID, pressed)) {
            return true;
        }
        if (!pressed) {
            this.unselectAllButtons();
            if (nID == 100) {
                this.onLeftAction();
                return true;
            }
            if (nID == 101) {
                this.onRightAction();
                return true;
            }
        }
        return false;
    }
}

