/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.graphic3d;

import baltorogames.graphic3d.BGTransform;
import baltorogames.graphic3d.VectorF3;

public class MatrixF44
implements BGTransform {
    protected static float[] zeroArray = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    public float[] a = new float[16];
    public static MatrixF44 g_Matrix1 = new MatrixF44();
    public static MatrixF44 g_Matrix2 = new MatrixF44();
    public static MatrixF44 g_Matrix3 = new MatrixF44();
    public static MatrixF44 g_Matrix4 = new MatrixF44();
    public static MatrixF44 g_Matrix5 = new MatrixF44();
    public static MatrixF44 g_Matrix6 = new MatrixF44();
    public static MatrixF44 g_Matrix7 = new MatrixF44();
    public static MatrixF44 g_Matrix8 = new MatrixF44();
    public static MatrixF44 g_Matrix9 = new MatrixF44();
    public static MatrixF44 g_Matrix10 = new MatrixF44();
    static float[] tmp = new float[16];

    public MatrixF44() {
        MatrixF44.MatrixF44_Identity(this);
    }

    float Get(int row, int column) {
        return this.a[(row << 2) + column];
    }

    public void postScale(float sx, float sy, float sz) {
        MatrixF44 pDst = new MatrixF44();
        MatrixF44.MatrixF44_Scale(pDst, sx, sy, sz);
        MatrixF44.MatrixF44_Multiply(this, pDst, this);
    }

    public void postTranslate(float tx, float ty, float tz) {
        this.a[12] = this.a[12] + tx;
        this.a[13] = this.a[13] + ty;
        this.a[14] = this.a[14] + tz;
    }

    public void postRotate(float angle, float x, float y, float z) {
        MatrixF44 pDst = new MatrixF44();
        MatrixF44.MatrixF44_RotXYZ(pDst, angle, x, y, z);
        MatrixF44.MatrixF44_Multiply(this, pDst, this);
    }

    public void setIdentity() {
        System.arraycopy(zeroArray, 0, this.a, 0, 16);
        this.a[0] = 1.0f;
        this.a[5] = 1.0f;
        this.a[10] = 1.0f;
        this.a[15] = 1.0f;
    }

    public void postMultiply(BGTransform t) {
        float[] b = t.get();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                float subt = 0.0f;
                for (int k = 0; k < 4; ++k) {
                    subt += b[k * 4 + i] * this.a[j * 4 + k];
                }
                MatrixF44.tmp[j * 4 + i] = subt;
            }
        }
        System.arraycopy(tmp, 0, this.a, 0, 16);
    }

    public void transpose() {
        float fTmp = 0.0f;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                fTmp = this.a[j * 4 + i];
                this.a[j * 4 + i] = this.a[i * 4 + j];
                this.a[i * 4 + j] = fTmp;
            }
        }
    }

    public void invert() {
    }

    public void transform(float[] point) {
        float[] tmp = new float[4];
        System.arraycopy(point, 0, tmp, 0, 4);
        point[0] = tmp[0] * this.a[0] + tmp[1] * this.a[4] + tmp[2] * this.a[8] + tmp[3] * this.a[12];
        point[1] = tmp[0] * this.a[1] + tmp[1] * this.a[5] + tmp[2] * this.a[9] + tmp[3] * this.a[13];
        point[2] = tmp[0] * this.a[2] + tmp[1] * this.a[6] + tmp[2] * this.a[10] + tmp[3] * this.a[14];
        point[3] = tmp[0] * this.a[3] + tmp[1] * this.a[7] + tmp[2] * this.a[11] + tmp[3] * this.a[15];
    }

    public void set(float[] transform) {
        System.arraycopy(transform, 0, this.a, 0, 16);
    }

    public void set(BGTransform transform) {
        float[] tr = transform.get();
        System.arraycopy(tr, 0, this.a, 0, 16);
    }

    public float[] get() {
        float[] values = new float[16];
        System.arraycopy(this.a, 0, values, 0, 16);
        return values;
    }

    public static void MatrixF44_Mul_VectorF3(VectorF3 vec, MatrixF44 m, VectorF3 dst) {
        dst.x = vec.x * m.a[0] + vec.y * m.a[4] + vec.z * m.a[8];
        dst.y = vec.x * m.a[1] + vec.y * m.a[5] + vec.z * m.a[9];
        dst.z = vec.x * m.a[2] + vec.y * m.a[6] + vec.z * m.a[10];
    }

    public static void MatrixF44_Copy(MatrixF44 pSrc, MatrixF44 pDst) {
        System.arraycopy(pSrc.a, 0, pDst.a, 0, 16);
    }

    public static void MatrixF44_Identity(MatrixF44 pDst) {
        System.arraycopy(zeroArray, 0, pDst.a, 0, 16);
        pDst.a[0] = 1.0f;
        pDst.a[5] = 1.0f;
        pDst.a[10] = 1.0f;
        pDst.a[15] = 1.0f;
    }

    public static void MatrixF44_Scale(MatrixF44 pDst, float x, float y, float z) {
        System.arraycopy(zeroArray, 0, pDst.a, 0, 16);
        pDst.a[0] = x;
        pDst.a[5] = y;
        pDst.a[10] = z;
        pDst.a[15] = 1.0f;
    }

    public static void MatrixF44_RotX(MatrixF44 pDst, float fSinX, float fCosX, float fAngle) {
        MatrixF44.MatrixF44_Identity(pDst);
        pDst.a[5] = fCosX;
        pDst.a[6] = fSinX;
        pDst.a[9] = -fSinX;
        pDst.a[10] = fCosX;
    }

    public static void MatrixF44_RotX(MatrixF44 pDst, float fAngle) {
        float fVal;
        MatrixF44.MatrixF44_Identity(pDst);
        pDst.a[6] = fVal = (float)Math.sin(fAngle);
        pDst.a[9] = -fVal;
        pDst.a[5] = fVal = (float)Math.cos(fAngle);
        pDst.a[10] = fVal;
    }

    public static void MatrixF44_RotY(MatrixF44 pDst, float fSinX, float fCosX, float fAngle) {
        MatrixF44.MatrixF44_Identity(pDst);
        pDst.a[0] = fCosX;
        pDst.a[2] = -fSinX;
        pDst.a[8] = fSinX;
        pDst.a[10] = fCosX;
    }

    public static void MatrixF44_RotY(MatrixF44 pDst, float fAngle) {
        MatrixF44.MatrixF44_Identity(pDst);
        float fVal = (float)Math.sin(fAngle);
        pDst.a[2] = -fVal;
        pDst.a[8] = fVal;
        pDst.a[0] = fVal = (float)Math.cos(fAngle);
        pDst.a[10] = fVal;
    }

    public static void MatrixF44_RotZ(MatrixF44 pDst, float fSinX, float fCosX, float fAngle) {
        MatrixF44.MatrixF44_Identity(pDst);
        pDst.a[0] = fCosX;
        pDst.a[1] = fSinX;
        pDst.a[4] = -fSinX;
        pDst.a[5] = fCosX;
    }

    public static void MatrixF44_RotZ(MatrixF44 pDst, float fAngle) {
        float fVal;
        MatrixF44.MatrixF44_Identity(pDst);
        pDst.a[1] = fVal = (float)Math.sin(fAngle);
        pDst.a[4] = -fVal;
        pDst.a[0] = fVal = (float)Math.cos(fAngle);
        pDst.a[5] = fVal;
    }

    public static void MatrixF44_RotXYZ(MatrixF44 pDst, float fAngle, float x, float y, float z) {
        float s = (float)Math.sin(fAngle);
        float c = (float)Math.cos(fAngle);
        pDst.a[0] = x * x + (1.0f - x * x) * c;
        pDst.a[1] = x * y * (1.0f - c) - z * s;
        pDst.a[2] = x * z * (1.0f - c) - y * s;
        pDst.a[3] = 0.0f;
        pDst.a[4] = x * y * (1.0f - c) + z * s;
        pDst.a[5] = y * y + (1.0f - y * y) * c;
        pDst.a[6] = y * z * (1.0f - c) - x * s;
        pDst.a[7] = 0.0f;
        pDst.a[8] = x * z * (1.0f - c) - y * s;
        pDst.a[9] = y * z * (1.0f - c) + x * s;
        pDst.a[10] = z * z + (1.0f - z * z) * c;
        pDst.a[11] = 0.0f;
        pDst.a[12] = 0.0f;
        pDst.a[13] = 0.0f;
        pDst.a[14] = 0.0f;
        pDst.a[15] = 1.0f;
    }

    public static void MatrixF44_Multiply(MatrixF44 a, MatrixF44 b, MatrixF44 ab) {
        MatrixF44 ret = g_Matrix10;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                float subt = 0.0f;
                for (int k = 0; k < 4; ++k) {
                    subt += b.a[k * 4 + i] * a.a[j * 4 + k];
                }
                ret.a[j * 4 + i] = subt;
            }
        }
        MatrixF44.MatrixF44_Copy(ret, ab);
    }

    public static void MatrixF44_MultiplyQ(MatrixF44 a, MatrixF44 b, MatrixF44 ab) {
        MatrixF44 ret = g_Matrix10;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                float subt = 0.0f;
                for (int k = 0; k < 4; ++k) {
                    subt += b.a[k * 4 + i] * a.a[j * 4 + k];
                }
                ab.a[j * 4 + i] = subt;
            }
        }
    }

    public static void IdentityMatrix(float[] fMatrix) {
        fMatrix[0] = 1.0f;
        fMatrix[1] = 0.0f;
        fMatrix[2] = 0.0f;
        fMatrix[3] = 0.0f;
        fMatrix[4] = 0.0f;
        fMatrix[5] = 1.0f;
        fMatrix[6] = 0.0f;
        fMatrix[7] = 0.0f;
        fMatrix[8] = 0.0f;
        fMatrix[9] = 0.0f;
        fMatrix[10] = 1.0f;
        fMatrix[11] = 0.0f;
        fMatrix[12] = 0.0f;
        fMatrix[13] = 0.0f;
        fMatrix[14] = 0.0f;
        fMatrix[15] = 1.0f;
    }

    public static void CopyMatrix(float[] fMatrixSrc, float[] fMatrixDest) {
        System.arraycopy(fMatrixSrc, 0, fMatrixDest, 0, 16);
    }

    public static void MultiplyMatrixes(float[] fMatrixSrc1, float[] fMatrixSrc2, float[] fMatrixDest) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                float subt = 0.0f;
                for (int k = 0; k < 4; ++k) {
                    subt += fMatrixSrc2[k * 4 + i] * fMatrixSrc1[j * 4 + k];
                }
                MatrixF44.tmp[j * 4 + i] = subt;
            }
        }
        System.arraycopy(tmp, 0, fMatrixDest, 0, 16);
    }
}

