/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.ApplicationData;
import baltorogames.core.KeyCommand;
import baltorogames.core.Log;
import baltorogames.core.RandSync;
import baltorogames.core.TouchCommand;
import baltorogames.core.Utils;
import baltorogames.core.VectorF2;
import baltorogames.core_gui.UIScreen;
import baltorogames.gameplay.Game;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.particles.CGDynamicObj;
import baltorogames.project_gameplay.CGAchievements;
import baltorogames.project_gameplay.CGBoard;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGEngineRenderer;
import baltorogames.project_gameplay.CGFallingBall;
import baltorogames.project_gameplay.CGHit;
import baltorogames.project_gameplay.CGLevelStats;
import baltorogames.project_gameplay.CGSoundSystem;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gameplay.SurvivalTimeBar;
import baltorogames.project_gameplay.WorldMap;
import baltorogames.project_gui.InGameMainMenu;
import baltorogames.system.FileManager;
import baltorogames.system.ObjectsCache;
import java.io.DataInputStream;
import java.io.InputStream;

public class MyGame
extends Game {
    public WorldMap m_WorldMap = null;
    protected DataInputStream m_dis = null;
    public int m_nLoadingStepNr = 0;
    public static final int NUM_WAVES = 10;
    public CGTexture[] m_HUDIcon = null;
    public CGTexture[] m_SpecialPowerupsIcon = null;
    public CGTexture[] m_SpecialPowerupsInactiveIcon = null;

    public int init() {
        CGUserCareer.LoadGlobalParams();
        CGUserCareer.Reset();
        CGUserCareer.Load();
        CGAchievements.Load();
        CGDynamicObj.Initialize();
        CGDynamicObj.SetGlobalScale(30.0f);
        CGDynamicObj.CreateDynamicObjectTemplate("/DO/explosion.do", "explosion.do");
        CGDynamicObj.CreateDynamicObjectTemplate("/DO/freeze.do", "freeze.do");
        CGDynamicObj.CreateDynamicObjectTemplate("/DO/laser.do", "laser.do");
        CGDynamicObj.CreateDynamicObjectTemplate("/DO/laser_shoot.do", "laser_shoot.do");
        CGDynamicObj.CreateDynamicObjectTemplate("/DO/normal_shoot.do", "normal_shoot.do");
        CGDynamicObj.CreateDynamicObjectTemplate("/DO/pow_bomb.do", "pow_bomb.do");
        CGDynamicObj.CreateDynamicObjectTemplate("/DO/pow_color.do", "pow_color.do");
        CGDynamicObj.CreateDynamicObjectTemplate("/DO/pow_freeze.do", "pow_freeze.do");
        CGDynamicObj.CreateDynamicObjectTemplate("/DO/pow_laser.do", "pow_laser.do");
        CGDynamicObj.CreateDynamicObjectTemplate("/DO/pow_money.do", "pow_money.do");
        CGDynamicObj.CreateDynamicObjectTemplate("/DO/pow_multi.do", "pow_multi.do");
        CGDynamicObj.CreateDynamicObjectTemplate("/DO/pow_reverse.do", "pow_reverse.do");
        CGDynamicObj.CreateDynamicObjectTemplate("/DO/pow_swap.do", "pow_swap.do");
        CGDynamicObj.CreateDynamicObjectTemplate("/DO/pow_uniball.do", "pow_uniball.do");
        CGDynamicObj.CreateDynamicObjectTemplate("/DO/swap.do", "swap.do");
        CGDynamicObj.CreateDynamicObjectTemplate("/DO/teleport.do", "teleport.do");
        CGDynamicObj.CreateDynamicObjectTemplate("/DO/uniball_shoot.do", "uniball_shoot.do");
        this.m_HUDIcon = new CGTexture[3];
        this.m_HUDIcon[0] = TextureManager.CreateTexture("/menu/hud_ico_time.png");
        this.m_HUDIcon[1] = TextureManager.CreateTexture("/menu/null.png");
        this.m_HUDIcon[2] = TextureManager.CreateTexture("/menu/hud_ico_ball.png");
        this.m_SpecialPowerupsIcon = new CGTexture[3];
        this.m_SpecialPowerupsIcon[0] = TextureManager.CreateTexture("/menu/hud_ka.png");
        this.m_SpecialPowerupsIcon[1] = TextureManager.CreateTexture("/menu/hud_sd.png");
        this.m_SpecialPowerupsIcon[2] = TextureManager.CreateTexture("/menu/hud_tw.png");
        this.m_SpecialPowerupsInactiveIcon = new CGTexture[3];
        this.m_SpecialPowerupsInactiveIcon[0] = TextureManager.CreateTexture("/menu/hud_ka_i.png");
        this.m_SpecialPowerupsInactiveIcon[1] = TextureManager.CreateTexture("/menu/hud_sd_i.png");
        this.m_SpecialPowerupsInactiveIcon[2] = TextureManager.CreateTexture("/menu/hud_tw_i.png");
        CGBoard.Init();
        CGFallingBall.Init();
        RandSync.Init();
        RandSync.SetStartValue((int)System.currentTimeMillis() % 1000);
        return CGEngine.Init();
    }

    public void destroy() {
        CGDynamicObj.Uninitialize();
        CGUserCareer.Save();
        CGEngine.Destroy();
    }

    public int startLoading(String fileName) {
        TextureManager.ClearTextures();
        CGEngineRenderer.Init();
        CGHit.Initialize();
        this.m_dis = null;
        this.m_nLoadingStepNr = 0;
        return 1;
    }

    public int stepLoading(String fileName) {
        try {
            if (this.m_nLoadingStepNr == 0) {
                System.out.println("Start loading " + fileName);
                InputStream is = null;
                is = FileManager.OpenFile(fileName);
                if (is == null) {
                    is = FileManager.OpenURLFile(fileName);
                }
                if (is == null) {
                    return 0;
                }
                this.m_dis = new DataInputStream(is);
                this.m_nLoadingStepNr = 1;
            } else if (this.m_nLoadingStepNr == 1) {
                if (this.m_dis != null) {
                    this.m_WorldMap = new WorldMap();
                    this.m_WorldMap.Load(this.m_dis);
                }
                this.m_nLoadingStepNr = 2;
            } else if (this.m_nLoadingStepNr == 2) {
                if (this.m_dis != null) {
                    CGEngine.Load1(this.m_dis);
                }
                this.m_nLoadingStepNr = 3;
            } else if (this.m_nLoadingStepNr == 3) {
                if (this.m_dis != null) {
                    CGEngine.Load2(this.m_dis);
                }
                this.m_nLoadingStepNr = 4;
            }
            return 1;
        }
        catch (Exception e) {
            Log.DEBUG_LOG(16, "Engine " + fileName + " loading error!!!");
            return 0;
        }
    }

    public int endLoading(String fileName) {
        UIScreen.SetCurrentScreen(null);
        ApplicationData.generalGameMode = 4;
        if (ApplicationData.isMainMenuMode()) {
            CGSoundSystem.PlayMusic("/mainmenu.mid");
        } else {
            switch (CGEngine.m_nCurrentGalaxy) {
                case 1: {
                    CGSoundSystem.PlayMusic("/galaxy_1.mid");
                    break;
                }
                case 2: {
                    CGSoundSystem.PlayMusic("/galaxy_2.mid");
                    break;
                }
                case 3: {
                    CGSoundSystem.PlayMusic("/galaxy_3.mid");
                }
            }
        }
        return 1;
    }

    public void updateLogic(long deltaTimeInMs) {
        CGEngine.Update((int)deltaTimeInMs);
    }

    public void drawGamePlay() {
        this.m_WorldMap.Render(0, 8);
        CGEngine.Render();
        if (CGEngine.m_nSurvivalLevel < 0) {
            if (CGEngine.m_Board.m_LevelScenario.m_scoreLimit > 0) {
                Utils.drawString(ApplicationData.defaultFont.encodeDynamicString(CGLevelStats.m_nScore + "/" + CGEngine.m_Board.m_LevelScenario.m_scoreLimit), CGEngineRenderer.m_boundaries[CGEngine.m_nCurrentGalaxy - 1][2].GetHeight() / 4, CGEngineRenderer.m_boundaries[CGEngine.m_nCurrentGalaxy - 1][2].GetHeight() / 2, 6, 0);
            } else {
                Utils.drawString(ApplicationData.defaultFont.encodeDynamicString("" + CGLevelStats.m_nScore), CGEngineRenderer.m_boundaries[CGEngine.m_nCurrentGalaxy - 1][2].GetHeight() / 4, CGEngineRenderer.m_boundaries[CGEngine.m_nCurrentGalaxy - 1][2].GetHeight() / 2, 6, 0);
            }
            this.m_HUDIcon[1] = TextureManager.CreateTexture("/menu/hud_ico_item.png");
            this.m_HUDIcon[2] = TextureManager.CreateTexture("/menu/hud_ico_ball.png");
            if (CGEngine.m_Board.m_LevelScenario.m_timeLimit > 0) {
                int timeLeft = CGEngine.m_Board.m_LevelScenario.m_timeLimit - CGLevelStats.m_nTimeStatsInMs / 1000;
                if (timeLeft < 0) {
                    timeLeft = 0;
                }
                String time = ApplicationData.defaultFont.encodeDynamicString("123");
                int timeWidth = Utils.stringWidth(time, 0);
                Graphic2D.DrawImage(this.m_HUDIcon[0], ApplicationData.screenWidth - timeWidth, CGEngineRenderer.m_boundaries[CGEngine.m_nCurrentGalaxy - 1][2].GetHeight() / 2, 10);
                Utils.drawString(ApplicationData.defaultFont.encodeDynamicString("" + timeLeft), ApplicationData.screenWidth - timeWidth, CGEngineRenderer.m_boundaries[CGEngine.m_nCurrentGalaxy - 1][2].GetHeight() / 2, 6, 0);
            }
            if (CGEngine.m_Board.m_LevelScenario.m_ballLimit > 0) {
                Graphic2D.DrawImage(this.m_HUDIcon[2], ApplicationData.screenWidth / 2, CGEngineRenderer.m_boundaries[CGEngine.m_nCurrentGalaxy - 1][2].GetHeight() / 2, 10);
                Utils.drawString(ApplicationData.defaultFont.encodeDynamicString(CGLevelStats.m_nBallsUsed + "/" + CGEngine.m_Board.m_LevelScenario.m_ballLimit), ApplicationData.screenWidth / 2 + CGEngineRenderer.m_boundaries[CGEngine.m_nCurrentGalaxy - 1][2].GetHeight() / 8, CGEngineRenderer.m_boundaries[CGEngine.m_nCurrentGalaxy - 1][2].GetHeight() / 2, 6, 0);
            }
            if (CGEngine.m_Board.m_LevelScenario.m_itemLimit > 0) {
                Graphic2D.DrawImage(this.m_HUDIcon[1], ApplicationData.screenWidth / 2, CGEngineRenderer.m_boundaries[CGEngine.m_nCurrentGalaxy - 1][2].GetHeight() / 2, 10);
                Utils.drawString(ApplicationData.defaultFont.encodeDynamicString(CGLevelStats.m_nItemsGathered + "/" + CGEngine.m_Board.m_LevelScenario.m_itemLimit), ApplicationData.screenWidth / 2 + CGEngineRenderer.m_boundaries[CGEngine.m_nCurrentGalaxy - 1][2].GetHeight() / 8, CGEngineRenderer.m_boundaries[CGEngine.m_nCurrentGalaxy - 1][2].GetHeight() / 2, 6, 0);
            }
        } else {
            Utils.drawString(ApplicationData.defaultFont.encodeDynamicString("" + CGLevelStats.m_nScore), CGEngineRenderer.m_boundaries[CGEngine.m_nCurrentGalaxy - 1][2].GetHeight() / 4, CGEngineRenderer.m_boundaries[CGEngine.m_nCurrentGalaxy - 1][2].GetHeight() / 2, 6, 0);
            int time = 0;
            time = CGEngine.IsEndlessMode() && CGEngine.IsTimed() ? CGLevelStats.m_nTimeInMs / 1000 : CGLevelStats.m_nTimeStatsInMs / 1000;
            String timeStr = ApplicationData.defaultFont.encodeDynamicString("888");
            int timeWidth = Utils.stringWidth(timeStr, 0);
            Graphic2D.DrawImage(this.m_HUDIcon[0], ApplicationData.screenWidth - timeWidth, CGEngineRenderer.m_boundaries[CGEngine.m_nCurrentGalaxy - 1][2].GetHeight() / 2, 10);
            Utils.drawString(ApplicationData.defaultFont.encodeDynamicString("" + time), ApplicationData.screenWidth - timeWidth, CGEngineRenderer.m_boundaries[CGEngine.m_nCurrentGalaxy - 1][2].GetHeight() / 2, 6, 0);
            if (CGEngine.IsEndlessMode() && CGEngine.IsSurvival()) {
                Graphic2D.DrawRegion(SurvivalTimeBar.survivalBarTex[0], 0, 0, SurvivalTimeBar.survivalBarTex[0].GetWidth(), SurvivalTimeBar.survivalBarTex[0].GetHeight(), 0, ApplicationData.screenWidth / 2 - SurvivalTimeBar.survivalBarTex[1].GetWidth() / 2, SurvivalTimeBar.survivalBarTex[1].GetHeight(), 36);
                Graphic2D.DrawRegion(SurvivalTimeBar.survivalBarTex[1], 0, 0, SurvivalTimeBar.offset, SurvivalTimeBar.survivalBarTex[1].GetHeight(), 0, ApplicationData.screenWidth / 2 - SurvivalTimeBar.survivalBarTex[1].GetWidth() / 2, SurvivalTimeBar.survivalBarTex[1].GetHeight(), 36);
            }
        }
        if (Game.pauseTouchKeyPressed) {
            Graphic2D.DrawImage(ObjectsCache.menuSbPAUSE_a, ApplicationData.screenWidth, ApplicationData.screenHeight, 40);
        } else {
            Graphic2D.DrawImage(ObjectsCache.menuSbPAUSE, ApplicationData.screenWidth, ApplicationData.screenHeight, 40);
        }
    }

    public void processTouchCommand(TouchCommand cmd) {
        try {
            if (cmd.onPressed) {
                if (cmd.areaY > ApplicationData.screenHeight - ObjectsCache.menuSbPAUSE.GetHeight() && cmd.areaX > ApplicationData.screenWidth - ObjectsCache.menuSbPAUSE.GetWidth()) {
                    Game.pauseTouchKeyPressed = true;
                    return;
                }
                Game.pauseTouchKeyPressed = false;
            }
            if (cmd.onPressed) {
                CGEngine.m_bWaitForHit = true;
                CGEngine.m_fWaitHitDX = ((float)cmd.areaX - CGEngineRenderer.m_fScreenOffsetX) * (1.0f / CGEngine.m_fEngineScale);
                CGEngine.m_fWaitHitDY = ((float)cmd.areaY - CGEngineRenderer.m_fScreenOffsetY) * (1.0f / CGEngine.m_fEngineScale);
                if (CGEngine.m_ChickenObject != null) {
                    CGEngine.m_ChickenObject.m_nStartTime = 0;
                }
            } else if (!cmd.onPressed && Game.pauseTouchKeyPressed && cmd.areaY > ApplicationData.screenHeight - ObjectsCache.menuSbPAUSE.GetHeight() && cmd.areaX > ApplicationData.screenWidth - ObjectsCache.menuSbPAUSE.GetWidth()) {
                Game.pauseTouchKeyPressed = false;
                UIScreen.SetCurrentScreen(new InGameMainMenu());
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void processKeyCommand(KeyCommand cmd) {
        if (cmd.pressed) {
            if (cmd.keyCode == ApplicationData.SoftButton1_Code || cmd.keyCode == 8) {
                CGEngine.m_bWaitForHit = true;
                VectorF2 vDir = new VectorF2();
                float fDir = CGEngine.m_BallCannon.m_fCurrentAngle;
                VectorF2.VectorFromAngle(CGEngine.m_BallCannon.m_fCurrentAngle, vDir);
                CGEngine.m_BallCannon.m_fCurrentAngle = fDir;
                CGEngine.m_fWaitHitDX = CGEngine.m_BallCannon.m_fPosX - 40.0f * vDir.x;
                CGEngine.m_fWaitHitDY = CGEngine.m_BallCannon.m_fPosY - 40.0f * vDir.y;
                if (CGEngine.m_ChickenObject != null) {
                    CGEngine.m_ChickenObject.m_nStartTime = 0;
                }
            }
            if (cmd.keyCode != 2 && cmd.keyCode != 5 && cmd.keyCode != 1 && cmd.keyCode == 6) {
                // empty if block
            }
        } else {
            if (UIScreen.GetCurrentScreen() == null && cmd.keyCode == ApplicationData.SoftButton2_Code) {
                Game.pauseTouchKeyPressed = true;
            }
            if (UIScreen.GetCurrentScreen() == null && cmd.keyCode == ApplicationData.SoftButton2_Code) {
                Game.pauseTouchKeyPressed = false;
                UIScreen.SetCurrentScreen(new InGameMainMenu());
            }
        }
    }
}

