/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.core_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.KeyCommand;
import baltorogames.core.TouchCommand;
import baltorogames.core_gui.UIButton;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import java.util.Vector;

public abstract class UIScreen {
    public static int ID_BUTTON_OK = 1;
    public static int ID_BUTTON_CANCEL = 2;
    protected static UIScreen m_CurrentScreen = null;
    protected String windowCaptionText;
    protected float lifeTime = 0.0f;
    protected boolean readyForClose = false;
    protected int userPositionX;
    protected int userPositionY;
    protected int userWidth;
    protected int userHeight;
    protected int positionX;
    protected int positionY;
    protected int width;
    protected int height;
    protected int clientAreaX;
    protected int clientAreaY;
    protected int clientAreaWidth;
    protected int clientAreaHeight;
    protected boolean showCaption = false;
    protected boolean showScrollbars = false;
    protected boolean showHScrollbars = false;
    protected int YScrollOffset = 0;
    protected UIScreen parentScreen = null;
    protected Vector buttonsVector = new Vector();
    private boolean bDrawParent = false;
    public int wndAreaHeight = 100;

    public static void SetCurrentScreen(UIScreen s) {
        m_CurrentScreen = s;
        if (m_CurrentScreen != null) {
            m_CurrentScreen.onFocusBack();
            m_CurrentScreen.onUpdate(0.0f);
        }
    }

    public static UIScreen GetCurrentScreen() {
        return m_CurrentScreen;
    }

    public void SetDrawParent(boolean b) {
        this.bDrawParent = b;
    }

    public float getLifeTime() {
        return this.lifeTime;
    }

    public boolean isReadyForClose() {
        return this.readyForClose;
    }

    protected void addButton(UIButton b) {
        this.buttonsVector.addElement(b);
    }

    protected UIButton findByID(int nID) {
        int nS = this.buttonsVector.size();
        for (int i = 0; i < nS; ++i) {
            UIButton b = (UIButton)this.buttonsVector.elementAt(i);
            if (b.getID() != nID) continue;
            return b;
        }
        return null;
    }

    protected boolean removeByID(int nID) {
        int nS = this.buttonsVector.size();
        for (int i = 0; i < nS; ++i) {
            UIButton b = (UIButton)this.buttonsVector.elementAt(i);
            if (b.getID() != nID) continue;
            this.buttonsVector.removeElementAt(i);
            return true;
        }
        return false;
    }

    protected boolean removeButtons(int nStartID) {
        int nS = this.buttonsVector.size();
        for (int i = nS - 1; i >= 0; --i) {
            UIButton b = (UIButton)this.buttonsVector.elementAt(i);
            if (b.getID() < nStartID) continue;
            this.buttonsVector.removeElementAt(i);
        }
        return true;
    }

    protected UIButton findButton(int x, int y) {
        int nS = this.buttonsVector.size();
        for (int i = 0; i < nS; ++i) {
            UIButton b = (UIButton)this.buttonsVector.elementAt(i);
            if (!b.ckeckTouch(x, y)) continue;
            return b;
        }
        return null;
    }

    protected UIButton findSelectedButton() {
        int nS = this.buttonsVector.size();
        for (int i = 0; i < nS; ++i) {
            UIButton b = (UIButton)this.buttonsVector.elementAt(i);
            if (!b.isSelected) continue;
            return b;
        }
        return null;
    }

    protected UIButton findCheckedButton() {
        int nS = this.buttonsVector.size();
        for (int i = 0; i < nS; ++i) {
            UIButton b = (UIButton)this.buttonsVector.elementAt(i);
            if (!b.isChecked) continue;
            return b;
        }
        return null;
    }

    protected void unselectAllButtons() {
        int nS = this.buttonsVector.size();
        for (int i = 0; i < nS; ++i) {
            ((UIButton)this.buttonsVector.elementAt(i)).setSelect(false);
        }
    }

    protected void uncheckAllButtons() {
        int nS = this.buttonsVector.size();
        for (int i = 0; i < nS; ++i) {
            ((UIButton)this.buttonsVector.elementAt(i)).setCheck(false);
        }
    }

    public void setCaption(String captionText) {
        this.windowCaptionText = captionText;
    }

    public void setParent(UIScreen parent) {
        this.parentScreen = parent;
    }

    public UIScreen getParent() {
        return this.parentScreen;
    }

    public void setPositionX(int posX) {
        this.positionX = posX;
    }

    public void setPositionY(int posY) {
        this.positionY = posY;
    }

    public void setPosition(int posX, int posY) {
        this.positionX = posX;
        this.positionY = posY;
    }

    public void setWidth(int newWidth) {
        this.width = newWidth;
    }

    public void setHeight(int newHeight) {
        this.height = newHeight;
    }

    public int getPositionX() {
        return this.positionX;
    }

    public int getPositionY() {
        return this.positionY;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void showCaption(boolean show) {
        this.showCaption = show;
    }

    public void showScrollbars(boolean show) {
        this.showScrollbars = show;
    }

    public void showHScrollbars(boolean show) {
        this.showHScrollbars = show;
    }

    public void setSoftButtonImage(CGTexture ok_left_normal, CGTexture ok_left_select, CGTexture cancel_right_normal, CGTexture cancel_right_select) {
        int y;
        int x;
        int h;
        int w;
        this.removeByID(ID_BUTTON_OK);
        if (ok_left_normal != null) {
            w = ok_left_normal.GetWidth();
            h = ok_left_normal.GetHeight();
            x = 0;
            y = ApplicationData.screenHeight - h;
            UIButton ok = new UIButton(x, y, ok_left_normal, ok_left_select, ok_left_normal, ID_BUTTON_OK);
            this.addButton(ok);
        }
        this.removeByID(ID_BUTTON_CANCEL);
        if (cancel_right_normal != null) {
            w = cancel_right_normal.GetWidth();
            h = cancel_right_normal.GetHeight();
            x = ApplicationData.screenWidth - w;
            y = ApplicationData.screenHeight - h;
            UIButton cancel = new UIButton(x, y, cancel_right_normal, cancel_right_select, cancel_right_normal, ID_BUTTON_CANCEL);
            this.addButton(cancel);
        }
    }

    protected void drawWindowsCaption() {
    }

    protected void drawButtons() {
        if (UIScreen.GetCurrentScreen() == this) {
            Graphic2D.SetClip(0, 0, ApplicationData.screenWidth, ApplicationData.screenHeight);
            int nS = this.buttonsVector.size();
            for (int i = 0; i < nS; ++i) {
                ((UIButton)this.buttonsVector.elementAt(i)).draw();
            }
        } else {
            Graphic2D.SetClip(0, 0, ApplicationData.screenWidth, ApplicationData.screenHeight);
            int nS = this.buttonsVector.size();
            for (int i = 0; i < nS; ++i) {
                UIButton b = (UIButton)this.buttonsVector.elementAt(i);
                if (b == null || b.getID() == ID_BUTTON_OK || b.getID() == ID_BUTTON_CANCEL) continue;
                b.draw();
            }
        }
    }

    public abstract void draw();

    public abstract void drawWindowBackground();

    public abstract void drawWindowForeground();

    public void autoSize() {
    }

    public void onFocusBack() {
        this.unselectAllButtons();
    }

    public boolean leftSelectSoftButton() {
        UIButton button = this.findByID(ID_BUTTON_OK);
        this.unselectAllButtons();
        if (button != null) {
            button.setSelect(true);
            button.setCheck(true);
            return true;
        }
        return false;
    }

    public boolean rightSelectSoftButton() {
        UIButton button = this.findByID(ID_BUTTON_CANCEL);
        this.unselectAllButtons();
        if (button != null) {
            button.setSelect(true);
            button.setCheck(true);
            return true;
        }
        return false;
    }

    public boolean selectFireAction() {
        return this.leftSelectSoftButton();
    }

    public boolean selectLeftAction() {
        return false;
    }

    public boolean selectRightAction() {
        return false;
    }

    public boolean selectUpAction() {
        return false;
    }

    public boolean selectDownAction() {
        return false;
    }

    public boolean leftSoftButton() {
        return false;
    }

    public boolean rightSoftButton() {
        return false;
    }

    public boolean actionSoftButton(int nID, boolean pressed) {
        if (pressed) {
            UIButton button = this.findByID(nID);
            this.unselectAllButtons();
            button.setSelect(true);
            button.setCheck(true);
            return true;
        }
        return false;
    }

    public boolean onUpAction() {
        return false;
    }

    public boolean onDownAction() {
        return false;
    }

    public boolean onLeftAction() {
        return false;
    }

    public boolean onRightAction() {
        return false;
    }

    public boolean onFireAction() {
        return this.leftSoftButton();
    }

    public boolean onKeyAction(int nkeyCode) {
        return false;
    }

    public boolean onKeyDownAction(int nkeyCode) {
        return false;
    }

    public boolean keyEvent(KeyCommand cmd) {
        if (!cmd.pressed) {
            this.unselectAllButtons();
            if (cmd.keyCode == ApplicationData.SoftButton1_Code) {
                return this.leftSoftButton();
            }
            if (cmd.keyCode == ApplicationData.SoftButton2_Code) {
                return this.rightSoftButton();
            }
            if (cmd.keyCode == 8) {
                return this.onFireAction();
            }
            if (cmd.keyCode == 1) {
                return this.onUpAction();
            }
            if (cmd.keyCode == 6) {
                return this.onDownAction();
            }
            if (cmd.keyCode == 2) {
                return this.onLeftAction();
            }
            if (cmd.keyCode == 5) {
                return this.onRightAction();
            }
            return this.onKeyAction(cmd.keyCode);
        }
        if (cmd.keyCode == ApplicationData.SoftButton1_Code) {
            return this.leftSelectSoftButton();
        }
        if (cmd.keyCode == ApplicationData.SoftButton2_Code) {
            return this.rightSelectSoftButton();
        }
        if (cmd.keyCode == 8) {
            return this.selectFireAction();
        }
        if (cmd.keyCode == 2) {
            return this.selectLeftAction();
        }
        if (cmd.keyCode == 5) {
            return this.selectRightAction();
        }
        if (cmd.keyCode == 6) {
            return this.selectDownAction();
        }
        if (cmd.keyCode == 1) {
            return this.selectUpAction();
        }
        return this.onKeyDownAction(cmd.keyCode);
    }

    public boolean keyTouchEvent(TouchCommand cmd) {
        if (cmd.onPressed) {
            UIButton button = this.findButton(cmd.areaX, cmd.areaY);
            if (button != null) {
                int nID = button.getID();
                this.actionSoftButton(nID, true);
                return true;
            }
        } else {
            UIButton button = this.findButton(cmd.areaX, cmd.areaY);
            if (button != null && (button.getSelect() || button.getCheck())) {
                this.unselectAllButtons();
                int nID = button.getID();
                if (nID == ID_BUTTON_OK) {
                    return this.leftSoftButton();
                }
                if (nID == ID_BUTTON_CANCEL) {
                    return this.rightSoftButton();
                }
                return this.actionSoftButton(nID, false);
            }
            UIButton b = this.findSelectedButton();
            if (b != null) {
                this.unselectAllButtons();
                int nID = b.getID();
                if (nID == ID_BUTTON_OK) {
                    return this.leftSoftButton();
                }
                if (nID == ID_BUTTON_CANCEL) {
                    return this.rightSoftButton();
                }
                return this.actionSoftButton(nID, false);
            }
            UIButton b1 = this.findCheckedButton();
            if (b1 != null) {
                this.uncheckAllButtons();
                int nID = b1.getID();
                if (nID == ID_BUTTON_OK) {
                    return this.leftSoftButton();
                }
                if (nID == ID_BUTTON_CANCEL) {
                    return this.rightSoftButton();
                }
                return this.actionSoftButton(nID, false);
            }
        }
        return false;
    }

    public void paint() {
        if (this.bDrawParent && this.parentScreen != null) {
            this.parentScreen.paint();
        }
        this.drawWindowBackground();
        this.drawWindowsCaption();
        this.updateSize();
        this.draw();
        this.drawButtons();
        this.drawWindowForeground();
    }

    public void onUpdate(float deltaTime) {
        this.lifeTime += deltaTime;
    }

    public UIScreen() {
        this.updateSize();
    }

    public void updateSize() {
        int topOfClientArea = ApplicationData.screenHeight - 20 - this.wndAreaHeight;
        this.positionX = 0;
        this.positionY = topOfClientArea;
        this.width = ApplicationData.screenWidth;
        this.height = this.wndAreaHeight;
    }
}

