/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.project_gameplay.CareerKart;
import baltorogames.project_gui.CareerScreen;
import baltorogames.project_gui.EditChampionshipsUserName;
import baltorogames.project_gui.EventScreen;
import baltorogames.project_gui.TrophyStatistic;
import baltorogames.system.BGStore;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class CGUserCareer {
    public static boolean[] avalaibleEvents = new boolean[]{true, false, false, false};
    public static final int eMaxLevels = 9;
    public static int difficultyLevel = 0;
    public static int availableDifficultyLevel = 0;
    public static final int LEVEL_ROOKIE = 0;
    public static final int LEVEL_SEMIPRO = 1;
    public static final int LEVEL_WORLD_CLASS = 2;
    public static final int NUM_KARTS = 6;
    public static final int NR_OF_TRACKS = 9;
    public static final int eNrOfBolids = 6;
    public static int[] generalClasification = new int[6];
    public static boolean[] tracksUnlocked = new boolean[9];
    public static int[] tracksTime = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE};
    public static int[] babeUnlockState = new int[4];
    private static boolean[] availableKarts = new boolean[]{true, true, true, false, false, false, false, false, false, false};
    public static CareerKart[] playerKarts = new CareerKart[6];
    private static int[] raceIDtoCityID = new int[]{1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5};
    private static int[] eventIDtoCityID = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
    protected static String m_szNick;
    protected static String m_szDevicePlatform;
    public static int m_nRaceID;
    public static int currentBabe;
    public static int currentKart;
    public static int m_nFamePoints;
    protected static int m_nPoints;
    protected static int racesWon;

    public static int FindHumanPosition() {
        int n;
        int n2 = generalClasification[0];
        int n3 = generalClasification[0];
        int n4 = generalClasification[0];
        for (n = 0; n < generalClasification.length; ++n) {
            if (n2 >= generalClasification[n]) continue;
            n2 = generalClasification[n];
        }
        for (n = 0; n < generalClasification.length; ++n) {
            if (n3 >= generalClasification[n] || generalClasification[n] == n2) continue;
            n3 = generalClasification[n];
        }
        for (n = 0; n < generalClasification.length; ++n) {
            if (n4 >= generalClasification[n] || generalClasification[n] == n2 || generalClasification[n] == n3) continue;
            n4 = generalClasification[n];
        }
        if (n2 == generalClasification[0]) {
            return 0;
        }
        if (n3 == generalClasification[0]) {
            return 1;
        }
        if (n4 == generalClasification[0]) {
            return 2;
        }
        return 3;
    }

    public static void UnlockAllCars() {
        for (int i = 0; i < availableKarts.length; ++i) {
            CGUserCareer.availableKarts[i] = true;
        }
    }

    public static void unlockCar() {
        switch (availableDifficultyLevel) {
            case 0: {
                CGUserCareer.availableKarts[2] = true;
                CGUserCareer.availableKarts[1] = true;
                CGUserCareer.availableKarts[0] = true;
                break;
            }
            case 1: {
                CGUserCareer.availableKarts[3] = true;
                CGUserCareer.availableKarts[2] = true;
                CGUserCareer.availableKarts[1] = true;
                CGUserCareer.availableKarts[0] = true;
                break;
            }
            case 2: {
                CGUserCareer.availableKarts[4] = true;
                CGUserCareer.availableKarts[3] = true;
                CGUserCareer.availableKarts[2] = true;
                CGUserCareer.availableKarts[1] = true;
                CGUserCareer.availableKarts[0] = true;
                break;
            }
            default: {
                CGUserCareer.availableKarts[2] = true;
                CGUserCareer.availableKarts[1] = true;
                CGUserCareer.availableKarts[0] = true;
            }
        }
    }

    public static void Reset() {
        int n;
        m_nPoints = 0;
        m_nFamePoints = 0;
        if (CGUserCareer.isAnyGameStored()) {
            m_nRaceID = -1;
        }
        if (!CGUserCareer.isAnyGameStored()) {
            for (n = 0; n < 9; ++n) {
                CGUserCareer.tracksUnlocked[n] = false;
            }
            CGUserCareer.tracksUnlocked[0] = true;
            for (n = 1; n < tracksUnlocked.length; ++n) {
                CGUserCareer.tracksUnlocked[n] = false;
            }
            for (n = 0; n < tracksTime.length; ++n) {
                CGUserCareer.tracksTime[n] = Integer.MAX_VALUE;
            }
            currentKart = 0;
            m_szNick = "";
            m_szDevicePlatform = "";
            CGUserCareer.playerKarts[0] = new CareerKart(2048L, 2048L, 0, 0, 1, 2, 3);
            CGUserCareer.playerKarts[1] = new CareerKart(2060L, 2060L, 1, 0, 1, 2, 3);
            CGUserCareer.playerKarts[2] = new CareerKart(2072L, 2072L, 0, 0, 1, 2, 3);
            CGUserCareer.playerKarts[3] = new CareerKart(2084L, 2084L, 0, 0, 1, 2, 3);
            CGUserCareer.playerKarts[4] = new CareerKart(2096L, 2096L, 1, 0, 1, 2, 3);
            CGUserCareer.playerKarts[5] = new CareerKart(2108L, 2108L, 0, 0, 1, 2, 3);
        }
        for (n = 0; n < 6; ++n) {
            CGUserCareer.generalClasification[n] = 0;
        }
    }

    public static void NextEventReset() {
        System.out.println("NextEventReset()");
        m_nPoints = 0;
        m_nFamePoints = 0;
        if (CGUserCareer.isAnyGameStored()) {
            m_nRaceID = -1;
        }
        if (!CGUserCareer.isAnyGameStored()) {
            m_szDevicePlatform = "";
            CGUserCareer.playerKarts[0] = new CareerKart(2048L, 2048L, 0, 0, 1, 2, 3);
            CGUserCareer.playerKarts[1] = new CareerKart(2060L, 2060L, 1, 0, 1, 2, 3);
            CGUserCareer.playerKarts[2] = new CareerKart(2072L, 2072L, 0, 0, 1, 2, 3);
            CGUserCareer.playerKarts[3] = new CareerKart(2084L, 2084L, 0, 0, 1, 2, 3);
            CGUserCareer.playerKarts[4] = new CareerKart(2096L, 2096L, 1, 0, 1, 2, 3);
            CGUserCareer.playerKarts[5] = new CareerKart(2108L, 2108L, 0, 0, 1, 2, 3);
        }
        for (int i = 0; i < 6; ++i) {
            CGUserCareer.generalClasification[i] = 0;
        }
    }

    public static void ResetCareer() {
        int n;
        m_nPoints = 0;
        m_nFamePoints = 0;
        if (CGUserCareer.isAnyGameStored()) {
            m_nRaceID = -1;
        }
        if (!CGUserCareer.isAnyGameStored()) {
            for (n = 0; n < 9; ++n) {
                System.out.println("Unlock, reset to false:" + n);
                CGUserCareer.tracksUnlocked[n] = false;
            }
            CGUserCareer.tracksUnlocked[0] = true;
            for (n = 1; n < tracksUnlocked.length; ++n) {
                CGUserCareer.tracksUnlocked[n] = true;
            }
            m_szNick = "";
            m_szDevicePlatform = "";
            CGUserCareer.playerKarts[0] = new CareerKart(2048L, 2048L, 0, 0, 1, 2, 3);
            CGUserCareer.playerKarts[1] = new CareerKart(2060L, 2060L, 1, 0, 1, 2, 3);
            CGUserCareer.playerKarts[2] = new CareerKart(2072L, 2072L, 0, 0, 1, 2, 3);
            CGUserCareer.playerKarts[3] = new CareerKart(2084L, 2084L, 0, 0, 1, 2, 3);
            CGUserCareer.playerKarts[4] = new CareerKart(2096L, 2096L, 1, 0, 1, 2, 3);
            CGUserCareer.playerKarts[5] = new CareerKart(2108L, 2108L, 0, 0, 1, 2, 3);
        }
        for (n = 0; n < 6; ++n) {
            CGUserCareer.generalClasification[n] = 0;
        }
    }

    public static void ResetAllNewChamp() {
        int n;
        m_nPoints = 0;
        m_nFamePoints = 0;
        m_nRaceID = -1;
        CGUserCareer.babeUnlockState[3] = 0;
        CGUserCareer.babeUnlockState[2] = 0;
        CGUserCareer.babeUnlockState[1] = 0;
        CGUserCareer.babeUnlockState[0] = 0;
        currentBabe = 0;
        m_szNick = "";
        m_szDevicePlatform = "";
        CGUserCareer.playerKarts[0] = new CareerKart(2048L, 2048L, 0, 0, 1, 2, 3);
        CGUserCareer.playerKarts[1] = new CareerKart(2060L, 2060L, 1, 0, 1, 2, 3);
        CGUserCareer.playerKarts[2] = new CareerKart(2072L, 2072L, 0, 0, 1, 2, 3);
        CGUserCareer.playerKarts[3] = new CareerKart(2084L, 2084L, 0, 0, 1, 2, 3);
        CGUserCareer.playerKarts[4] = new CareerKart(2096L, 2096L, 1, 0, 1, 2, 3);
        CGUserCareer.playerKarts[5] = new CareerKart(2108L, 2108L, 0, 0, 1, 2, 3);
        for (n = 0; n < 6; ++n) {
            CGUserCareer.generalClasification[n] = 0;
        }
        for (n = 1; n < avalaibleEvents.length; ++n) {
            CGUserCareer.avalaibleEvents[n] = false;
        }
    }

    public static void ResetAll() {
        int n;
        m_nPoints = 0;
        m_nFamePoints = 0;
        m_nRaceID = -1;
        TrophyStatistic.allPoints = 0;
        TrophyStatistic.raceFinished = 0;
        CGUserCareer.resetRacesWon();
        for (n = 0; n < 9; ++n) {
            CGUserCareer.tracksUnlocked[n] = false;
        }
        CGUserCareer.tracksUnlocked[0] = true;
        CGUserCareer.babeUnlockState[3] = 0;
        CGUserCareer.babeUnlockState[2] = 0;
        CGUserCareer.babeUnlockState[1] = 0;
        CGUserCareer.babeUnlockState[0] = 0;
        currentBabe = 0;
        CGUserCareer.availableKarts[0] = true;
        CGUserCareer.availableKarts[1] = true;
        CGUserCareer.availableKarts[2] = true;
        CGUserCareer.availableKarts[3] = false;
        for (n = 4; n < availableKarts.length; ++n) {
            CGUserCareer.availableKarts[n] = false;
        }
        for (n = 0; n < tracksTime.length; ++n) {
            CGUserCareer.tracksTime[n] = Integer.MAX_VALUE;
        }
        currentKart = 0;
        m_szNick = "";
        m_szDevicePlatform = "";
        CGUserCareer.playerKarts[0] = new CareerKart(2048L, 2048L, 0, 0, 1, 2, 3);
        CGUserCareer.playerKarts[1] = new CareerKart(2060L, 2060L, 1, 0, 1, 2, 3);
        CGUserCareer.playerKarts[2] = new CareerKart(2072L, 2072L, 0, 0, 1, 2, 3);
        CGUserCareer.playerKarts[3] = new CareerKart(2084L, 2084L, 0, 0, 1, 2, 3);
        CGUserCareer.playerKarts[4] = new CareerKart(2096L, 2096L, 1, 0, 1, 2, 3);
        CGUserCareer.playerKarts[5] = new CareerKart(2108L, 2108L, 0, 0, 1, 2, 3);
        for (n = 0; n < 6; ++n) {
            CGUserCareer.generalClasification[n] = 0;
        }
        for (n = 1; n < avalaibleEvents.length; ++n) {
            CGUserCareer.avalaibleEvents[n] = false;
        }
    }

    public static void Load() {
        CGUserCareer.Reset();
        BGStore bGStore = BGStore.openStoreToRead("UserCareer");
        if (bGStore == null) {
            return;
        }
        try {
            DataInputStream dataInputStream = bGStore.getInStream();
            if (dataInputStream != null && dataInputStream.available() > 0) {
                int n;
                for (n = 0; n < EventScreen.eventsNames.length; ++n) {
                    EventScreen.medalEvents[n] = dataInputStream.readInt();
                }
                for (n = 1; n < avalaibleEvents.length; ++n) {
                    CGUserCareer.avalaibleEvents[n] = dataInputStream.readBoolean();
                }
                availableDifficultyLevel = dataInputStream.readInt();
                difficultyLevel = dataInputStream.readInt();
                m_nRaceID = dataInputStream.readInt();
                m_nPoints = dataInputStream.readInt();
                m_nFamePoints = dataInputStream.readInt();
                for (n = 0; n < 9; ++n) {
                    CGUserCareer.tracksUnlocked[n] = dataInputStream.readBoolean();
                }
                for (n = 0; n < availableKarts.length; ++n) {
                    CGUserCareer.availableKarts[n] = dataInputStream.readBoolean();
                }
                for (n = 0; n < tracksTime.length; ++n) {
                    CGUserCareer.tracksTime[n] = dataInputStream.readInt();
                }
                currentKart = dataInputStream.readInt();
                CareerScreen.nextEvent = dataInputStream.readInt();
                m_szNick = dataInputStream.readUTF();
                m_szDevicePlatform = dataInputStream.readUTF();
                EditChampionshipsUserName.playerNick = dataInputStream.readUTF();
                for (n = 0; n < 3; ++n) {
                    playerKarts[n].deSerialize(dataInputStream);
                }
                for (n = 0; n < 6; ++n) {
                    CGUserCareer.generalClasification[n] = dataInputStream.readInt();
                }
                racesWon = dataInputStream.readInt();
                TrophyStatistic.allPoints = dataInputStream.readInt();
                TrophyStatistic.raceFinished = dataInputStream.readInt();
            }
            bGStore.close();
        }
        catch (Exception exception) {
            System.out.println("============================================================================================================================Career not loaded");
            CGUserCareer.Reset();
            return;
        }
    }

    public static void Save() {
        BGStore bGStore = BGStore.openStoreToWrite("UserCareer");
        if (bGStore == null) {
            return;
        }
        try {
            int n;
            DataOutputStream dataOutputStream = bGStore.getOutStream();
            for (n = 0; n < EventScreen.medalEvents.length; ++n) {
                dataOutputStream.writeInt(EventScreen.medalEvents[n]);
            }
            for (n = 1; n < avalaibleEvents.length; ++n) {
                dataOutputStream.writeBoolean(avalaibleEvents[n]);
            }
            dataOutputStream.writeInt(availableDifficultyLevel);
            dataOutputStream.writeInt(difficultyLevel);
            dataOutputStream.writeInt(m_nRaceID);
            dataOutputStream.writeInt(m_nPoints);
            dataOutputStream.writeInt(m_nFamePoints);
            for (n = 0; n < 9; ++n) {
                dataOutputStream.writeBoolean(tracksUnlocked[n]);
            }
            for (n = 0; n < availableKarts.length; ++n) {
                dataOutputStream.writeBoolean(availableKarts[n]);
            }
            for (n = 0; n < tracksTime.length; ++n) {
                dataOutputStream.writeInt(tracksTime[n]);
            }
            dataOutputStream.writeInt(currentKart);
            dataOutputStream.writeInt(CareerScreen.nextEvent);
            dataOutputStream.writeUTF(m_szNick);
            dataOutputStream.writeUTF(m_szDevicePlatform);
            dataOutputStream.writeUTF(EditChampionshipsUserName.playerNick);
            for (n = 0; n < 3; ++n) {
                playerKarts[n].serialize(dataOutputStream);
            }
            for (n = 0; n < 6; ++n) {
                dataOutputStream.writeInt(generalClasification[n]);
            }
            dataOutputStream.writeInt(racesWon);
            dataOutputStream.writeInt(TrophyStatistic.allPoints);
            dataOutputStream.writeInt(TrophyStatistic.raceFinished);
            bGStore.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static int getEventFromRaceID(int n) {
        return eventIDtoCityID[n];
    }

    public static int getCityFromRaceID(int n) {
        try {
            return raceIDtoCityID[n];
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    public static void unlockBabe(int n, int n2) {
        CGUserCareer.babeUnlockState[n] = n2;
    }

    public static boolean isKartAvailable(int n) {
        return availableKarts[n];
    }

    public static void unlockKart(int n) {
        CGUserCareer.availableKarts[n] = true;
    }

    public static boolean isAnyGameStored() {
        return m_nRaceID >= 0;
    }

    public static int GetPoints() {
        return m_nPoints;
    }

    public static void AddPoints(int n) {
        m_nPoints += n;
    }

    public static int GetFamePoints() {
        return m_nFamePoints;
    }

    public static void AddFamePoints(int n) {
        if ((m_nFamePoints += n) < 0) {
            m_nFamePoints = 0;
        }
    }

    public static void SetRaceID(int n) {
        m_nRaceID = n;
    }

    public static int GetRaceID() {
        return m_nRaceID;
    }

    public static void SetNick(String string) {
        m_szNick = string;
    }

    public static String GetNick() {
        return m_szNick;
    }

    public static void SetDevicePlatform(String string) {
        m_szDevicePlatform = string;
    }

    public static String GetDevicePlatform() {
        return m_szDevicePlatform;
    }

    public static int getRacesWon() {
        return racesWon;
    }

    public static void resetRacesWon() {
        racesWon = 0;
    }

    public static void setRacesWon() {
        ++racesWon;
    }

    static {
        m_nRaceID = -1;
        currentBabe = 0;
        currentKart = 0;
        m_nFamePoints = 0;
        racesWon = 0;
    }
}

