/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.project_gameplay.ListInt;
import baltorogames.system.Options;
import java.util.Vector;

public class AchievementPopup {
    private static Vector infoList = new Vector();
    private static long startTime = 0L;
    private static int m_xpos;
    private static int m_ypos;
    private static int m_width;
    private static int m_height;
    private static CGTexture backTexture;
    private static String text;
    private static String textHeader;

    public static void Init() {
        startTime = 0L;
    }

    public static boolean IsEnabled() {
        return startTime > 0L;
    }

    public static void Step() {
        if (startTime > 0L) {
            long l = ApplicationData.getAppTime() - startTime;
            if (l > 2000L) {
                if (infoList.size() > 0) {
                    int n = ((ListInt)AchievementPopup.infoList.elementAt((int)0)).nValue;
                    infoList.removeElementAt(0);
                    AchievementPopup.NewAchievementInfoInternal(n);
                } else {
                    startTime = 0L;
                }
            } else {
                AchievementPopup.Render(l);
            }
        }
    }

    public static void NewAchievement(int n) {
        if (startTime > 0L) {
            ListInt listInt = new ListInt();
            listInt.nValue = n;
            infoList.addElement(listInt);
        } else {
            AchievementPopup.NewAchievementInfoInternal(n);
        }
    }

    private static void NewAchievementInfoInternal(int n) {
        startTime = ApplicationData.getAppTime();
        if (n < 100) {
            textHeader = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_NEW_ACHI");
            text = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_ACHIEVEMENT_HEADER_" + n);
        } else {
            textHeader = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_POPUP_NEW_SURVIVAL_MAP");
            text = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_POPUP_NEW_SURVIVAL_MAP_AVAILABLE");
        }
    }

    private static void Render(long l) {
        long l2 = 0L;
        if (l <= 300L) {
            l2 = 4096L * l / 300L;
        } else if (l <= 1500L) {
            l2 = 4096L;
        } else if (l <= 1800L) {
            l2 = 4096L - (4096L * l - 1500L) / 300L;
        } else if (l <= 2000L) {
            l2 = 0L;
        }
        if (l2 == 4096L) {
            int n = ApplicationData.screenHeight;
            Graphic2D.DrawImage(backTexture, ApplicationData.screenWidth / 2, n, 33);
            Utils.drawString(textHeader, ApplicationData.screenWidth / 2, n -= backTexture.GetHeight(), 17, 0);
            Utils.drawString(text, ApplicationData.screenWidth / 2, n += ApplicationData.defaultFont.getFontHeight(), 17, 0);
        }
    }

    static {
        backTexture = null;
        text = new String();
        textHeader = new String();
    }
}

