/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.graphic2d;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.TextureManager;
import baltorogames.system.Application;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Graphic2D {
    public static final int HCENTER = 1;
    public static final int VCENTER = 2;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    public static final int TOP = 16;
    public static final int BOTTOM = 32;
    public static final int TRANS_NONE = 0;
    public static final int TRANS_ROT180 = 3;
    public static final int TRANS_ROT270 = 6;
    public static final int TRANS_MIRROR = 2;
    public static final int TRANS_MIRROR_ROT90 = 7;
    public static final int TRANS_MIRROR_ROT180 = 1;
    public static final int TRANS_MIRROR_ROT270 = 4;
    public static final int VMIRROR = 1;
    public static final int HMIRROR = 2;
    private static Graphics m_drawContext = null;
    private static int m_nClipX;
    private static int m_nClipY;
    private static int m_nClipW;
    private static int m_nClipH;

    public static void SetDrawContext(Graphics graphics) {
        m_drawContext = graphics;
    }

    public static Graphics GetDrawContext() {
        return m_drawContext;
    }

    public static void FlushGraphics() {
        Application.gameCanvas.FlushGraphics();
    }

    public static void DrawDebugString(String string, int n, int n2, int n3) {
        m_drawContext.drawString(string, n, n2, n3);
    }

    public static void ClearScreen(int n) {
        m_drawContext.setColor(n);
        m_drawContext.fillRect(0, 0, ApplicationData.screenWidth, ApplicationData.screenHeight);
    }

    public static void SetColor(int n) {
        m_drawContext.setColor(n);
    }

    public static void FillRect(int n, int n2, int n3, int n4) {
        m_drawContext.fillRect(n, n2, n3, n4);
    }

    public static void FillRect(int n, int n2, int n3, int n4, int n5) {
        m_drawContext.setColor(n);
        m_drawContext.fillRect(n2, n3, n4, n5);
    }

    public static void DrawLine(int n, int n2, int n3, int n4) {
        m_drawContext.drawLine(n, n2, n3, n4);
    }

    public static void DrawLine(int n, int n2, int n3, int n4, int n5) {
        m_drawContext.setColor(n);
        m_drawContext.drawLine(n2, n3, n4, n5);
    }

    public static void SetClip(int n, int n2, int n3, int n4) {
        m_nClipX = n;
        m_nClipY = n2;
        m_nClipW = n3;
        m_nClipH = n4;
        m_drawContext.setClip(n, n2, n3, n4);
    }

    public static void ClipRect(int n, int n2, int n3, int n4) {
        m_nClipX = n;
        m_nClipY = n2;
        m_nClipW = n3;
        m_nClipH = n4;
        m_drawContext.clipRect(n, n2, n3, n4);
    }

    public static int GetClipX() {
        return m_nClipX;
    }

    public static int GetClipY() {
        return m_nClipY;
    }

    public static int GetClipWidth() {
        return m_nClipW;
    }

    public static int GetClipHeight() {
        return m_nClipH;
    }

    public static void Draw(CGTexture cGTexture, int n, int n2, int n3) {
        if (Utils.isPointInRect(n, n2, 0, 0, ApplicationData.screenWidth, ApplicationData.screenHeight)) {
            m_drawContext.drawRegion(cGTexture.m_Image, 0, 0, cGTexture.m_Image.getWidth(), cGTexture.m_Image.getHeight(), n3, n, n2, 0);
        } else if (Utils.isPointInRect(n + cGTexture.GetWidth(), n2, 0, 0, ApplicationData.screenWidth, ApplicationData.screenHeight)) {
            m_drawContext.drawRegion(cGTexture.m_Image, 0, 0, cGTexture.m_Image.getWidth(), cGTexture.m_Image.getHeight(), n3, n, n2, 0);
        } else if (Utils.isPointInRect(n, n2 + cGTexture.GetHeight(), 0, 0, ApplicationData.screenWidth, ApplicationData.screenHeight)) {
            m_drawContext.drawRegion(cGTexture.m_Image, 0, 0, cGTexture.m_Image.getWidth(), cGTexture.m_Image.getHeight(), n3, n, n2, 0);
        } else if (Utils.isPointInRect(n + cGTexture.GetWidth(), n2 + cGTexture.GetHeight(), 0, 0, ApplicationData.screenWidth, ApplicationData.screenHeight)) {
            m_drawContext.drawRegion(cGTexture.m_Image, 0, 0, cGTexture.m_Image.getWidth(), cGTexture.m_Image.getHeight(), n3, n, n2, 0);
        }
    }

    public static void DrawCenter(CGTexture cGTexture, int n, int n2) {
        m_drawContext.drawImage(cGTexture.m_Image, n - cGTexture.m_Image.getWidth() / 2, n2 - cGTexture.m_Image.getHeight() / 2, 0);
    }

    public static void DrawCenterRotate(CGTexture cGTexture, int n, int n2) {
        m_drawContext.drawRegion(cGTexture.m_Image, 0, 0, cGTexture.m_Image.getWidth(), cGTexture.m_Image.getHeight(), 4, n, n2, 3);
    }

    public static void DrawR(CGTexture cGTexture, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        m_drawContext.drawRegion(cGTexture.m_Image, n, n2, n3 - n, n4 - n2, n7, n5, n6, 20);
    }

    public static void DrawImage(CGTexture cGTexture, int n, int n2, int n3) {
        m_drawContext.drawImage(cGTexture.m_Image, n, n2, n3);
    }

    public static void DrawImage(Image image, int n, int n2, int n3) {
        m_drawContext.drawImage(image, n, n2, n3);
    }

    public static void DrawRegion(CGTexture cGTexture, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        m_drawContext.drawRegion(cGTexture.m_Image, n, n2, n3, n4, n5, n6, n7, n8);
    }

    public static void DrawRegion(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        m_drawContext.drawRegion(image, n, n2, n3, n4, n5, n6, n7, n8);
    }

    public static CGTexture[] splitPanoramaImage(String string, int n, int n2) {
        CGTexture cGTexture = TextureManager.AddTexture(string);
        try {
            CGTexture[] cGTextureArray = Graphic2D.splitPanoramaImage(cGTexture, n, n2);
            TextureManager.DeleteTexture(cGTexture);
            return cGTextureArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Image ScaleImage(Image image, int n, int n2) {
        return Graphic2D.scaleImageNoAlpha(image, n, n2, true);
    }

    public static CGTexture[] splitPanoramaImage(CGTexture cGTexture, int n, int n2) {
        if (cGTexture == null) {
            return null;
        }
        CGTexture[] cGTextureArray = new CGTexture[n2 * n];
        int n3 = cGTexture.m_Image.getWidth() / n;
        int n4 = cGTexture.m_Image.getHeight() / n2;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                Image image = Image.createImage((Image)cGTexture.m_Image, (int)(j * n3), (int)(i * n4), (int)n3, (int)n4, (int)0);
                cGTextureArray[j + i * n] = new CGTexture();
                cGTextureArray[j + i * n].SetImage(image);
                cGTextureArray[j + i * n].SetName("");
            }
        }
        return cGTextureArray;
    }

    private static void Bilinear_Interpolate_NoAlpha(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4) {
        long l = 4096 * n / n3;
        long l2 = 4096 * n2 / n4;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                long l3 = (long)i * l;
                long l4 = (long)j * l2;
                long l5 = l3 / 4096L * 4096L;
                long l6 = l4 / 4096L * 4096L;
                long l7 = l3 - l5;
                long l8 = l4 - l6;
                long l9 = 4096L - l7;
                long l10 = 4096L - l8;
                long l11 = l5 + 4096L >= (long)(4096 * n) ? l5 : l5 + 1L;
                long l12 = l6 + 4096L >= (long)(4096 * n2) ? l6 : l6 + 1L;
                long l13 = nArray[(int)((l5 + l6 * (long)n) / 4096L)] & 0xFF;
                long l14 = (nArray[(int)((l5 + l6 * (long)n) / 4096L)] & 0xFF00) >> 8;
                long l15 = (nArray[(int)((l5 + l6 * (long)n) / 4096L)] & 0xFF0000) >> 16;
                long l16 = (nArray[(int)((l5 + l6 * (long)n) / 4096L)] & 0xFF000000) >> 24;
                long l17 = nArray[(int)(l11 + l6 * (long)n) / 4096] & 0xFF;
                long l18 = (nArray[(int)(l11 + l6 * (long)n) / 4096] & 0xFF00) >> 8;
                long l19 = (nArray[(int)(l11 + l6 * (long)n) / 4096] & 0xFF0000) >> 16;
                long l20 = nArray[(int)(l11 + l12 * (long)n) / 4096] & 0xFF;
                long l21 = (nArray[(int)(l11 + l12 * (long)n) / 4096] & 0xFF00) >> 8;
                long l22 = (nArray[(int)(l11 + l12 * (long)n) / 4096] & 0xFF0000) >> 16;
                long l23 = nArray[(int)(l5 + l12 * (long)n) / 4096] & 0xFF;
                long l24 = (nArray[(int)(l5 + l12 * (long)n) / 4096] & 0xFF00) >> 8;
                long l25 = (nArray[(int)(l5 + l12 * (long)n) / 4096] & 0xFF0000) >> 16;
                int n5 = (int)(((l13 * l9 + l17 * l7) / 4096L * l10 + (l23 * l9 + l20 * l7) / 4096L * l8) / 4096L);
                int n6 = (int)(((l14 * l9 + l18 * l7) / 4096L * l10 + (l24 * l9 + l21 * l7) / 4096L * l8) / 4096L);
                int n7 = (int)(((l15 * l9 + l19 * l7) / 4096L * l10 + (l25 * l9 + l22 * l7) / 4096L * l8) / 4096L);
                int n8 = (int)l16;
                nArray2[i + j * n3] = n5 + (n6 << 8) + (n7 << 16) + (n8 << 24);
            }
        }
    }

    public static Image scaleImageNoAlpha(Image image, int n, int n2, boolean bl) {
        int[] nArray = new int[n * n2];
        int[] nArray2 = new int[image.getWidth() * image.getHeight()];
        if (image.getWidth() == n && image.getHeight() == n2) {
            return image;
        }
        try {
            image.getRGB(nArray2, 0, image.getWidth(), 0, 0, image.getWidth(), image.getHeight());
        }
        catch (Exception exception) {
            return null;
        }
        Graphic2D.Bilinear_Interpolate_NoAlpha(nArray2, nArray, image.getWidth(), image.getHeight(), n, n2);
        return Image.createRGBImage((int[])nArray, (int)n, (int)n2, (boolean)bl);
    }
}

