/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.core_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core_gui.UIAnimatedButtonV;
import baltorogames.core_gui.UIButton;
import baltorogames.core_gui.UIResultTableButton;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.system.ObjectsCache;
import java.util.Vector;

public abstract class UIResultListButtonAnimated
extends UIScreen {
    private final int UP_ARROW_ID;
    private final int DOWN_ARROW_ID;
    public static final int START_ITEM_ID = 1000;
    public Vector items = new Vector();
    private int wndStartIndex = 0;
    private int wndEndIndex = 0;
    protected boolean enableSelection = true;
    protected int currentItem = 0;
    protected int elementsOnScreen = 0;
    protected int spacing = ObjectsCache.resultScreenButton.GetHeight();

    public UIResultListButtonAnimated() {
        this.UP_ARROW_ID = 100;
        this.DOWN_ARROW_ID = 101;
        this.showScrollbars = false;
        this.clientAreaHeight = this.height;
        this.wndStartIndex = 0;
        this.currentItem = 0;
        this.elementsOnScreen = this.wndEndIndex = this.clientAreaHeight / this.spacing;
        this.AddArrows();
    }

    protected void moveUp() {
        int n = 1;
        if (this.currentItem > 0) {
            int n2 = this.currentItem;
            this.currentItem -= n;
            this.currentItemChanged(n2, this.currentItem);
            if (this.currentItem < this.wndStartIndex) {
                this.wndStartIndex -= n;
                this.wndEndIndex -= n;
                if (this.wndStartIndex < 0) {
                    this.wndEndIndex += -1 * this.wndStartIndex;
                    this.wndStartIndex = 0;
                }
            }
        } else {
            int n3 = this.items.size();
            this.currentItem = n3 - 1;
            this.wndEndIndex = this.currentItem + 1;
            this.wndStartIndex = this.wndEndIndex - this.elementsOnScreen;
            if (this.wndStartIndex < 0) {
                this.wndStartIndex = 0;
                this.wndEndIndex = this.elementsOnScreen;
            }
        }
    }

    public void moveDown() {
        int n = 1;
        int n2 = this.items.size();
        if (this.currentItem < n2 - 1) {
            int n3 = this.currentItem;
            this.currentItem += n;
            this.currentItemChanged(n3, this.currentItem);
            if (this.currentItem >= this.wndEndIndex) {
                this.wndStartIndex += n;
                this.wndEndIndex += n;
            }
        } else {
            this.wndStartIndex = 0;
            this.currentItem = 0;
            this.wndEndIndex = this.elementsOnScreen;
        }
    }

    public void draw() {
    }

    public void onUpdate(int n) {
        super.onUpdate(n);
        this.ActualizeList();
        this.UnvisibleAll();
        int n2 = 30;
        int n3 = this.clientAreaHeight - this.items.size() * n2;
        if (n3 < 0) {
            n3 = this.clientAreaHeight - (this.wndEndIndex - this.wndStartIndex) * n2;
            n3 /= 2;
        } else {
            n3 /= 2;
        }
        for (int i = this.wndStartIndex; i < this.wndEndIndex && i < this.items.size(); ++i) {
            int n4 = n3 + (this.positionY + this.clientAreaY) + (i - this.wndStartIndex) * n2;
            UIResultTableButton uIResultTableButton = (UIResultTableButton)this.items.elementAt(i);
            uIResultTableButton.setVisible(true);
            uIResultTableButton.setTop(n4);
        }
        if (this.wndStartIndex == 0) {
            this.findByID(100).setVisible(false);
        } else {
            this.findByID(100).setVisible(true);
        }
        if (this.wndEndIndex >= this.items.size()) {
            this.findByID(101).setVisible(false);
        } else {
            this.findByID(101).setVisible(true);
        }
    }

    protected void UnvisibleAll() {
        int n = this.items.size();
        for (int i = 0; i < n; ++i) {
            ((UIResultTableButton)this.items.elementAt(i)).setVisible(false);
        }
    }

    public void setInitPos() {
        if (this.findByID(100) != null) {
            this.findByID(100).setVisible(false);
        }
        if (this.findByID(101) != null) {
            this.findByID(101).setVisible(false);
        }
        switch (UIResultTableButton.typeOfAnimation) {
            case 1: {
                int n = 0;
                if (this.findByID(1000) != null) {
                    n -= this.findByID((int)1000).textures[0].GetWidth();
                }
                for (int i = 0; i < this.items.size(); ++i) {
                    if (this.findByID(1000 + i) == null) continue;
                    this.findByID(1000 + i).setInitLeft(n - i * 2 * ApplicationData.screenWidth / 10);
                }
                break;
            }
            case 0: {
                int n = ApplicationData.screenWidth / 2;
                if (this.findByID(1000) != null) {
                    n += ObjectsCache.resultScreenButton.GetWidth() / 2;
                }
                for (int i = 0; i < this.items.size(); ++i) {
                    if (this.findByID(1000 + i) == null) continue;
                    this.findByID(1000 + i).setInitLeft(n + i * 2 * ApplicationData.screenWidth / 10);
                }
                break;
            }
        }
    }

    public void autoSize() {
        this.clientAreaX = 0;
        this.clientAreaWidth = this.width;
        this.clientAreaY = 0;
        this.clientAreaHeight = this.height;
    }

    public boolean leftSoftButton() {
        return false;
    }

    public boolean rightSoftButton() {
        return false;
    }

    public abstract void currentItemChanged(int var1, int var2);

    public abstract void currentItemSelected(int var1);

    public void clearList() {
        this.items.removeAllElements();
        this.removeButtons(1000);
    }

    public void append(String string, String string2, String string3, String string4, CGTexture cGTexture, int n, boolean bl) {
        int n2 = this.items.size() + 1000;
        cGTexture = ObjectsCache.resultScreenButton;
        int n3 = 0;
        if (cGTexture != null) {
            n3 = ApplicationData.screenWidth - cGTexture.GetWidth() - cGTexture.GetWidth() / 15;
        }
        UIResultTableButton uIResultTableButton = new UIResultTableButton(n3, 0, cGTexture, n, n2);
        uIResultTableButton.setPosition(string);
        uIResultTableButton.setRiderName(string2);
        uIResultTableButton.setTime(string3);
        uIResultTableButton.setPoints(string4);
        uIResultTableButton.setFontID(0);
        uIResultTableButton.setBlink(bl);
        this.addButton(uIResultTableButton);
        this.items.addElement(uIResultTableButton);
    }

    public void append(String string, int n) {
        int n2 = this.items.size() + 1000;
        int n3 = ApplicationData.screenWidth / 2 - ObjectsCache.resultScreenButton.GetWidth() / 2;
        UIResultTableButton uIResultTableButton = new UIResultTableButton(n3, 0, ObjectsCache.resultScreenButton, -1, n2);
        uIResultTableButton.setButtonCaption(string);
        uIResultTableButton.setButtonValue(n);
        this.addButton(uIResultTableButton);
        this.items.addElement(uIResultTableButton);
    }

    public boolean actionSoftButton(int n, boolean bl) {
        if (bl) {
            UIButton uIButton = this.findByID(n);
            this.unselectAllButtons();
            uIButton.setSelect(true);
            if (n >= 1000) {
                this.currentItem = n - 1000;
            }
            return true;
        }
        if (n == 100) {
            this.onUpAction();
            return true;
        }
        if (n == 101) {
            this.onDownAction();
            return true;
        }
        return false;
    }

    public boolean selectUpAction() {
        UIButton uIButton = this.findByID(100);
        if (uIButton != null) {
            uIButton.setSelect(true);
        }
        return true;
    }

    public boolean selectDownAction() {
        UIButton uIButton = this.findByID(101);
        if (uIButton != null) {
            uIButton.setSelect(true);
        }
        return true;
    }

    public boolean onUpAction() {
        if (this.enableSelection) {
            this.moveUp();
        }
        return true;
    }

    public boolean onDownAction() {
        if (this.enableSelection) {
            this.moveDown();
        }
        return true;
    }

    public boolean onFireAction() {
        if (this.enableSelection && this.currentItem != -1) {
            this.currentItemSelected(this.currentItem);
        }
        return true;
    }

    public void ActualizeList() {
        this.uncheckAllButtons();
        UIButton uIButton = this.findByID(1000 + this.currentItem);
        if (uIButton != null) {
            uIButton.setCheck(true);
        }
    }

    protected void AddArrows() {
        int n = 30;
        int n2 = this.clientAreaHeight - this.items.size() * n;
        if (n2 < 0) {
            n2 = this.clientAreaHeight - (this.wndEndIndex - this.wndStartIndex) * n;
            n2 /= 2;
        } else {
            n2 /= 2;
        }
        int n3 = this.positionY - n / 2 - n / 10;
        int n4 = this.positionY + this.height - n / 2 + n / 10;
        int n5 = ApplicationData.screenWidth / 2 - ObjectsCache.arrowUp.GetWidth() / 2;
        int n6 = n3;
        UIAnimatedButtonV uIAnimatedButtonV = new UIAnimatedButtonV(n5, n6, ObjectsCache.arrowUp, ObjectsCache.arrowUp_a, 100);
        uIAnimatedButtonV.setScreen(this);
        uIAnimatedButtonV.setAnimDir(1);
        this.addButton(uIAnimatedButtonV);
        uIAnimatedButtonV.setVisible(true);
        n6 = n4;
        UIAnimatedButtonV uIAnimatedButtonV2 = new UIAnimatedButtonV(n5, n6, ObjectsCache.arrowDown, ObjectsCache.arrowDown_a, 101);
        uIAnimatedButtonV2.setScreen(this);
        uIAnimatedButtonV2.setAnimDir(-1);
        this.addButton(uIAnimatedButtonV2);
        uIAnimatedButtonV2.setVisible(true);
    }
}

