/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.core_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIAnimatedButtonV;
import baltorogames.core_gui.UIButton;
import baltorogames.core_gui.UIListColumn;
import baltorogames.core_gui.UIListItem;
import baltorogames.core_gui.UIListTextItem;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Platform;
import java.util.Vector;

public abstract class UIList
extends UIScreen {
    private final int UP_ARROW_ID;
    private final int DOWN_ARROW_ID;
    private static int COLUMN_SEPARATOR_WIDTH = 4;
    protected Vector columns = null;
    protected Vector headers = new Vector();
    protected int currentItem = 0;
    protected int centerMode = 1;
    protected int scrollOffset = 0;
    protected boolean scrollable = true;
    private final int SCROLL_SPEED;
    public boolean drawColumnSeparators = false;
    public boolean showHeaders = false;
    protected int fontID = 0;
    private boolean hasBackground = true;
    private int highlightListItem = -1;

    public void setHighLightIndex(int n) {
        this.highlightListItem = n;
    }

    private void AddArrows() {
        int n = this.positionY - ObjectsCache.arrowUp.GetHeight();
        int n2 = this.positionY + this.height;
        int n3 = ApplicationData.screenWidth / 2 - ObjectsCache.arrowUp.GetWidth() / 2;
        int n4 = n;
        UIAnimatedButtonV uIAnimatedButtonV = new UIAnimatedButtonV(n3, n4, ObjectsCache.arrowUp, ObjectsCache.arrowUp_a, 100);
        uIAnimatedButtonV.setScreen(this);
        uIAnimatedButtonV.setAnimDir(1);
        this.addButton(uIAnimatedButtonV);
        uIAnimatedButtonV.setVisible(false);
        n4 = n2;
        UIAnimatedButtonV uIAnimatedButtonV2 = new UIAnimatedButtonV(n3, n4, ObjectsCache.arrowDown, ObjectsCache.arrowDown_a, 101);
        uIAnimatedButtonV2.setScreen(this);
        uIAnimatedButtonV2.setAnimDir(-1);
        this.addButton(uIAnimatedButtonV2);
        uIAnimatedButtonV2.setVisible(false);
    }

    public UIList(Vector vector, int n, boolean bl) {
        this.UP_ARROW_ID = 100;
        this.DOWN_ARROW_ID = 101;
        this.SCROLL_SPEED = 1;
        this.fontID = n;
        this.hasBackground = bl;
        this.showScrollbars = true;
        this.columns = vector;
        this.setupDrawingArea();
    }

    public UIList(int n, boolean bl) {
        this.UP_ARROW_ID = 100;
        this.DOWN_ARROW_ID = 101;
        this.SCROLL_SPEED = 1;
        this.fontID = n;
        this.hasBackground = bl;
        this.showScrollbars = true;
        this.columns = new Vector();
        this.columns.addElement(new UIListColumn(100, 33));
        this.setupDrawingArea();
    }

    private void setupDrawingArea() {
        if (!this.hasBackground) {
            this.positionX = ApplicationData.screenWidth / 2 - 120;
            this.positionY = ObjectsCache.menuHeader != null ? 3 * ObjectsCache.menuHeader.GetHeight() / 4 : ApplicationData.screenHeight / 3;
            this.width = 240;
            this.height = ApplicationData.screenHeight - 4 * ObjectsCache.menuSbOK.GetHeight() / 3 - this.positionY;
        }
        this.AddArrows();
    }

    protected UIListColumn getColumn(int n) {
        return (UIListColumn)this.columns.elementAt(n);
    }

    public void onUpdate(int n) {
        UIButton uIButton;
        super.onUpdate(n);
        int n2 = this.getColumn((int)0).items.size();
        int n3 = this.height / ApplicationData.getFontByID(this.fontID).getFontHeight();
        int n4 = (1 + n2 - n3) * ApplicationData.getFontByID(this.fontID).getFontHeight();
        boolean bl = this.showScrollbars = n2 * ApplicationData.getFontByID(this.fontID).getFontHeight() > this.height;
        if (!this.showScrollbars) {
            this.currentItem = 0;
            uIButton = this.findByID(100);
            if (uIButton != null) {
                uIButton.setVisible(false);
            }
            if ((uIButton = this.findByID(101)) != null) {
                uIButton.setVisible(false);
            }
        } else {
            UIButton uIButton2;
            int n5;
            uIButton = this.findByID(100);
            if (uIButton != null) {
                uIButton.setVisible(true);
            }
            if ((n5 = this.scrollOffset / ApplicationData.getFontByID(this.fontID).getFontHeight()) <= 0) {
                uIButton.setVisible(false);
            }
            if ((uIButton2 = this.findByID(101)) != null) {
                uIButton2.setVisible(true);
            }
            if (n5 + n3 >= n2) {
                uIButton2.setVisible(false);
            }
        }
        uIButton = this.findByID(100);
        if (uIButton != null && !uIButton.isVisible && this.scrollOffset > 0) {
            uIButton.setVisible(true);
        }
        if (uIButton != null && uIButton.isActive && uIButton.isVisible && uIButton.isSelected) {
            if (this.scrollOffset > 0) {
                this.scrollOffset -= n * 1 / 10;
                if (this.scrollOffset < 0) {
                    this.scrollOffset = 0;
                }
            } else {
                uIButton.setVisible(false);
                uIButton.setSelect(false);
            }
        }
        if ((uIButton = this.findByID(101)) != null && !uIButton.isVisible && this.scrollOffset < n4) {
            uIButton.setVisible(true);
        }
        if (uIButton != null && uIButton.isActive && uIButton.isVisible && uIButton.isSelected) {
            if (this.scrollOffset < n4) {
                this.scrollOffset += n * 1 / 10;
                if (this.scrollOffset > n4) {
                    this.scrollOffset = n4;
                }
            } else {
                uIButton.setVisible(false);
                uIButton.setSelect(false);
            }
        }
    }

    public void draw() {
        int n;
        int n2;
        int n3 = ApplicationData.getFontByID(this.fontID).getFontHeight();
        int n4 = this.positionY + n3;
        int n5 = this.getColumn((int)0).items.size();
        int n6 = this.height / ApplicationData.getFontByID(this.fontID).getFontHeight();
        boolean bl = this.showScrollbars = n5 * n3 > this.height;
        if (!this.showScrollbars) {
            this.currentItem = 0;
            n2 = n5 * n3;
            n4 = this.positionY + (this.height - n2) / 2;
            UIButton uIButton = this.findByID(100);
            if (uIButton != null) {
                uIButton.setVisible(false);
            }
            if ((uIButton = this.findByID(101)) != null) {
                uIButton.setVisible(false);
            }
        } else {
            this.currentItem = this.scrollOffset / ApplicationData.getFontByID(this.fontID).getFontHeight();
        }
        if (this.hasBackground) {
            // empty if block
        }
        if (this.showHeaders) {
            n2 = this.positionX;
            for (int i = 0; i < this.columns.size(); ++i) {
                UIListColumn uIListColumn = this.getColumn(i);
                n = this.width * uIListColumn.width / 100;
                if (uIListColumn.alignment == 1) {
                    Utils.drawString((String)this.headers.elementAt(i), n2 + n / 2, n4 + Platform.TABLE_HEADER_OFFSET, 33, this.fontID);
                } else {
                    Utils.drawString((String)this.headers.elementAt(i), n2, n4 + Platform.TABLE_HEADER_OFFSET, 36, this.fontID);
                }
                n2 += n;
                n2 += COLUMN_SEPARATOR_WIDTH;
            }
        }
        Graphic2D.SetClip(this.positionX, n4, this.width, this.height - n3);
        for (n2 = 0; n2 < n5; ++n2) {
            int n7 = n2;
            int n8 = this.positionX;
            n = n4 + n2 * n3 - this.scrollOffset;
            if (n2 % 2 == 0) {
                Graphic2D.SetColor(-2619833);
                Graphic2D.FillRect(this.positionX, n, this.width, 9 * n3 / 10);
            }
            for (int i = 0; i < this.columns.size(); ++i) {
                UIListColumn uIListColumn = this.getColumn(i);
                int n9 = this.width * uIListColumn.width / 100;
                UIListItem uIListItem = (UIListItem)uIListColumn.items.elementAt(n7);
                if (uIListItem.isVisible()) {
                    uIListItem.draw(n8, n, n9, n3, uIListColumn.alignment);
                }
                n8 += n9 + COLUMN_SEPARATOR_WIDTH;
            }
        }
        Graphic2D.SetClip(0, 0, ApplicationData.screenWidth, ApplicationData.screenHeight);
    }

    public void autoSize() {
    }

    public boolean leftSoftButton() {
        return false;
    }

    public boolean rightSoftButton() {
        return false;
    }

    public void updateSize() {
    }

    public abstract void currentItemChanged(int var1, int var2);

    public abstract void currentItemSelected(int var1);

    public void clearList() {
        for (int i = 0; i < this.columns.size(); ++i) {
            this.getColumn(i).empty();
        }
    }

    public void append(String string) {
        this.append(string, null);
    }

    public void append(String string, int n) {
        this.append(string, null, n);
    }

    public void append(String string, CGTexture cGTexture) {
        this.getColumn((int)0).items.addElement(new UIListTextItem(string));
    }

    public void append(String string, CGTexture cGTexture, int n) {
        this.getColumn((int)n).items.addElement(new UIListTextItem(string));
    }

    public boolean selectUpAction() {
        UIButton uIButton = this.findByID(100);
        if (uIButton != null) {
            uIButton.setSelect(true);
        }
        return true;
    }

    public boolean onUpAction() {
        return true;
    }

    public boolean selectDownAction() {
        UIButton uIButton = this.findByID(101);
        if (uIButton != null) {
            uIButton.setSelect(true);
        }
        return true;
    }

    public boolean onDownAction() {
        return true;
    }

    public boolean onFireAction() {
        if (this.currentItem != -1) {
            this.currentItemSelected(this.currentItem);
        }
        return true;
    }

    private void drawTextBoxBackground(int n, int n2) {
    }

    public void setCenterMode(int n) {
        this.centerMode = n;
    }
}

