/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIAnimatedButtonH;
import baltorogames.core_gui.UIButton;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gui.AchievementCompleted;
import baltorogames.project_gui.ContinueOrNewChampionships;
import baltorogames.project_gui.MainUSRScreen;
import baltorogames.project_gui.UICaptionThick;
import baltorogames.system.BGStore;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;

public class OtherAchievements
extends MainUSRScreen {
    public static final int NUM_OTHER_ACHIEVEMENTS = 13;
    private final int LEFT_ARROW_ID;
    private final int RIGHT_ARROW_ID;
    public static final int MEDAL_BRONZE = 2;
    public static final int MEDAL_SILVER = 1;
    public static final int MEDAL_GOLD = 0;
    public static final int LAPS_TO_BE_EXPERIENCED_DRIVER = 50;
    private int alignStarY;
    private static String[] achievementFullDesccription = new String[]{"ACHIEVEMENTS_FULL_0", "ACHIEVEMENTS_FULL_1", "ACHIEVEMENTS_FULL_2", "ACHIEVEMENTS_FULL_3", "ACHIEVEMENTS_FULL_4", "ACHIEVEMENTS_FULL_5", "ACHIEVEMENTS_FULL_6", "ACHIEVEMENTS_FULL_7", "ACHIEVEMENTS_FULL_8", "ACHIEVEMENTS_FULL_9"};
    public static String[] achievementHeaderDescription = new String[]{"ACHIEVEMENTS_HEADER_0", "ACHIEVEMENTS_HEADER_1", "ACHIEVEMENTS_HEADER_2", "ACHIEVEMENTS_HEADER_3", "ACHIEVEMENTS_HEADER_4", "ACHIEVEMENTS_HEADER_5", "ACHIEVEMENTS_HEADER_6", "ACHIEVEMENTS_HEADER_7", "ACHIEVEMENTS_HEADER_8", "ACHIEVEMENTS_HEADER_9"};
    public static boolean[] championshipsOnly = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, true, true};
    private static boolean[] completedAchievements = new boolean[13];
    private static int[][] numMedals = new int[9][3];
    public static int numWCWon = 0;
    public static final int RACE_CHAMPION = 0;
    public static final int NO_COLLISIONS = 1;
    public static final int REAL_CHAMPION = 2;
    public static final int GOLD_TROPHY = 3;
    public static final int SILVER_TROPHY = 4;
    public static final int BRONZE_TROPHY = 5;
    public static final int UNLOCK_ALL_CARS = 6;
    public static final int WINTER_MASTER = 7;
    public static final int ALL_MEDALS = 8;
    public static final int AFRICA_MASTER = 9;
    public static final int WC_TWICE = 10;
    public static final int WC_3TIMES = 11;
    public static final int RAIN_MASTER = 12;
    public static int selectedAchievement = 0;
    private CGTexture achievementImage;
    private Vector mainText;
    int textHeight;
    private String achievementID;
    private static Vector achievementNoticesToShow = new Vector();
    private static Vector achievementHeadersToShow = new Vector();
    static int numOvertakes = 0;
    static int numLapsTotal = 0;
    public static boolean noCollisions = true;

    public boolean checkAchievementToShowExists(boolean bl, UIScreen uIScreen) {
        if (achievementNoticesToShow.size() > 0) {
            UIScreen.SetCurrentScreen(new AchievementCompleted(bl, uIScreen, (String)achievementNoticesToShow.elementAt(0), (String)achievementHeadersToShow.elementAt(0)));
            achievementNoticesToShow.removeElementAt(0);
            achievementHeadersToShow.removeElementAt(0);
            return true;
        }
        return false;
    }

    public static int getNumMedals(int n, int n2) {
        return numMedals[n][n2];
    }

    public static void addMedal(int n, int n2) {
        if (n2 >= 0 && n2 <= 2) {
            int[] nArray = numMedals[n];
            int n3 = n2;
            nArray[n3] = nArray[n3] + 1;
        }
    }

    public void wonRace() {
        if (!OtherAchievements.isCompleted(0)) {
            OtherAchievements.complete(0);
        }
    }

    public void checkAchievements() {
        int n;
        int n2;
        int n3;
        int n4;
        boolean bl = true;
        for (n4 = 0; n4 < 9; ++n4) {
            if (numMedals[n4][0] != 0) continue;
            bl = false;
            break;
        }
        if (bl) {
            OtherAchievements.complete(2);
        }
        n4 = 1;
        for (n3 = 8; n3 < 12; ++n3) {
            if (numMedals[n3][0] != 0) continue;
            n4 = 0;
        }
        n3 = 1;
        for (n2 = 0; n2 < 4; ++n2) {
            if (numMedals[n2][0] != 0) continue;
            n3 = 0;
        }
        n2 = 1;
        for (n = 8; n < 12; ++n) {
            if (numMedals[n][0] != 0) continue;
            n2 = 0;
        }
        n = 1;
        for (int i = 0; i < 12; ++i) {
            if (numMedals[i][0] != 0 && numMedals[i][1] != 0 && numMedals[i][2] != 0) continue;
            n = 0;
            break;
        }
        if (n4 == 1) {
            OtherAchievements.complete(7);
        }
        if (n2 == 1) {
            OtherAchievements.complete(9);
        }
        if (n == 1) {
            OtherAchievements.complete(8);
        }
        if (CGUserCareer.isKartAvailable(1) && CGUserCareer.isKartAvailable(2) && CGUserCareer.isKartAvailable(3)) {
            this.completeWithoutNotification(6);
        }
    }

    public OtherAchievements() {
        this.LEFT_ARROW_ID = 100;
        this.RIGHT_ARROW_ID = 101;
        this.drawLogo = false;
        this.drawCash = false;
        this.drawFP = false;
        this.drawStrip1 = true;
        this.drawStrip3 = true;
        this.setSoftButtonImage(null, null, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        this.setCaptionThick(new UICaptionThick(ApplicationData.lp.getTranslatedString(Options.languageID, "WORLD_CUP_ACHIEVEMENTS")));
        this.updateAchievementShown();
        this.strip3Y = ApplicationData.screenHeight - ObjectsCache.menuFooterImage.GetHeight() * 2 - MainUSRScreen.getStrip3Height() / 2;
        this.strip1Y = MainUSRScreen.getStrip1Height();
        this.alignStarY = (this.strip1Y + MainUSRScreen.getStrip1Height() / 2 + this.strip3Y - MainUSRScreen.getStrip3Height() / 2) / 2;
        int n = this.alignStarY - ObjectsCache.scrollLeftImg.GetHeight() / 2;
        int n2 = ApplicationData.screenWidth / 2 - ObjectsCache.achievementBackground.GetWidth();
        int n3 = ApplicationData.screenWidth / 2 + ObjectsCache.achievementBackground.GetWidth() - ObjectsCache.scrollRightImg.GetWidth();
        UIAnimatedButtonH uIAnimatedButtonH = new UIAnimatedButtonH(n3, n, ObjectsCache.scrollRightImg, ObjectsCache.scrollRightWImg, 101);
        uIAnimatedButtonH.setScreen(this);
        uIAnimatedButtonH.setAnimDir(1);
        this.addButton(uIAnimatedButtonH);
        UIAnimatedButtonH uIAnimatedButtonH2 = new UIAnimatedButtonH(n2, n, ObjectsCache.scrollLeftImg, ObjectsCache.scrollLeftWImg, 100);
        uIAnimatedButtonH2.setScreen(this);
        uIAnimatedButtonH2.setAnimDir(-1);
        this.addButton(uIAnimatedButtonH2);
    }

    public static boolean isCompleted(int n) {
        return completedAchievements[n];
    }

    public static void complete(int n) {
        if (!completedAchievements[n] && (CGEngine.selectedGameMode != 2 && !championshipsOnly[n] || CGEngine.selectedGameMode == 2)) {
            OtherAchievements.completedAchievements[n] = true;
            achievementNoticesToShow.addElement(ApplicationData.lp.getTranslatedString(Options.languageID, achievementFullDesccription[n]));
            achievementHeadersToShow.addElement(ApplicationData.lp.getTranslatedString(Options.languageID, achievementHeaderDescription[n]));
        }
    }

    public void completeWithoutNotification(int n) {
        OtherAchievements.completedAchievements[n] = true;
    }

    public static void reset() {
        completedAchievements = new boolean[13];
        numMedals = new int[9][3];
        numWCWon = 0;
    }

    public void draw() {
        Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, achievementHeaderDescription[selectedAchievement]), ApplicationData.screenWidth / 2, this.strip1Y, 3, 0);
        Graphic2D.DrawImage(ObjectsCache.achievementBackground, ApplicationData.screenWidth / 2, this.alignStarY, 3);
        if (completedAchievements[selectedAchievement]) {
            Graphic2D.DrawImage(this.achievementImage, ApplicationData.screenWidth / 2, this.alignStarY, 3);
        }
        this.drawMainText(this.strip3Y);
        Utils.drawString(this.achievementID, ApplicationData.screenWidth, this.strip1Y - MainUSRScreen.getStrip1Height() / 2, 40, 0);
        if (!completedAchievements[selectedAchievement]) {
            Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_LOCKED"), ApplicationData.screenWidth / 2, (ApplicationData.screenHeight - ObjectsCache.menuFooterImage.GetHeight() + this.strip3Y + MainUSRScreen.getStrip3Height() / 2) / 2, 3, 0);
        }
    }

    public boolean rightSoftButton() {
        UIScreen.SetCurrentScreen(new ContinueOrNewChampionships());
        return true;
    }

    public boolean selectLeftAction() {
        UIButton uIButton = this.findByID(100);
        if (uIButton != null) {
            uIButton.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean selectRightAction() {
        UIButton uIButton = this.findByID(101);
        if (uIButton != null) {
            uIButton.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean actionSoftButton(int n, boolean bl) {
        if (super.actionSoftButton(n, bl)) {
            return true;
        }
        if (!bl) {
            this.unselectAllButtons();
            if (n == 100) {
                this.onLeftAction();
                return true;
            }
            if (n == 101) {
                this.onRightAction();
                return true;
            }
        }
        return false;
    }

    public boolean onLeftAction() {
        if (--selectedAchievement < 0) {
            selectedAchievement = achievementHeaderDescription.length - 1;
        }
        this.updateAchievementShown();
        return true;
    }

    public boolean onRightAction() {
        if (++selectedAchievement >= achievementHeaderDescription.length) {
            selectedAchievement = 0;
        }
        this.updateAchievementShown();
        return true;
    }

    public boolean onFireAction() {
        return this.leftSoftButton();
    }

    private void updateAchievementShown() {
        try {
            this.mainText = Utils.splitText(ApplicationData.lp.getTranslatedString(Options.languageID, achievementFullDesccription[selectedAchievement]), "+", ApplicationData.screenWidth, 2);
            this.textHeight = (this.mainText.size() + 1) * ApplicationData.smallGreyFont.getFontHeight();
            this.achievementID = ApplicationData.defaultFont.encodeDynamicString(selectedAchievement + 1 + "/" + achievementFullDesccription.length);
            this.achievementImage = ObjectsCache.achievementCompleted[completedAchievements[selectedAchievement] ? 0 : 1];
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void drawMainText(int n) {
        int n2 = ApplicationData.smallGreyFont.getFontHeight();
        Graphic2D.SetClip(0, 0, ApplicationData.screenWidth, ApplicationData.screenHeight);
        for (int i = 0; i < this.mainText.size(); ++i) {
            int n3 = n + i * n2;
            Utils.drawString((String)this.mainText.elementAt(i), ApplicationData.screenWidth / 2, n3, 17, 2);
        }
    }

    public static boolean readFromStore() {
        BGStore bGStore = BGStore.openStoreToRead("Achievements");
        try {
            DataInputStream dataInputStream = bGStore.getInStream();
            if (dataInputStream != null && dataInputStream.available() > 0) {
                OtherAchievements.deSerialize(dataInputStream);
            }
            bGStore.close();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static void writeToStore() {
        BGStore bGStore = BGStore.openStoreToWrite("Achievements");
        try {
            DataOutputStream dataOutputStream = bGStore.getOutStream();
            OtherAchievements.serialize(dataOutputStream);
            bGStore.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void deSerialize(DataInputStream dataInputStream) throws IOException {
        int n;
        for (n = 0; n < 13; ++n) {
            OtherAchievements.completedAchievements[n] = dataInputStream.readBoolean();
        }
        for (n = 0; n < 9; ++n) {
            for (int i = 0; i < 3; ++i) {
                OtherAchievements.numMedals[n][i] = dataInputStream.readInt();
            }
        }
        numWCWon = dataInputStream.readInt();
        numOvertakes = dataInputStream.readInt();
        numLapsTotal = dataInputStream.readInt();
    }

    private static void serialize(DataOutputStream dataOutputStream) throws IOException {
        int n;
        for (n = 0; n < 13; ++n) {
            dataOutputStream.writeBoolean(completedAchievements[n]);
        }
        for (n = 0; n < 9; ++n) {
            for (int i = 0; i < 3; ++i) {
                dataOutputStream.writeInt(numMedals[n][i]);
            }
        }
        dataOutputStream.writeInt(numWCWon);
        dataOutputStream.writeInt(numOvertakes);
        dataOutputStream.writeInt(numLapsTotal);
    }
}

