/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIAnimatedButtonH;
import baltorogames.core_gui.UIButton;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gui.EventScreen;
import baltorogames.project_gui.MainMenu;
import baltorogames.project_gui.MainUSRScreen;
import baltorogames.project_gui.SelectDriverScreen;
import baltorogames.project_gui.SelectWorld;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;
import baltorogames.system.Platform;
import java.util.Vector;

public class CarSelectionScreen
extends MainUSRScreen {
    private final int LEFT_ARROW_ID;
    private final int RIGHT_ARROW_ID;
    private int currentMenuElement = 0;
    public static int NUM_MENU_ELEMENTS = 5;
    public String[] carNames = new String[]{"Catatonni", "Canettv", "Viamel", "Tenhalten", "Romerone", "Mannmark", "Amortene", "Blue Crow", "Zatenno", "UmbertoZ"};
    public String selName;
    private CGTexture carTexture;
    private CGTexture carBg;
    private Vector unlockKartInfo;
    private String unlockKartInfoUnsplit;
    private Vector unlockedKartInfo;
    private String unlockedKartInfoUnsplit;
    private UIScreen ref;
    int carPositioning;
    private CGTexture locked;
    private String carID;
    private String carPrice;
    private static int SCROLL_SPEED = 40;
    int scrollX = 0;
    int scrollXMax = 0;
    private String[] menuElements = new String[]{"ID_KART1_NAME", "ID_KART2_NAME", "ID_KART3_NAME", "ID_KART4_NAME", "ID_KART5_NAME"};
    private float[][] carStats = new float[][]{{0.2f, 0.3f, 0.2f, 0.1f, 0.3f}, {0.3f, 0.4f, 0.2f, 0.2f, 0.4f}, {0.4f, 0.3f, 0.3f, 0.5f, 0.3f}, {0.5f, 0.3f, 0.4f, 0.4f, 0.5f}, {0.6f, 0.5f, 0.3f, 0.2f, 0.4f}, {0.6f, 0.3f, 0.5f, 0.3f, 0.4f}, {0.4f, 0.3f, 0.3f, 0.2f, 0.5f}, {0.7f, 0.5f, 0.4f, 0.3f, 0.6f}, {0.6f, 0.3f, 0.5f, 0.5f, 0.7f}, {0.8f, 0.7f, 0.5f, 0.4f, 0.8f}};
    private static String[] carTextures = new String[]{"/car_1.png", "/car_4.png", "/car_2.png", "/car_3.png", "/car_5.png"};

    public void autoSize() {
    }

    public CarSelectionScreen(UIScreen uIScreen) {
        this.LEFT_ARROW_ID = 100;
        this.RIGHT_ARROW_ID = 101;
        CGUserCareer.unlockCar();
        if (Platform.IS_DEBUG_MODE) {
            CGUserCareer.UnlockAllCars();
        }
        this.ref = uIScreen;
        this.drawFP = false;
        this.drawCash = false;
        this.drawStrip1 = false;
        this.drawStrip3 = false;
        this.drawLogo = true;
        CGUserCareer.currentKart = this.currentMenuElement;
        this.scrollX = ApplicationData.screenWidth;
        this.updateScreenInfo();
        this.locked = TextureManager.AddTexture("/car_locked.png");
        this.strip1Y = MainUSRScreen.getStrip1Height();
        this.strip3Y = ApplicationData.screenHeight - 2 * ObjectsCache.menuFooterImage.GetHeight() - MainUSRScreen.getStrip3Height() / 2;
        int n = this.carPositioning = (this.strip1Y + MainUSRScreen.getStrip1Height() / 2 + this.strip3Y - MainUSRScreen.getStrip3Height() / 2) / 2;
        int n2 = 0;
        int n3 = ApplicationData.screenWidth - ObjectsCache.scrollRightImg.GetWidth();
        UIAnimatedButtonH uIAnimatedButtonH = new UIAnimatedButtonH(n3 - ObjectsCache.menuWhiteDot.GetHeight(), ApplicationData.screenHeight / 2 - this.carTexture.GetHeight() / 2 - ObjectsCache.scrollLeftImg.GetHeight() / 2, ObjectsCache.scrollRightImg, ObjectsCache.scrollRightWImg, 101);
        uIAnimatedButtonH.setScreen(this);
        uIAnimatedButtonH.setAnimDir(1);
        this.addButton(uIAnimatedButtonH);
        UIAnimatedButtonH uIAnimatedButtonH2 = new UIAnimatedButtonH(n2 + ObjectsCache.menuWhiteDot.GetHeight(), ApplicationData.screenHeight / 2 - this.carTexture.GetHeight() / 2 - ObjectsCache.scrollLeftImg.GetHeight() / 2, ObjectsCache.scrollLeftImg, ObjectsCache.scrollLeftWImg, 100);
        uIAnimatedButtonH2.setScreen(this);
        uIAnimatedButtonH2.setAnimDir(-1);
        this.addButton(uIAnimatedButtonH2);
    }

    public void onUpdate(int n) {
        this.lifeTime += n;
        this.scrollX -= SCROLL_SPEED * n;
        if (this.scrollX < this.scrollXMax) {
            this.scrollX = ApplicationData.screenWidth;
        }
    }

    public void draw() {
        this.carBg = TextureManager.AddTexture("/car_bg.png");
        if (CGUserCareer.isKartAvailable(this.currentMenuElement)) {
            Graphic2D.DrawImage(this.carBg, ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2 - this.carTexture.GetHeight() / 2, 3);
            Graphic2D.DrawImage(this.carTexture, ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2 - this.carTexture.GetHeight() / 2, 3);
        } else {
            Graphic2D.DrawImage(this.carBg, ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2 - this.carTexture.GetHeight() / 2, 3);
            Graphic2D.DrawImage(this.locked, ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2 - this.carTexture.GetHeight() / 2, 3);
        }
        this.drawStatistics(ApplicationData.screenWidth / 2 + ObjectsCache.upgradeBarEmpty.GetWidth() / 3, ApplicationData.screenHeight / 2 + this.carTexture.GetHeight() * 2 / 3);
        Utils.drawString(this.selName, ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2 + this.carTexture.GetHeight() / 2, 33, 0);
    }

    public boolean rightSoftButton() {
        if (this.ref != null && !CGUserCareer.isAnyGameStored()) {
            UIScreen.SetCurrentScreen(new SelectDriverScreen());
        } else {
            UIScreen.SetCurrentScreen(new MainMenu());
        }
        return true;
    }

    public boolean leftSoftButton() {
        if (CGUserCareer.isKartAvailable(this.currentMenuElement)) {
            if (CGUserCareer.isKartAvailable(this.currentMenuElement)) {
                CGUserCareer.currentKart = this.currentMenuElement;
            }
            if (CGEngine.selectedGameMode == 2) {
                UIScreen.SetCurrentScreen(new EventScreen());
            } else {
                UIScreen.SetCurrentScreen(new SelectWorld());
            }
            return true;
        }
        return false;
    }

    public boolean selectLeftAction() {
        UIButton uIButton = this.findByID(100);
        if (uIButton != null) {
            uIButton.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean selectRightAction() {
        UIButton uIButton = this.findByID(101);
        if (uIButton != null) {
            uIButton.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean actionSoftButton(int n, boolean bl) {
        if (super.actionSoftButton(n, bl)) {
            return true;
        }
        if (!bl) {
            this.unselectAllButtons();
            if (n == 100) {
                this.onLeftAction();
                return true;
            }
            if (n == 101) {
                this.onRightAction();
                return true;
            }
        }
        return false;
    }

    public boolean onRightAction() {
        ++this.currentMenuElement;
        if (this.currentMenuElement >= this.menuElements.length) {
            this.currentMenuElement = 0;
        }
        this.updateScreenInfo();
        return true;
    }

    public boolean onLeftAction() {
        --this.currentMenuElement;
        if (this.currentMenuElement < 0) {
            this.currentMenuElement = this.menuElements.length - 1;
        }
        this.updateScreenInfo();
        return true;
    }

    public void updateScreenInfo() {
        CGUserCareer.currentKart = this.currentMenuElement;
        this.carTexture = TextureManager.AddTexture(carTextures[this.currentMenuElement]);
        if (this.carTexture == null) {
            this.carTexture = TextureManager.AddTexture("/car_1.png");
        }
        if (CGUserCareer.isKartAvailable(this.currentMenuElement)) {
            this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        } else {
            this.setSoftButtonImage(null, null, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        }
        this.selName = ApplicationData.defaultFont.encodeDynamicString(this.carNames[this.currentMenuElement]);
        this.carID = ApplicationData.defaultFont.encodeDynamicString(this.currentMenuElement + 1 + "/" + this.menuElements.length);
        this.carPrice = ApplicationData.defaultFont.encodeDynamicString("$50" + this.currentMenuElement);
    }

    public boolean onFireAction() {
        return this.leftSoftButton();
    }

    private void drawDots(int n, int n2, int n3, int n4) {
        if (n > 0) {
            int n5 = ApplicationData.screenWidth / 2 - this.carBg.GetWidth() / 2 + ObjectsCache.menuRedDot.GetWidth();
            for (int i = 0; i < n; ++i) {
                int n6 = n5 + i * (int)((float)ObjectsCache.menuRedDot.GetWidth() * 2.4f);
                Graphic2D.DrawImage(i == n2 ? ObjectsCache.menuWhiteDot : ObjectsCache.menuRedDot, n6, n4, 17);
            }
        }
    }

    private void drawStat(int n, int n2, float f, float f2) {
        int n3 = ObjectsCache.upgradeBarFull.GetWidth();
        int n4 = ObjectsCache.upgradeBarFull.GetHeight();
        Graphic2D.DrawImage(ObjectsCache.upgradeBarFull, n, n2, 20);
        Graphic2D.SetClip(n, n2, (int)(f2 * (float)n3), n4);
        Graphic2D.SetClip(n, n2, (int)(f * (float)n3), n4);
        Graphic2D.DrawImage(ObjectsCache.upgradeBarEmpty, n, n2, 20);
        Graphic2D.SetClip(0, 0, ApplicationData.screenWidth, ApplicationData.screenHeight);
    }

    private void drawStatistics(int n, int n2) {
        int n3 = ObjectsCache.upgradeBarFull.GetHeight() + ObjectsCache.upgradeBarFull.GetHeight() / 5;
        this.drawStat(n, n2, this.carStats[this.currentMenuElement][0], 0.0f);
        this.drawStat(n, n2 + n3, this.carStats[this.currentMenuElement][1], 3.0f);
        this.drawStat(n, n2 + 2 * n3, this.carStats[this.currentMenuElement][2], 1.0f);
        this.drawStat(n, n2 + 3 * n3, this.carStats[this.currentMenuElement][3], 1.0f);
        this.drawStat(n, n2 + 4 * n3, this.carStats[this.currentMenuElement][4], 2.0f);
        int n4 = n2 + ObjectsCache.upgradeBarFull.GetHeight() / 2;
        Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, "ID_TUNING_POWER"), n - ObjectsCache.upgradeBarFull.GetWidth() / 10, n4, 10, 0);
        Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, "ID_TUNING_HANDLING"), n - ObjectsCache.upgradeBarFull.GetWidth() / 10, n4 + n3, 10, 0);
        Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, "ID_TUNING_NITRO"), n - ObjectsCache.upgradeBarFull.GetWidth() / 10, n4 + 2 * n3, 10, 0);
        Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, "ID_TUNING_BOOST_POWER"), n - ObjectsCache.upgradeBarFull.GetWidth() / 10, n4 + 3 * n3, 10, 0);
        Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, "ID_TUNING_BOOST_TIME"), n - ObjectsCache.upgradeBarFull.GetWidth() / 10, n4 + 4 * n3, 10, 0);
    }

    private void drawKartUnlockInfo(int n) {
        if (this.unlockKartInfo == null) {
            this.updateKartUnlockInfo();
        }
        try {
            Utils.drawString(this.unlockKartInfo, ApplicationData.screenWidth >> 1, n - ApplicationData.defaultFont.getFontHeight() * 3, 3, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void drawKartUnlockedInfo(int n) {
        if (this.unlockedKartInfo == null) {
            this.updateKartUnlockedInfo();
        }
        Utils.drawString(this.unlockedKartInfo, ApplicationData.screenWidth >> 1, n - ApplicationData.defaultFont.getFontHeight() * 2, 3, 0);
    }

    private void updateKartUnlockInfo() {
        String string = null;
        if (this.currentMenuElement > 0) {
            switch (this.currentMenuElement) {
                case 1: {
                    string = "ID_UNLOCK_KART_1";
                    break;
                }
                case 2: {
                    string = "ID_UNLOCK_KART_2";
                    break;
                }
                case 3: {
                    string = "ID_UNLOCK_KART_3";
                }
            }
            this.unlockKartInfoUnsplit = ApplicationData.lp.getTranslatedString(Options.languageID, string);
            this.unlockKartInfo = Utils.splitText(this.unlockKartInfoUnsplit, "+", ApplicationData.screenWidth, 0);
            this.scrollXMax = -Utils.stringWidth(this.unlockKartInfoUnsplit, 0);
        }
    }

    private void updateKartUnlockedInfo() {
        String string = null;
        switch (this.currentMenuElement) {
            case 0: {
                string = "ID_UNLOCKED_KART_0";
                break;
            }
            case 1: {
                string = "ID_UNLOCKED_KART_1";
                break;
            }
            case 2: {
                string = "ID_UNLOCKED_KART_2";
                break;
            }
            case 3: {
                string = "ID_UNLOCKED_KART_3";
            }
        }
        this.unlockedKartInfoUnsplit = ApplicationData.lp.getTranslatedString(Options.languageID, string);
        this.unlockedKartInfo = Utils.splitText(this.unlockedKartInfoUnsplit, "+", ApplicationData.screenWidth, 0);
        this.scrollXMax = -Utils.stringWidth(this.unlockedKartInfoUnsplit, 0);
    }
}

