/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGTrack;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gameplay.CarEngine2D;
import baltorogames.project_gameplay.DamageSystem;
import baltorogames.project_gameplay.FXUtility;
import baltorogames.project_gameplay.ILevel;
import baltorogames.project_gameplay.LowLevel1;
import baltorogames.project_gameplay.LowLevel2;
import baltorogames.project_gameplay.LowLevel3;
import baltorogames.project_gameplay.MyGame;
import baltorogames.project_gui.End14MileScreen;
import baltorogames.project_gui.EndCompetitionScreen;
import baltorogames.project_gui.EndTimeAttackScreen;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;
import java.io.DataInputStream;
import java.util.Vector;

public class CGEngine {
    public static DamageSystem damageSystem = new DamageSystem();
    public static Vector tapToBoostText = new Vector();
    public static Vector tapToPitText = new Vector();
    public static final int MAX_NUMBER_OF_PLAYERS = 10;
    public static final int TOURNAMENT_TYPE_SINGLE_COMPETITION = 1;
    public static final int TOURNAMENT_TYPE_CHAMPIONSHIPS = 2;
    public static final int TOURNAMENT_TYPE_TIMEATTACK = 3;
    public static final int RACE_TYPE_RACE = 0;
    public static final int RACE_TYPE_14MILE = 1;
    public static final int RACE_TYPE_TIMEATTACK = 2;
    public static final int WEATHER_SUNNY = 0;
    public static final int WEATHER_CLOUDY = 1;
    public static final int WEATHER_NIGHT = 2;
    public static final int WEATHER_RAINY = 3;
    public static final int TIMEATTACK_CASH_FOR_GOLD = 100;
    public static final int TIMEATTACK_CASH_FOR_SILVER = 60;
    public static final int TIMEATTACK_CASH_FOR_BRONZE = 40;
    public static final int TIMEATTACK_FP_FOR_GOLD = 220;
    public static final int TIMEATTACK_FP_FOR_SILVER = 170;
    public static final int TIMEATTACK_FP_FOR_BRONZE = 145;
    public static final int MILE14_CASH_FOR_GOLD = 100;
    public static final int MILE14_FP_FOR_GOLD = 320;
    public static final int[] RACE_CASH_FOR_POS = new int[]{200, 100, 80, 60, 50, 40, 20, 10, 0, 0, 0, 0};
    public static final int[] RACE_FP_FOR_POS = new int[]{560, 480, 400, 320, 240, 160, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final int[] RACE_POINTS_FOR_POS = new int[]{8, 7, 6, 5, 4, 3, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final int FAME_POINTS_RADAR = -15;
    public static final int FAME_POINTS_AHEAD = 15;
    public static final int[] timeAttack_GoldTime = new int[]{200000, 20000, 200000, 200000, 20000, 200000, 200000, 20000, 200000, 200000, 20000, 200000, 200000, 20000, 200000};
    public static final int[] timeAttack_SilverTime = new int[]{25000, 25000, 210000, 25000, 25000, 210000, 25000, 25000, 210000, 25000, 25000, 210000, 25000, 25000, 210000};
    public static final int[] timeAttack_BronzeTime = new int[]{30000, 30000, 225000, 30000, 30000, 225000, 30000, 30000, 225000, 30000, 30000, 225000, 30000, 30000, 225000};
    public static int[] raceIDtoRaceType = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static int[] trackLength = new int[]{0x7D00000, 61440000, 122880000, 0x7D00000, 61440000, 0x7D00000, 0x7D00000, 61440000, 0x7D00000, 144588800, 61440000, 144588800, 139264000, 61440000, 139264000};
    public static int m_nNrOfLaps = 3;
    public static CGTexture[] m_CountDownTextures = null;
    public static CGTexture m_TachoMPH_Texture = null;
    public static int m_RadarEventTime = 0;
    public static boolean m_bPause = false;
    public static int m_nStateTime = 0;
    private static long _currentVelocity = 0L;
    public static int selectedGameMode = 0;
    public static int selectedRaceType = 0;
    public static int selectedTrack = 0;
    public static CarEngine2D testApp = new CarEngine2D();
    public static int m_nCurrentRacePos = 8;
    public static int m_nInitFamePoints;
    public static int m_nCurrrentFamePoints;
    protected static HUD hud;

    public static void Load1(DataInputStream dataInputStream) {
        CGEngine.Destroy();
        int n = selectedTrack;
        int n2 = 80 * ApplicationData.screenHeight / 320;
        int n3 = 82 * ApplicationData.screenHeight / 320;
        if (n3 <= n2) {
            n3 = n2 + 1;
        }
        int n4 = 21;
        int n5 = 38400 / ApplicationData.screenHeight;
        testApp.SetCameraSettings(ApplicationData.screenWidth, ApplicationData.screenHeight, n2, n3, n5, ApplicationData.screenWidth * 4096 / 240, n4);
        testApp.Load(dataInputStream, n);
    }

    public static void Load2(DataInputStream dataInputStream) {
        int n;
        int n2 = selectedTrack;
        testApp.GetTrack().SetFinishDistance(CGEngine.testApp.GetTrack().m_fxTrackLength);
        int n3 = n2;
        if (selectedRaceType == 1) {
            n3 = 10;
        }
        if (n3 != CGTrack.m_nLastTrackIndex) {
            System.out.println("nTrackIndex != CGTrack.m_nLastTrackIndex");
            System.out.println("=========================================");
            System.out.println("============ SL = " + selectedTrack);
            System.out.println("=========================================");
            ILevel iLevel = new LowLevel1();
            iLevel = selectedTrack < 3 ? new LowLevel1() : (selectedTrack < 6 ? new LowLevel2() : (selectedTrack < 9 ? new LowLevel3() : new LowLevel1()));
            try {
                CGEngine.testApp.m_Track.GenerateObjects_Env(0);
            }
            catch (Exception exception) {
                System.out.println("Fatal error = " + exception.getMessage());
                exception.printStackTrace();
            }
            System.out.println("selectedTrack = " + selectedTrack);
            iLevel.GanerateObjects_Level1();
            iLevel.GenerateObjects_Level2();
            iLevel.GenerateObjects_Level3();
        } else {
            System.out.println("nTrackIndex == CGTrack.m_nLastTrackIndex");
        }
        CGTrack.m_nLastTrackIndex = n3;
        if (selectedRaceType == 1) {
            CGTrack.m_nLastTrackIndex = 10;
        }
        CGEngine.testApp.m_nTranslateScreenY = n = 0;
        if (selectedRaceType == 0) {
            testApp.SetupBolids(6);
        } else if (selectedRaceType == 1) {
            testApp.SetupBolids(2);
        } else {
            testApp.SetupBolids(1);
        }
        testApp.SetupLaps(m_nNrOfLaps);
        if (selectedRaceType == 1) {
            testApp.GetBolid(0).SetManualGear(true);
        }
        long l = 4096L;
        long l2 = 4096L;
        long l3 = 4096L;
        if (CGUserCareer.difficultyLevel == 0) {
            testApp.GetBolid(0).SetPowerFactorHuman(4096L + 6L * l / 10L);
            testApp.GetBolid(0).SetNitroFactorHuman(4096L + 3L * l2 / 10L);
            testApp.GetBolid(0).SetHandlingFactorHuman(4096L + 12L * l3 / 10L);
        } else if (CGUserCareer.difficultyLevel == 1) {
            testApp.GetBolid(0).SetPowerFactorHuman(4096L + 5L * l / 10L);
            testApp.GetBolid(0).SetNitroFactorHuman(4096L + 2L * l2 / 10L);
            testApp.GetBolid(0).SetHandlingFactorHuman(4096L + 12L * l3 / 10L);
        } else if (CGUserCareer.difficultyLevel == 2) {
            testApp.GetBolid(0).SetPowerFactorHuman(4096L + 4L * l / 10L);
            testApp.GetBolid(0).SetNitroFactorHuman(4096L + 1L * l2 / 10L);
            testApp.GetBolid(0).SetHandlingFactorHuman(4096L + 12L * l3 / 10L);
        }
        m_nStateTime = 0;
        _currentVelocity = 0L;
        m_bPause = false;
        m_RadarEventTime = 0;
        if (m_CountDownTextures == null) {
            m_CountDownTextures = new CGTexture[4];
            CGEngine.m_CountDownTextures[0] = TextureManager.AddTexture("/gameplay/start_01.png");
            CGEngine.m_CountDownTextures[1] = TextureManager.AddTexture("/gameplay/start_02.png");
            CGEngine.m_CountDownTextures[2] = TextureManager.AddTexture("/gameplay/start_03.png");
            CGEngine.m_CountDownTextures[3] = TextureManager.AddTexture("/gameplay/start_04.png");
        }
        m_TachoMPH_Texture = TextureManager.AddTexture("/gameplay/tacho.png");
        m_nCurrentRacePos = 8;
        m_nInitFamePoints = CGUserCareer.GetFamePoints();
        m_nCurrrentFamePoints = 0;
    }

    public static int Init() {
        FXUtility.Init();
        CGTexture.m_NrOfMipMapsForObjects = 10;
        CGTexture.m_NrOfMipMapsForBolids = 7;
        String string = ApplicationData.lp.getTranslatedString(Options.languageID, "ID_PRESS_2_TO_BOOST");
        tapToBoostText = Utils.splitText(string, "+", ApplicationData.screenWidth, 0);
        String string2 = ApplicationData.lp.getTranslatedString(Options.languageID, "ID_KEY_TO_PIT");
        tapToPitText = Utils.splitText(string2, "+", ApplicationData.screenWidth, 0);
        CGTexture.m_NrOfMipMapsForObjects = 4;
        CGTexture.m_NrOfMipMapsForBolids = 4;
        return 1;
    }

    public static void Destroy() {
    }

    public static void RadarEvent() {
        m_RadarEventTime = 1;
    }

    public static void Update(int n) {
        if (m_bPause) {
            return;
        }
        CGEngine.testApp.m_fxDeltaTime = n * 4096 / 1000;
        m_nStateTime += n;
        _currentVelocity = CGEngine.testApp.GetHumanBolid().m_fxCurrentVelocity;
        if (m_RadarEventTime > 0 && (m_RadarEventTime += n) > 2000) {
            m_RadarEventTime = 0;
        }
        if (CGEngine.testApp.m_nGameState == 0) {
            if (m_nStateTime >= 3000) {
                testApp.Go();
                m_nStateTime = 0;
            }
        } else if (testApp.GetGameState() == 1) {
            if (ApplicationData.isUpPressed() || MyGame.upTouchKeyPressed) {
                testApp.GetHumanBolid().Sterring_Nitro();
            } else if (ApplicationData.isDownPressed() || MyGame.downTouchKeyPressed) {
                testApp.GetHumanBolid().Sterring_Down();
                testApp.GetHumanBolid().SetBreak(1);
            } else {
                testApp.GetHumanBolid().Sterring_Up();
            }
            if (selectedRaceType != 1) {
                if (ApplicationData.isRightPressed() || MyGame.rightTouchKeyPressed) {
                    testApp.GetHumanBolid().Sterring_Right();
                } else if (ApplicationData.isLeftPressed() || MyGame.leftTouchKeyPressed) {
                    testApp.GetHumanBolid().Sterring_Left();
                } else {
                    testApp.GetHumanBolid().SetStraight(0);
                }
            }
        } else if (CGEngine.testApp.m_nGameState == 2 && m_nStateTime >= 2000) {
            ApplicationData.generalGameMode = 3;
            if (selectedRaceType == 0) {
                UIScreen.SetCurrentScreen(new EndCompetitionScreen());
            } else if (selectedRaceType == 1) {
                UIScreen.SetCurrentScreen(new End14MileScreen());
            } else if (selectedRaceType == 2) {
                UIScreen.SetCurrentScreen(new EndTimeAttackScreen());
            }
        }
        int n2 = testApp.GetGameState();
        testApp.Step();
        if (n2 == 1 && testApp.GetGameState() == 2) {
            m_nStateTime = 0;
            System.out.println("FINISH!!!");
        }
    }

    public static void Render() {
        if (m_bPause) {
            return;
        }
        if (CGEngine.testApp.m_nGameState == 0) {
            if (m_nStateTime < 1000) {
                if (m_CountDownTextures != null && m_CountDownTextures[0] != null) {
                    Graphic2D.DrawImage(m_CountDownTextures[0], ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2, 3);
                } else {
                    Utils.drawString(ApplicationData.defaultFont.encodeDynamicString("03"), ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2, 3, 0);
                }
            } else if (m_nStateTime < 2000) {
                if (m_CountDownTextures != null && m_CountDownTextures[1] != null) {
                    Graphic2D.DrawImage(m_CountDownTextures[1], ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2, 3);
                } else {
                    Utils.drawString(ApplicationData.defaultFont.encodeDynamicString("02"), ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2, 3, 0);
                }
            } else if (m_CountDownTextures != null && m_CountDownTextures[2] != null) {
                Graphic2D.DrawImage(m_CountDownTextures[2], ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2, 3);
            } else {
                Utils.drawString(ApplicationData.defaultFont.encodeDynamicString("01"), ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2, 3, 0);
            }
        } else if (CGEngine.testApp.m_nGameState == 1) {
            if (m_nStateTime < 1000) {
                if (m_CountDownTextures != null && m_CountDownTextures[3] != null) {
                    Graphic2D.DrawImage(m_CountDownTextures[3], ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2, 3);
                } else {
                    Utils.drawString(ApplicationData.defaultFont.encodeDynamicString("GO"), ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2, 3, 0);
                }
            }
            if (selectedRaceType == 0) {
                hud.drawLap();
                hud.drawTime();
                long l = CGEngine.testApp.GetBolid((int)0).m_fxRealCurrentDistanceFromStart;
                int n = CGEngine.testApp.m_nNrOfBolids;
                for (int i = 1; i < CGEngine.testApp.m_nNrOfBolids; ++i) {
                    if (l <= CGEngine.testApp.GetBolid((int)i).m_fxRealCurrentDistanceFromStart) continue;
                    --n;
                }
                hud.drawPosition(n);
            } else if (selectedRaceType == 1) {
                Utils.drawString(ApplicationData.defaultFont.encodeDynamicString(Utils.formatTimeAsc(m_nStateTime)), ApplicationData.screenWidth / 2, ApplicationData.defaultFont.getFontHeight() / 2, 17, 0);
                if (testApp.GetBolid(0).GetManualGear() && testApp.GetBolid(0).IsMaxManualVelocity()) {
                    Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_GEAR_UP"), ApplicationData.screenWidth / 2, 4 * ApplicationData.defaultFont.getFontHeight() / 2, 17, 0);
                }
            } else if (selectedRaceType == 2) {
                int n = selectedTrack * 3 + selectedRaceType;
                if (m_nStateTime < timeAttack_GoldTime[n]) {
                    Utils.drawString(ApplicationData.defaultFont.encodeDynamicString(Utils.formatTimeAsc(timeAttack_GoldTime[n] - m_nStateTime)), ApplicationData.screenWidth / 2, ApplicationData.defaultFont.getFontHeight() / 2, 17, 0);
                    Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_TIME_TO_GOLD_AWARD"), ApplicationData.screenWidth / 2, 3 * ApplicationData.defaultFont.getFontHeight() / 2, 17, 0);
                } else if (m_nStateTime < timeAttack_SilverTime[n]) {
                    Utils.drawString(ApplicationData.defaultFont.encodeDynamicString(Utils.formatTimeAsc(timeAttack_SilverTime[n] - m_nStateTime)), ApplicationData.screenWidth / 2, ApplicationData.defaultFont.getFontHeight() / 2, 17, 0);
                    Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_TIME_TO_SILVER_AWARD"), ApplicationData.screenWidth / 2, 3 * ApplicationData.defaultFont.getFontHeight() / 2, 17, 0);
                } else if (m_nStateTime < timeAttack_BronzeTime[n]) {
                    Utils.drawString(ApplicationData.defaultFont.encodeDynamicString(Utils.formatTimeAsc(timeAttack_BronzeTime[n] - m_nStateTime)), ApplicationData.screenWidth / 2, ApplicationData.defaultFont.getFontHeight() / 2, 17, 0);
                    Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_TIME_TO_BRONZE_AWARD"), ApplicationData.screenWidth / 2, 3 * ApplicationData.defaultFont.getFontHeight() / 2, 17, 0);
                } else {
                    Utils.drawString(ApplicationData.defaultFont.encodeDynamicString("00:00:00"), ApplicationData.screenWidth / 2, ApplicationData.defaultFont.getFontHeight() / 2, 17, 0);
                }
            }
            hud.drawSpeed();
            hud.drawNitro();
        } else if (CGEngine.testApp.m_nGameState == 2) {
            if (selectedRaceType == 0) {
                Utils.drawString(ApplicationData.defaultFont.encodeDynamicString(Utils.formatTimeAsc(testApp.GetBolid(0).GetTotalTime())), ApplicationData.screenWidth / 2, ApplicationData.defaultFont.getFontHeight() / 2, 17, 0);
                int n = testApp.GetBolid(0).GetTotalTime();
                int n2 = CGEngine.testApp.m_nNrOfBolids;
                for (int i = 1; i < CGEngine.testApp.m_nNrOfBolids; ++i) {
                    if (n >= testApp.GetBolid(i).GetTotalTime()) continue;
                    --n2;
                }
                Utils.drawString(ApplicationData.defaultFont.encodeDynamicString(" " + n2 + " / " + 6), 0, ApplicationData.defaultFont.getFontHeight() / 2, 20, 0);
            } else if (selectedRaceType == 1) {
                Utils.drawString(ApplicationData.defaultFont.encodeDynamicString(Utils.formatTimeAsc(testApp.GetBolid(0).GetTotalTime())), ApplicationData.screenWidth / 2, ApplicationData.defaultFont.getFontHeight() / 2, 17, 0);
            } else if (selectedRaceType == 2) {
                int n = selectedTrack * 3 + selectedRaceType;
                if (testApp.GetBolid(0).GetTotalTime() < timeAttack_GoldTime[n]) {
                    Utils.drawString(ApplicationData.defaultFont.encodeDynamicString(Utils.formatTimeAsc(timeAttack_GoldTime[n] - testApp.GetBolid(0).GetTotalTime())), ApplicationData.screenWidth / 2, ApplicationData.defaultFont.getFontHeight() / 2, 17, 0);
                    Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_TIME_TO_GOLD_AWARD"), ApplicationData.screenWidth / 2, 3 * ApplicationData.defaultFont.getFontHeight() / 2, 17, 0);
                } else if (testApp.GetBolid(0).GetTotalTime() < timeAttack_SilverTime[n]) {
                    Utils.drawString(ApplicationData.defaultFont.encodeDynamicString(Utils.formatTimeAsc(timeAttack_SilverTime[n] - testApp.GetBolid(0).GetTotalTime())), ApplicationData.screenWidth / 2, ApplicationData.defaultFont.getFontHeight() / 2, 17, 0);
                    Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_TIME_TO_SILVER_AWARD"), ApplicationData.screenWidth / 2, 3 * ApplicationData.defaultFont.getFontHeight() / 2, 17, 0);
                } else if (testApp.GetBolid(0).GetTotalTime() < timeAttack_BronzeTime[n]) {
                    Utils.drawString(ApplicationData.defaultFont.encodeDynamicString(Utils.formatTimeAsc(timeAttack_BronzeTime[n] - testApp.GetBolid(0).GetTotalTime())), ApplicationData.screenWidth / 2, ApplicationData.defaultFont.getFontHeight() / 2, 17, 0);
                    Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_TIME_TO_BRONZE_AWARD"), ApplicationData.screenWidth / 2, 3 * ApplicationData.defaultFont.getFontHeight() / 2, 17, 0);
                } else {
                    Utils.drawString(ApplicationData.defaultFont.encodeDynamicString("00:00:00"), ApplicationData.screenWidth / 2, ApplicationData.defaultFont.getFontHeight() / 2, 17, 0);
                }
            }
        }
    }

    static {
        hud = new HUD();
    }

    static class HUD {
        private CGTexture hudBg;
        private CGTexture iconNitro;
        private CGTexture iconNitroOf;
        private CGTexture speedBar;
        private CGTexture nitroBar;
        private int x;
        private int y;
        private int yMargin = ApplicationData.defaultFont.getFontHeight() / 6;
        int length = ApplicationData.screenWidth - this.yMargin - ObjectsCache.timeIcon.GetWidth() - this.yMargin - this.yMargin - this.yMargin - ObjectsCache.mphIcon.GetWidth();

        public HUD() {
            this.initializeHUD();
        }

        public void initializeHUD() {
            this.hudBg = TextureManager.CreateTexture("/HUD/hud_bg.png");
            this.iconNitro = TextureManager.CreateTexture("/HUD/icobooston.png");
            this.speedBar = TextureManager.CreateTexture("/HUD/speedbar.png");
            this.nitroBar = TextureManager.CreateTexture("/HUD/boostbar.png");
            this.iconNitroOf = TextureManager.CreateTexture("/HUD/icoboostoff.png");
        }

        private final void drawBackground() {
            Graphic2D.DrawImage(this.hudBg, 1, 0, 20);
        }

        public void drawLap() {
            this.drawBackground();
            Utils.drawString(ApplicationData.defaultFont.encodeDynamicString(Integer.toString(CGEngine.testApp.GetHumanBolid().m_nCurrentLap + 1) + "/" + m_nNrOfLaps), this.iconNitroOf.GetWidth(), this.hudBg.GetHeight() * 65 / 100, 24, 1);
        }

        public void drawPosition(int n) {
            Utils.drawString(ApplicationData.defaultFont.encodeDynamicString(Integer.toString(n)), this.iconNitroOf.GetWidth() * 160 / 100, this.hudBg.GetHeight() / 2, 10, 1);
        }

        public void drawTime() {
        }

        public void drawSpeed() {
            Utils.drawString(ApplicationData.defaultFont.encodeDynamicString("" + _currentVelocity / 4096L / 6L), this.hudBg.GetWidth() - this.hudBg.GetHeight() / 3, this.hudBg.GetHeight() / 3, 3, 1);
            int n = 5;
            if (ApplicationData.screenHeight == 160) {
                n = 1;
            } else if (ApplicationData.screenHeight == 220) {
                n = 2;
            }
            long l = (long)this.speedBar.GetWidth() * _currentVelocity / 4096L / 6L / 170L;
            Graphic2D.DrawRegion(this.speedBar, 0, 0, (int)l, this.speedBar.GetHeight() / 2, 0, ApplicationData.screenWidth * 27 / 100, n, 6);
        }

        public void drawDamages() {
            damageSystem.drawDamageState();
        }

        public void drawNitro() {
            CGTexture cGTexture = this.iconNitroOf;
            long l = testApp.GetBolid(0).GetCurrentNitroLevel();
            if (l >= 4096L) {
                l = 4096L;
                if (ApplicationData.getAppTime() % 400L < 200L && !ApplicationData.isTouchScreen) {
                    for (int i = 0; i < tapToBoostText.size(); ++i) {
                        String string = (String)tapToBoostText.elementAt(i);
                        Utils.drawString(string, ApplicationData.screenWidth / 2, ObjectsCache.mphIcon.GetHeight() + this.yMargin + ApplicationData.defaultFont.getFontHeight() * (i + 1), 17, 0);
                    }
                    cGTexture = cGTexture == this.iconNitroOf ? this.iconNitro : this.iconNitroOf;
                }
            }
            long l2 = (long)this.nitroBar.GetWidth() * l / 4096L;
            int n = 5;
            if (ApplicationData.screenHeight == 160) {
                n = 1;
            } else if (ApplicationData.screenHeight == 220) {
                n = 2;
            }
            Graphic2D.DrawRegion(this.nitroBar, 0, 0, (int)l2, this.nitroBar.GetHeight(), 0, ApplicationData.screenWidth * 28 / 100, n + this.speedBar.GetHeight() / 2 + 1, 6);
            int n2 = this.hudBg.GetHeight() / (ApplicationData.screenHeight == 160 ? 2 : 3);
            if (ApplicationData.screenHeight == 220) {
                n2 = 13;
            }
            Graphic2D.DrawImage(cGTexture, ApplicationData.screenWidth - (ApplicationData.screenHeight == 220 ? 8 : 0), n2, 24);
        }
    }
}

