/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.KeyCommand;
import baltorogames.core.TouchCommand;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;

public class SplashScreens
extends UIScreen {
    private static final int SPLASH_TIME_INTERVAL = 3000;
    private int currentSplash;
    private CGTexture[] images = new CGTexture[2];
    private int[] backgroundColors = new int[]{-1, -1};
    int time = 0;

    public SplashScreens() {
        this.images[0] = TextureManager.AddTexture("/logo2.png");
        this.images[1] = TextureManager.AddTexture("/logo1.png");
        this.time = 0;
        this.currentSplash = 0;
    }

    public void drawWindowBackground() {
    }

    public void drawWindowForeground() {
    }

    public void draw() {
        Graphic2D.SetColor(this.backgroundColors[this.currentSplash]);
        Graphic2D.FillRect(0, 0, ApplicationData.screenWidth, ApplicationData.screenHeight);
        if (this.images[this.currentSplash] != null) {
            Graphic2D.DrawImage(this.images[this.currentSplash], ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2, 3);
        }
    }

    public boolean keyEvent(KeyCommand keyCommand) {
        if (keyCommand.pressed) {
            return true;
        }
        this.time = 0;
        ++this.currentSplash;
        if (this.currentSplash >= this.images.length) {
            this.readyForClose = true;
            if (this.images[0] != null) {
                TextureManager.DeleteTexture(this.images[0]);
            }
            if (this.images[1] != null) {
                TextureManager.DeleteTexture(this.images[1]);
            }
            UIScreen.SetCurrentScreen(null);
            ApplicationData.showLoadingSplash();
        }
        return true;
    }

    public boolean keyTouchEvent(TouchCommand touchCommand) {
        if (touchCommand.onPressed == 1) {
            this.time = 0;
            ++this.currentSplash;
            if (this.currentSplash >= this.images.length) {
                this.readyForClose = true;
                if (this.images[0] != null) {
                    TextureManager.DeleteTexture(this.images[0]);
                }
                if (this.images[1] != null) {
                    TextureManager.DeleteTexture(this.images[1]);
                }
                UIScreen.SetCurrentScreen(null);
                ApplicationData.showLoadingSplash();
            }
            return true;
        }
        return false;
    }

    public void onUpdate(int n) {
        this.time += n;
        if (this.time > 3000) {
            this.time = 0;
            ++this.currentSplash;
            if (this.currentSplash >= this.images.length) {
                this.readyForClose = true;
                if (this.images[0] != null) {
                    TextureManager.DeleteTexture(this.images[0]);
                }
                if (this.images[1] != null) {
                    TextureManager.DeleteTexture(this.images[1]);
                }
                UIScreen.SetCurrentScreen(null);
                ApplicationData.showLoadingSplash();
            }
        }
    }
}

