/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIButton;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gui.EventScreen;
import baltorogames.project_gui.GeneralListForCareer;
import baltorogames.project_gui.LoadingLevelScreen;
import baltorogames.project_gui.MainMenu;
import baltorogames.project_gui.MainUSRScreen;
import baltorogames.project_gui.SelectTrack;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;
import java.util.Random;
import java.util.Vector;

public class CareerScreen
extends MainUSRScreen {
    private final int BUTTON_ARROWLEFT_ID;
    private final int BUTTON_ARROWRIGHT_ID;
    private final int BUTTON_GARAGE_ID;
    private final int BUTTON_PLAY_ID;
    private final int BUTTON_RANKING_ID;
    public static int NUM_MENU_ELEMENTS = 9;
    private int menuID = 0;
    private int visibleButtons = NUM_MENU_ELEMENTS;
    private int buttonOffset;
    private int firstButtonX;
    private int firstButtonY;
    private int secondButtonX;
    private CGTexture cityName;
    private String eventType;
    private CGTexture countryImage = null;
    private CGTexture[] iconImages = new CGTexture[2];
    private CGTexture[] iconSelImages = new CGTexture[2];
    private Vector textLines;
    private CGTexture cityBg;
    public static int nextEvent = 0;
    protected TrackStats trackStats = new TrackStats();
    private UIButton lap1button;
    private UIButton lap3button;
    private UIButton lap5button;
    private final int LAP1_BUT_ID;
    private final int LAP3_BUT_ID;
    private final int LAP5_BUT_ID;

    public CareerScreen() {
        this.BUTTON_ARROWLEFT_ID = 50;
        this.BUTTON_ARROWRIGHT_ID = 51;
        this.BUTTON_GARAGE_ID = 100;
        this.BUTTON_PLAY_ID = 101;
        this.BUTTON_RANKING_ID = 102;
        this.LAP1_BUT_ID = 501;
        this.LAP3_BUT_ID = 502;
        this.LAP5_BUT_ID = 503;
        if (CGUserCareer.m_nRaceID < 0) {
            CGUserCareer.m_nRaceID = 0;
        }
        try {
            CGUserCareer.m_nRaceID = EventScreen.currentEventArray[nextEvent];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            nextEvent = 0;
            CGUserCareer.m_nRaceID = EventScreen.currentEventArray[nextEvent];
        }
        System.out.println("RaceID:" + CGUserCareer.m_nRaceID);
        CGEngine.m_nNrOfLaps = 3;
        this.iconImages[0] = TextureManager.AddTexture("/c_stats.png");
        this.iconImages[1] = TextureManager.AddTexture("/c_race.png");
        this.iconSelImages[0] = TextureManager.AddTexture("/c_stats_s.png");
        this.iconSelImages[1] = TextureManager.AddTexture("/c_race_s.png");
        this.countryImage = TextureManager.AddTexture("/city_" + CGUserCareer.getCityFromRaceID(CGUserCareer.m_nRaceID) + "_ico.png");
        this.eventType = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_EVENT_NAME_" + CGUserCareer.getEventFromRaceID(CGUserCareer.m_nRaceID));
        String string = "TID_LOADING_HINT_RACE";
        if (CGEngine.selectedRaceType == 1) {
            string = "TID_LOADING_HINT_14MILE";
        } else if (CGEngine.selectedRaceType == 2) {
            string = "TID_LOADING_HINT_TIMEATTACK";
        }
        this.textLines = Utils.splitText(ApplicationData.lp.getTranslatedString(Options.languageID, string), "+", ApplicationData.screenWidth, 0);
        ApplicationData.defaultFont.encodeDynamicString(" " + CGUserCareer.GetPoints());
        this.drawLogo = true;
        this.drawStrip1 = false;
        this.drawStrip2 = false;
        this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        this.strip2Y = ApplicationData.screenHeight - 2 * ObjectsCache.menuFooterImage.GetHeight();
        this.strip1Y = 36 + MainUSRScreen.getStrip1Height() / 2;
        if (CGUserCareer.m_nRaceID < 0) {
            CGUserCareer.m_nRaceID = 0;
        }
        int n = this.strip2Y;
        n -= this.iconImages[0].GetHeight() / 2;
        int n2 = this.iconImages[0].GetWidth() / 5;
        this.updateCheck();
    }

    protected void updateCheck() {
    }

    protected void findCheck() {
    }

    public void autoSize() {
    }

    public void draw() {
        this.cityBg = TextureManager.AddTexture("/car_bg.png");
        if (this.countryImage != null) {
            Graphic2D.DrawImage(this.cityBg, ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2 - this.cityBg.GetHeight() / 4, 3);
            Graphic2D.DrawImage(this.countryImage, ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2 - this.cityBg.GetHeight() / 4, 3);
        }
        this.drawDots(EventScreen.currentEventArray.length, nextEvent, 0, ApplicationData.screenHeight / 2 + this.cityBg.GetHeight() / 3 - ObjectsCache.menuWhiteDot.GetHeight() * 3);
        this.drawStats(ApplicationData.screenHeight / 2 + this.cityBg.GetHeight() * 3 / 4);
        Utils.drawString(ApplicationData.defaultFont.encodeDynamicString(SelectTrack.cities[CGUserCareer.m_nRaceID]), ApplicationData.screenWidth / 2, ObjectsCache.menuTitle.GetHeight() + ApplicationData.defaultFont.getFontHeight() * 3 / 2, 17, 0);
    }

    private void drawStats(int n) {
        Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, "ID_TRACK_LENGTH"), ApplicationData.screenWidth / 12, n, 20, 0);
        Utils.drawString(ApplicationData.defaultFont.encodeDynamicString(this.trackStats.getLength(CGUserCareer.m_nRaceID).toString() + "m"), ApplicationData.screenWidth * 70 / 100, n, 20, 0);
        int n2 = ApplicationData.defaultFont.getFontSpacing() * 2 + ApplicationData.defaultFont.getFontHeight();
        Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, "ID_TRACK_BESTTIME"), ApplicationData.screenWidth / 12, n += n2, 20, 0);
        int n3 = CGUserCareer.tracksTime[CGUserCareer.m_nRaceID];
        if (n3 == Integer.MAX_VALUE) {
            Utils.drawString(ApplicationData.defaultFont.encodeDynamicString("--:--:--"), ApplicationData.screenWidth * 70 / 100, n, 20, 0);
        } else {
            Utils.drawString(ApplicationData.defaultFont.encodeDynamicString(Utils.formatTimeAsc(n3)), ApplicationData.screenWidth, n, 24, 0);
        }
    }

    public boolean rightSoftButton() {
        UIScreen.SetCurrentScreen(new MainMenu());
        return true;
    }

    public boolean leftSoftButton() {
        CGEngine.selectedTrack = EventScreen.currentEventArray[nextEvent];
        UIScreen.SetCurrentScreen(new LoadingLevelScreen());
        return false;
    }

    public boolean onFireAction() {
        return this.leftSoftButton();
    }

    public boolean onLeftAction() {
        return true;
    }

    public boolean onRightAction() {
        return true;
    }

    public boolean actionSoftButton(int n, boolean bl) {
        if (bl && n >= 100 && n <= 102) {
            this.uncheckAllButtons();
        }
        if (super.actionSoftButton(n, bl)) {
            this.findCheck();
            return true;
        }
        if (!bl) {
            this.unselectAllButtons();
            if (n == 100) {
                UIScreen.SetCurrentScreen(new GeneralListForCareer());
            }
            if (n == 101) {
                CGEngine.selectedTrack = CGUserCareer.m_nRaceID;
                CGEngine.selectedRaceType = CGEngine.raceIDtoRaceType[CGUserCareer.m_nRaceID];
                UIScreen.SetCurrentScreen(new LoadingLevelScreen());
            }
        }
        return false;
    }

    private void drawDots(int n, int n2, int n3, int n4) {
        if (n > 0) {
            int n5 = ApplicationData.screenWidth / 2 - n * 18 / 3;
            for (int i = 0; i < n; ++i) {
                int n6 = n5 + i * 14;
                Graphic2D.DrawImage(i == n2 ? ObjectsCache.menuWhiteDot : ObjectsCache.menuRedDot, n6, n4, 17);
            }
        }
    }

    protected class TrackStats {
        private Vector length = new Vector();
        private Vector longest = new Vector();

        public TrackStats() {
            Random random = new Random();
            for (int i = 0; i < 9; ++i) {
                this.length.addElement(new Integer(CGEngine.trackLength[i] / 40960));
                this.longest.addElement(new Integer(Math.abs(random.nextInt() % 2000 + 1000)));
            }
        }

        public Object getLength(int n) {
            return this.length.elementAt(n);
        }

        public Object getLongest(int n) {
            return this.longest.elementAt(n);
        }
    }
}

