/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.graphic2d;

import baltorogames.graphic2d.Graphic2D;
import java.io.InputStream;
import javax.microedition.lcdui.Image;

public class CGTexture {
    public String m_szName = new String("");
    public Image m_Image = null;
    public int[] m_ImageBuf = null;
    public int m_nSizeX;
    public int m_nSizeY;
    public Image[] m_MipMaps = null;
    public static int m_nNrOfMipMaps = 10;
    public static int m_NrOfMipMapsForObjects = 4;
    public static int m_NrOfMipMapsForBolids = 10;
    public static boolean m_nReadFromNet = true;
    public boolean m_bLockDelete = false;
    protected float m_fScaleX = 1.0f;
    protected float m_fScaleY = 1.0f;

    public static void Init(int n, int n2) {
        m_NrOfMipMapsForObjects = n;
        m_nNrOfMipMaps = m_NrOfMipMapsForBolids = n2;
    }

    public int Create(InputStream inputStream, String string, int n, int n2, int[] nArray, int[] nArray2) {
        Image image = null;
        if (image == null) {
            try {
                image = Image.createImage((InputStream)inputStream);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (image == null) {
                return 0;
            }
        }
        this.m_nSizeX = image.getWidth();
        this.m_nSizeY = image.getHeight();
        if (n > 0) {
            this.CreateBufferFrom(image);
        } else if (n2 > 0) {
            this.CreateMipMaps(image, nArray, nArray2);
        } else {
            this.m_Image = image;
        }
        return 1;
    }

    public int Create(String string, int n, int n2, int[] nArray, int[] nArray2) {
        Image image = null;
        if (image == null) {
            try {
                image = Image.createImage((String)string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("EXCEPTION: Image.createImage !!!" + string);
                return 0;
            }
            if (image == null) {
                System.out.println("EXCEPTION: Image.createImage !!!" + string);
                return 0;
            }
        }
        this.m_nSizeX = image.getWidth();
        this.m_nSizeY = image.getHeight();
        if (n > 0) {
            this.CreateBufferFrom(image);
        } else if (n2 > 0) {
            String string2 = string.substring(0, string.length() - 4);
            int n3 = nArray.length;
            this.m_MipMaps = new Image[n3];
            this.m_MipMaps[n3 - 1] = image;
            for (int i = 0; i <= n3 - 2; ++i) {
                String string3 = string2 + "_mm" + (i + 1) + ".png";
                try {
                    this.m_MipMaps[i] = Image.createImage((String)string3);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.m_MipMaps[i] != null) continue;
                this.m_MipMaps[i] = image;
            }
        } else {
            this.m_Image = image;
        }
        return 1;
    }

    public void CreateMipMaps(Image image, int[] nArray, int[] nArray2) {
        if (this.m_MipMaps != null) {
            return;
        }
        this.m_MipMaps = new Image[m_nNrOfMipMaps];
        for (int i = 0; i < m_nNrOfMipMaps; ++i) {
            if (nArray[i] <= 0) {
                nArray[i] = 1;
            }
            if (nArray2[i] <= 0) {
                nArray2[i] = 1;
            }
            this.m_MipMaps[i] = Graphic2D.ScaleImage(image, nArray[i], nArray2[i]);
        }
    }

    public void CreateBufferFrom(Image image) {
        if (this.m_ImageBuf != null) {
            return;
        }
        this.m_ImageBuf = new int[this.m_nSizeX * this.m_nSizeY];
        image.getRGB(this.m_ImageBuf, 0, this.m_nSizeX, 0, 0, this.m_nSizeX, this.m_nSizeY);
    }

    public int GetWidth() {
        return this.m_Image.getWidth();
    }

    public int GetHeight() {
        return this.m_Image.getHeight();
    }

    public void SetImage(Image image) {
        this.m_Image = image;
        this.m_nSizeX = image.getWidth();
        this.m_nSizeY = image.getHeight();
    }

    public void SetName(String string) {
        this.m_szName = string;
    }

    public void Clear() {
        this.m_Image = null;
        for (int i = 0; i < this.m_MipMaps.length; ++i) {
            this.m_MipMaps[i] = null;
        }
        this.m_MipMaps = null;
    }
}

