/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.core_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIButton;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;

public class UIResultTableButton
extends UIButton {
    public static final int ANIM_FROM_RIGHT = 0;
    public static final int ANIM_FROM_LEFT = 1;
    public static final int ANIM_FROM_BOTTOM = 2;
    public static final int ANIM_FROM_TOP = 3;
    private String position = null;
    private String riderName = null;
    private String time = null;
    private String points = null;
    private String caption = null;
    private String value = null;
    public static final int EMPTY = -1;
    public static int typeOfAnimation = 0;
    protected CGTexture flagueTexture;
    protected boolean isFlagueTexture = false;

    public UIResultTableButton() {
    }

    public UIResultTableButton(int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4, n5);
    }

    public UIResultTableButton(int n, int n2, String string, String string2, String string3, int n3) {
        super(n, n2, string, string2, string3, n3);
    }

    public UIResultTableButton(int n, int n2, CGTexture cGTexture, CGTexture cGTexture2, CGTexture cGTexture3, CGTexture cGTexture4, int n3) {
        super(n, n2, cGTexture, cGTexture2, cGTexture3, n3);
        if (cGTexture4 != null) {
            this.flagueTexture = cGTexture4;
            this.isFlagueTexture = false;
        }
    }

    public UIResultTableButton(int n, int n2, CGTexture cGTexture, int n3, int n4) {
        this.buttonID = n4;
        this.top = n2;
        this.left = n;
        this.textures = new CGTexture[3];
        this.textures[0] = cGTexture;
        if (cGTexture != null) {
            this.bottom = this.top + this.textures[0].GetHeight();
            this.right = this.left + this.textures[0].GetWidth();
        }
        this.buttonID = n4;
        this.isReadyForSelect = false;
        this.isSelected = false;
        this.isVisible = true;
        this.isActive = true;
        this.currentleft = this.left;
        this.currenttop = this.top;
        if (n3 != -1) {
            this.flagueTexture = ObjectsCache.labelForButton[n3];
            this.isFlagueTexture = false;
        }
    }

    public void draw() {
        if (!this.isReadyForSelect) {
            switch (typeOfAnimation) {
                case 0: {
                    if (this.leftstart > this.left && this.currentleft > this.left) {
                        this.currentleft -= ApplicationData.stepDeltaTime * 3 * ApplicationData.screenWidth / 1000;
                        if (this.currentleft < this.left) {
                            this.currentleft = this.left;
                        }
                    }
                    if (this.leftstart >= this.left || this.currentleft >= this.left) break;
                    this.currentleft += ApplicationData.stepDeltaTime * 3 * ApplicationData.screenWidth / 1000;
                    if (this.currentleft <= this.left) break;
                    this.currentleft = this.left;
                    break;
                }
                case 1: {
                    if (this.leftstart < this.left && this.currentleft < this.left) {
                        this.currentleft += ApplicationData.stepDeltaTime * 3 * ApplicationData.screenWidth / 1000;
                        if (this.currentleft > this.left) {
                            this.currentleft = this.left;
                        }
                    }
                    if (this.leftstart <= this.left || this.currentleft <= this.left) break;
                    this.currentleft -= ApplicationData.stepDeltaTime * 3 * ApplicationData.screenWidth / 1000;
                    if (this.currentleft >= this.left) break;
                    this.currentleft = this.left;
                    break;
                }
                case 3: {
                    break;
                }
            }
            if (this.isVisible) {
                int n;
                if (!this.isActive) {
                    if (this.textures[2] != null) {
                        Graphic2D.DrawImage(this.textures[2], this.currentleft, this.top, 20);
                    }
                    if (this.isFlagueTexture) {
                        Graphic2D.DrawImage(this.flagueTexture, this.currentleft, this.top, 20);
                    }
                } else if (ObjectsCache.resultScreenButton != null) {
                    Graphic2D.DrawImage(this.textures[0], this.currentleft, this.top, 20);
                    if (this.isFlagueTexture) {
                        Graphic2D.DrawImage(this.flagueTexture, this.currentleft, this.top, 20);
                    }
                }
                if (this.caption != null) {
                    n = this.currentleft + ObjectsCache.resultScreenButton.GetWidth() * 11 / 100;
                    Utils.drawString(this.caption, n, (this.top + this.bottom) / 2, 6, 0);
                }
                if (this.value != null) {
                    n = this.currentleft + ObjectsCache.resultScreenButton.GetWidth() * 87 / 100;
                    Utils.drawString(this.value, n, (this.top + this.bottom) / 2, 3, 0);
                }
            }
        }
    }

    public void drawRemoveButton() {
        super.drawRemoveButton();
        if (this.isReadyForSelect) {
            if (this.currentleft <= ApplicationData.screenWidth) {
                this.currentleft += ApplicationData.stepDeltaTime * 3 * ApplicationData.screenWidth / 1000;
            }
            if (this.textures[1] != null && this.isVisible) {
                Graphic2D.DrawImage(this.textures[0], this.currentleft, this.top, 20);
                if (this.isFlagueTexture) {
                    Graphic2D.DrawImage(this.flagueTexture, this.currentleft, this.top, 20);
                }
            }
            if (this.caption != null && this.caption.length() > 0) {
                int n = this.currentleft + (this.right - this.left) / 2;
                Utils.drawString(this.caption, n, (this.top + this.bottom) / 2, 3, this.fontID);
            }
        }
    }

    public void setButtonCaption(String string) {
        this.caption = ApplicationData.lp.getTranslatedString(Options.languageID, string);
    }

    public void setButtonValue(int n) {
        this.value = ApplicationData.defaultFont.encodeDynamicString(Integer.toString(n));
    }

    public void setDrawClicked(boolean bl) {
        this.isFlagueTexture = bl;
    }

    public boolean getDrawClicked() {
        return this.isFlagueTexture;
    }

    public void setFlaguelImage(CGTexture cGTexture) {
        this.flagueTexture = cGTexture;
    }

    public void setSelect(boolean bl) {
        this.isSelected = bl;
    }

    public boolean getSelect() {
        return this.isSelected;
    }

    public void setReadyForSelected(boolean bl) {
        this.isReadyForSelect = bl;
    }

    public String getPosition() {
        return this.position;
    }

    public void setPosition(String string) {
        this.position = string;
    }

    public String getRiderName() {
        return this.riderName;
    }

    public void setRiderName(String string) {
        this.riderName = string;
    }

    public String getTime() {
        return this.time;
    }

    public void setTime(String string) {
        this.time = string;
    }

    public String getPoints() {
        return this.points;
    }

    public void setPoints(String string) {
        this.points = string;
    }
}

