/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.core_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;

public class UIButton {
    protected int top;
    protected int left;
    protected int bottom;
    protected int right;
    protected boolean blinkMode = false;
    protected String caption = null;
    protected int fontID = 0;
    protected String caption2 = null;
    protected String value = null;
    protected int buttonID;
    protected boolean isActive;
    protected boolean isVisible;
    protected boolean isSelected;
    protected boolean isChecked;
    protected boolean isReadyForSelect;
    public int leftstart;
    public int currentleft;
    public int currenttop;
    protected UIScreen ownScreen = null;
    public CGTexture[] textures = null;
    protected CGTexture firstPlaneTexture = null;

    public void setScreen(UIScreen uIScreen) {
        this.ownScreen = uIScreen;
    }

    public UIButton() {
        this.isSelected = false;
        this.isChecked = false;
        this.isVisible = true;
        this.isActive = true;
    }

    public UIButton(int n, int n2, int n3, int n4, int n5) {
        this.top = n2;
        this.left = n;
        this.bottom = n4;
        this.right = n3;
        this.buttonID = n5;
        this.isSelected = false;
        this.isChecked = false;
        this.isVisible = true;
        this.isActive = true;
    }

    public UIButton(int n, int n2, String string, String string2, String string3, int n3) {
        this.buttonID = n3;
        this.textures = new CGTexture[3];
        this.textures[0] = TextureManager.AddTexture(string);
        this.textures[1] = TextureManager.AddTexture(string2);
        this.textures[2] = TextureManager.AddTexture(string3);
        this.top = n2;
        this.left = n;
        this.bottom = this.top + this.textures[0].GetHeight();
        this.right = this.left + this.textures[0].GetWidth();
        this.buttonID = n3;
        this.isSelected = false;
        this.isChecked = false;
        this.isVisible = true;
        this.isActive = true;
    }

    public UIButton(int n, int n2, CGTexture cGTexture, CGTexture cGTexture2, CGTexture cGTexture3, int n3) {
        this.buttonID = n3;
        this.top = n2;
        this.left = n;
        if (cGTexture != null && cGTexture2 != null && cGTexture3 != null) {
            this.textures = new CGTexture[3];
            this.textures[0] = cGTexture;
            this.textures[1] = cGTexture2;
            this.textures[2] = cGTexture3;
            this.bottom = this.top + this.textures[0].GetHeight();
            this.right = this.left + this.textures[0].GetWidth();
        } else {
            this.textures = null;
            this.bottom = this.top + 10;
            this.right = this.left + 10;
        }
        this.buttonID = n3;
        this.isSelected = false;
        this.isVisible = true;
        this.isActive = true;
    }

    public void setBlink(boolean bl) {
        this.blinkMode = bl;
    }

    public void setPosition(int n, int n2, int n3, int n4) {
        this.top = n2;
        this.left = n;
        this.bottom = n4;
        this.right = n3;
    }

    public void setPosition(int n, int n2) {
        int n3 = this.right - this.left;
        int n4 = this.bottom - this.top;
        this.top = n2;
        this.left = n;
        this.bottom = this.top + n4;
        this.right = this.left + n3;
    }

    public void setLeft(int n) {
        int n2 = this.right - this.left;
        this.left = n;
        this.right = this.left + n2;
    }

    public void setTop(int n) {
        int n2 = this.bottom - this.top;
        this.top = n;
        this.bottom = this.top + n2;
    }

    public void SetFirstPlaneTexture(CGTexture cGTexture) {
        this.firstPlaneTexture = cGTexture;
    }

    public void SetFirstPlaneTexture(String string) {
        this.firstPlaneTexture = TextureManager.AddTexture(string);
    }

    public void changeNormalTextures(CGTexture cGTexture) {
        this.textures[0] = cGTexture;
        this.bottom = this.top + this.textures[0].GetHeight();
        this.right = this.left + this.textures[0].GetWidth();
    }

    public void setTextures(CGTexture cGTexture, CGTexture cGTexture2, CGTexture cGTexture3) {
        this.textures = new CGTexture[3];
        this.textures[0] = cGTexture;
        this.textures[1] = cGTexture2;
        this.textures[2] = cGTexture3;
        this.bottom = this.top + this.textures[0].GetHeight();
        this.right = this.left + this.textures[0].GetWidth();
    }

    public void setTextures(String string, String string2, String string3) {
        this.textures = new CGTexture[2];
        this.textures[0] = TextureManager.AddTexture(string);
        this.textures[1] = TextureManager.AddTexture(string2);
        this.textures[2] = TextureManager.AddTexture(string3);
        this.bottom = this.top + this.textures[0].GetHeight();
        this.right = this.left + this.textures[0].GetWidth();
    }

    public void setCaption(String string) {
        this.caption = string;
    }

    public void setCaption2(String string) {
        this.caption2 = string;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public void setFontID(int n) {
        this.fontID = n;
    }

    public void setID(int n) {
        this.buttonID = n;
    }

    public int getID() {
        return this.buttonID;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setSelect(boolean bl) {
        this.isSelected = bl;
    }

    public boolean getSelect() {
        return this.isSelected;
    }

    public void setCheck(boolean bl) {
        this.isChecked = bl;
    }

    public boolean getCheck() {
        return this.isChecked;
    }

    public void setVisible(boolean bl) {
        this.isVisible = bl;
    }

    public boolean getVisible() {
        return this.isVisible;
    }

    public void setActive(boolean bl) {
        this.isActive = bl;
    }

    public boolean getActive() {
        return this.isActive;
    }

    public void draw() {
        if (this.isVisible) {
            if (!this.isActive) {
                if (this.textures[2] != null) {
                    Graphic2D.DrawImage(this.textures[2], this.left, this.top, 20);
                }
            } else if (!this.isSelected && this.textures[0] != null) {
                Graphic2D.DrawImage(this.textures[0], this.left, this.top, 20);
            } else if (this.isSelected && this.textures[1] != null) {
                Graphic2D.DrawImage(this.textures[1], this.left, this.top, 20);
            }
            if (this.firstPlaneTexture != null) {
                Graphic2D.DrawImage(this.firstPlaneTexture, this.left, this.top, 20);
            }
            if (this.caption != null && this.caption.length() > 0) {
                if (this.blinkMode) {
                    if (ApplicationData.getAppTime() % 700L < 350L) {
                        int n = (this.left + this.right) / 2;
                        Utils.drawString(this.caption, (this.left + this.right) / 2, (this.top + this.bottom) / 2, 3, this.fontID);
                    }
                } else {
                    int n = (this.left + this.right) / 2;
                    Utils.drawString(this.caption, (this.left + this.right) / 2, (this.top + this.bottom) / 2, 3, this.fontID);
                }
            }
        }
    }

    public boolean ckeckTouch(int n, int n2) {
        return this.isVisible && this.isActive && n >= this.left && n <= this.right && n2 >= this.top && n2 <= this.bottom;
    }

    public void drawRemoveButton() {
    }

    public void setInitLeft(int n) {
        this.currentleft = this.leftstart = n;
    }
}

