/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.ApplicationData;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGEngine;
import java.util.Vector;

public class CJAnimation {
    int nTime;
    int nMaxAnimTime = 2000;
    private Vector frames = new Vector();
    int[] arrWidth = new int[CGTexture.m_nNrOfMipMaps == 0 ? 1 : CGTexture.m_nNrOfMipMaps];
    int[] arrHeight;

    public CJAnimation() {
        int n;
        if (CGTexture.m_nNrOfMipMaps == 0) {
            CGTexture.m_nNrOfMipMaps = 1;
        }
        long l = 8L * CGEngine.testApp.GetMaxObjectsDistanceScale() / 10L;
        long l2 = (4096L - l) / (long)CGTexture.m_nNrOfMipMaps;
        for (n = 0; n < CGTexture.m_nNrOfMipMaps; ++n) {
            this.arrWidth[n] = (int)(CGEngine.testApp.m_Camera.m_fxCameraScale * 64L * (l + (long)n * l2) / 4096L / 4096L);
        }
        this.arrHeight = new int[CGTexture.m_nNrOfMipMaps == 0 ? 1 : CGTexture.m_nNrOfMipMaps];
        if (CGTexture.m_nNrOfMipMaps == 0) {
            CGTexture.m_nNrOfMipMaps = 1;
        }
        l = 8L * CGEngine.testApp.GetMaxObjectsDistanceScale() / 10L;
        l2 = (4096L - l) / (long)CGTexture.m_nNrOfMipMaps;
        for (n = 0; n < CGTexture.m_nNrOfMipMaps; ++n) {
            this.arrHeight[n] = (int)(CGEngine.testApp.m_Camera.m_fxCameraScale * 64L * (l + (long)n * l2) / 4096L / 4096L);
        }
    }

    public void init(int n) {
        int n2 = 1;
        String string = "/gameplay/fall" + ++n + "/" + n2 + ".png";
        while (true) {
            string = "/gameplay/fall" + n + "/" + n2 + ".png";
            try {
                CGTexture cGTexture = TextureManager.AddTexture(string, 0, 1, this.arrWidth, this.arrHeight);
                if (cGTexture == null) break;
                this.frames.addElement(cGTexture);
                System.out.println("Loaded file = " + string);
            }
            catch (Exception exception) {
                return;
            }
            ++n2;
        }
    }

    public CGTexture getCurrentFrameTexture(int n) {
        return (CGTexture)this.frames.elementAt(n);
    }

    public int getNumFrames() {
        return this.frames.size();
    }

    public void startAnim() {
        this.nTime = 0;
    }

    public CGTexture getFrame() {
        int n;
        this.nTime += ApplicationData.stepDeltaTime;
        if (this.nTime > this.nMaxAnimTime) {
            this.nTime = this.nMaxAnimTime;
        }
        if ((n = (int)((float)this.nTime / (float)this.nMaxAnimTime * (float)(this.frames.size() - 1))) + 1 == this.frames.size() - 1) {
            // empty if block
        }
        return (CGTexture)this.frames.elementAt(n);
    }
}

