/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.project_gameplay.CGBillboardObject;
import baltorogames.project_gameplay.CGTrack;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;

public class CGTrackPiece {
    public static int TRACK_PIECE_LINE = 0;
    public static int TRACK_PIECE_TURN = 1;
    public static int TRACK_PIECE_BEZIER = 2;
    public Vector m_arrObjects = new Vector();
    public int m_nPieceType;
    public int m_nPieceLength;
    public int m_nPieceAngle;
    public int m_nPieceHeight;
    public int m_nPieceBezierSize;

    public void ResetObj() {
        this.m_arrObjects.removeAllElements();
    }

    public int GetObjectsSize() {
        return this.m_arrObjects.size();
    }

    public CGBillboardObject GetObject(int n) {
        return (CGBillboardObject)this.m_arrObjects.elementAt(n);
    }

    public void AddObject(CGBillboardObject cGBillboardObject) {
        int n = this.m_arrObjects.size();
        for (int i = 0; i < n; ++i) {
            CGBillboardObject cGBillboardObject2 = this.GetObject(i);
            if (cGBillboardObject2.m_fxDistanceFromStart <= cGBillboardObject.m_fxDistanceFromStart) continue;
            this.m_arrObjects.insertElementAt(cGBillboardObject, i);
            return;
        }
        this.m_arrObjects.addElement(cGBillboardObject);
    }

    public void deSerialize(DataInputStream dataInputStream) throws IOException {
        this.m_nPieceType = dataInputStream.readByte();
        this.m_nPieceLength = dataInputStream.readInt();
        this.m_nPieceAngle = -dataInputStream.readByte() * 5;
        this.m_nPieceHeight = dataInputStream.readInt();
        this.m_nPieceHeight = 0;
        if (CGTrack.m_bInvertTrackFlag) {
            this.m_nPieceAngle = -this.m_nPieceAngle;
            this.m_nPieceHeight = -this.m_nPieceHeight;
        }
        this.m_nPieceBezierSize = dataInputStream.readByte() * 10;
        int n = dataInputStream.readByte();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                CGBillboardObject cGBillboardObject = new CGBillboardObject();
                cGBillboardObject.deSerialize(dataInputStream);
                this.m_arrObjects.addElement(cGBillboardObject);
            }
        }
    }
}

